/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.Z3Object;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;

class Z3ReferenceQueue {
    private final Context ctx;
    private final ReferenceQueue<Z3Object> referenceQueue = new ReferenceQueue();
    private final Reference<?> referenceList = Z3ReferenceQueue.emptyList();

    Z3ReferenceQueue(Context context) {
        this.ctx = context;
    }

    <T extends Z3Object> void storeReference(T t, ReferenceConstructor<T> referenceConstructor) {
        this.referenceList.insert(referenceConstructor.construct(t, this.referenceQueue));
        this.clear();
    }

    private void clear() {
        Reference reference;
        while ((reference = (Reference)this.referenceQueue.poll()) != null) {
            reference.cleanup(this.ctx);
        }
    }

    public void forceClear() {
        Reference<?> reference = this.referenceList.next;
        while (reference.next != null) {
            reference.decRef(this.ctx, reference.nativePtr);
            reference = reference.next;
        }
        this.referenceList.next = reference;
        reference.prev = this.referenceList;
        while (this.referenceQueue.poll() != null) {
        }
    }

    private static Reference<?> emptyList() {
        DummyReference dummyReference;
        DummyReference dummyReference2 = new DummyReference();
        dummyReference2.next = dummyReference = new DummyReference();
        dummyReference.prev = dummyReference2;
        return dummyReference2;
    }

    static abstract class Reference<T extends Z3Object>
    extends PhantomReference<T> {
        private Reference<?> prev;
        private Reference<?> next;
        private final long nativePtr;

        Reference(T t, ReferenceQueue<Z3Object> referenceQueue) {
            super(t, referenceQueue);
            this.nativePtr = t != null ? ((Z3Object)t).getNativeObject() : 0L;
        }

        private void cleanup(Context context) {
            this.decRef(context, this.nativePtr);
            assert (this.prev != null && this.next != null);
            this.prev.next = this.next;
            this.next.prev = this.prev;
        }

        private void insert(Reference<?> reference) {
            assert (this.next != null);
            reference.prev = this;
            reference.next = this.next;
            reference.next.prev = reference;
            this.next = reference;
        }

        abstract void decRef(Context var1, long var2);
    }

    @FunctionalInterface
    static interface ReferenceConstructor<T extends Z3Object> {
        public Reference<T> construct(T var1, ReferenceQueue<Z3Object> var2);
    }

    private static class DummyReference
    extends Reference<Z3Object> {
        public DummyReference() {
            super(null, (ReferenceQueue<Z3Object>)null);
        }

        @Override
        void decRef(Context context, long l) {
            assert (false);
        }
    }
}

