/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FetchDirection;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jdbc.AbstractFetcher;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FetchConfig;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NullMarked
class FBStatementFetcher
extends AbstractFetcher
implements FBFetcher {
    private static final int NO_ASYNC_FETCH = -1;
    private static final int MINIMUM_ASYNC_FETCH_ROW_COUNT = 10;
    private static final int ASYNC_FETCH_FACTOR = 3;
    private boolean wasFetched;
    protected final GDSHelper gdsHelper;
    private int maxActualFetchSize;
    private int asyncFetchOnRemaining = -1;
    protected final FbStatement stmt;
    private Deque<RowValue> rows;
    private final RowListener rowListener = new RowListener();
    private boolean allRowsFetched;
    protected @Nullable RowValue nextRow;
    private int rowNum;
    private boolean isEmpty;
    private boolean isBeforeFirst = true;
    private boolean isFirst;
    private boolean isLast;
    private boolean isAfterLast;

    FBStatementFetcher(GDSHelper gdsHelper, FetchConfig fetchConfig, FbStatement stmth, FBObjectListener.FetcherListener fetcherListener) {
        super(fetchConfig, fetcherListener);
        this.gdsHelper = gdsHelper;
        this.stmt = stmth;
        this.stmt.addStatementListener(this.rowListener);
        this.rows = stmth.getClass().getName().equals("org.firebirdsql.gds.ng.jna.JnaStatement") ? new ArrayDeque<RowValue>(1) : new ArrayDeque<RowValue>();
    }

    protected @Nullable RowValue getNextRow() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.nextRow;
    }

    protected void setNextRow(@Nullable RowValue nextRow) {
        this.nextRow = nextRow;
        if (!this.wasFetched) {
            this.wasFetched = true;
            if (nextRow == null) {
                this.isEmpty = true;
            } else {
                this.isBeforeFirst = true;
            }
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        this.setIsBeforeFirst(false);
        this.setIsFirst(false);
        this.setIsLast(false);
        this.setIsAfterLast(false);
        if (this.isEmpty()) {
            return false;
        }
        int maxRows = this.getMaxRows();
        if (this.getNextRow() == null || maxRows != 0 && this.getRowNum() == maxRows) {
            this.setIsAfterLast(true);
            this.allRowsFetched = true;
            this.setRowNum(0);
            return false;
        }
        this.notifyRowChanged(this.getNextRow());
        this.fetch();
        this.setRowNum(this.getRowNum() + 1);
        if (this.getRowNum() == 1) {
            this.setIsFirst(true);
        }
        if (this.getNextRow() == null || maxRows != 0 && this.getRowNum() == maxRows) {
            this.setIsLast(true);
        }
        return true;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw FBStatementFetcher.notScrollable();
    }

    @Override
    public boolean first() throws SQLException {
        throw FBStatementFetcher.notScrollable();
    }

    @Override
    public boolean last() throws SQLException {
        throw FBStatementFetcher.notScrollable();
    }

    @Override
    public boolean previous() throws SQLException {
        throw FBStatementFetcher.notScrollable();
    }

    @Override
    public boolean relative(int row) throws SQLException {
        throw FBStatementFetcher.notScrollable();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw FBStatementFetcher.notScrollable();
    }

    @Override
    public void afterLast() throws SQLException {
        throw FBStatementFetcher.notScrollable();
    }

    protected final void fetch() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            int actualFetchSize;
            this.checkOpen();
            if (!this.allRowsFetched && this.rows.isEmpty()) {
                int actualFetchSize2 = this.actualFetchSize();
                if (actualFetchSize2 > 0) {
                    this.stmt.fetchRows(actualFetchSize2);
                }
            } else if (!this.allRowsFetched && this.rows.size() == this.asyncFetchOnRemaining && (actualFetchSize = this.actualFetchSize()) > 1) {
                this.stmt.asyncFetchRows(actualFetchSize);
            }
            this.setNextRow(this.rows.pollFirst());
        }
    }

    @Override
    protected int actualFetchSize() {
        int fetchSize = super.actualFetchSize();
        int maxRows = this.getMaxRows();
        if (maxRows == 0) {
            return fetchSize;
        }
        return Math.min(fetchSize, maxRows - this.rowNum - this.rows.size());
    }

    @Override
    protected void handleClose(CompletionReason completionReason) throws SQLException {
        try {
            this.stmt.closeCursor(completionReason.isTransactionEnd() || completionReason.isCompletesStatement());
        }
        finally {
            this.stmt.removeStatementListener(this.rowListener);
            this.rows = new ArrayDeque<RowValue>(0);
        }
    }

    @Override
    public int getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(int rowNumValue) {
        this.rowNum = rowNumValue;
    }

    @Override
    public boolean isEmpty() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isEmpty;
    }

    public void setIsEmpty(boolean isEmptyValue) {
        this.isEmpty = isEmptyValue;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isBeforeFirst;
    }

    public void setIsBeforeFirst(boolean isBeforeFirstValue) {
        this.isBeforeFirst = isBeforeFirstValue;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isFirst;
    }

    public void setIsFirst(boolean isFirstValue) {
        this.isFirst = isFirstValue;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isLast;
    }

    public void setIsLast(boolean isLastValue) {
        this.isLast = isLastValue;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isAfterLast;
    }

    public void setIsAfterLast(boolean isAfterLastValue) {
        this.isAfterLast = isAfterLastValue;
    }

    @Override
    public void deleteRow() throws SQLException {
    }

    @Override
    public void insertRow(RowValue data) throws SQLException {
    }

    @Override
    public void updateRow(RowValue data) throws SQLException {
    }

    @Override
    public int currentPosition() throws SQLException {
        throw new FBDriverNotCapableException("Cannot report current position. This is a bug in the calling code, because this method is not expected to be called on this implementation");
    }

    @Override
    public int size() throws SQLException {
        throw new FBDriverNotCapableException("Cannot report total size. This is a bug in the calling code, because this method is not expected to be called on this implementation");
    }

    private static SQLException notScrollable() {
        return FbExceptionBuilder.toNonTransientException(337248279);
    }

    @Override
    protected LockCloseable withLock() {
        return this.stmt.withLock();
    }

    private final class RowListener
    implements StatementListener {
        private RowListener() {
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            FBStatementFetcher.this.rows.addLast(rowValue);
        }

        @Override
        public void afterLast(FbStatement sender) {
            FBStatementFetcher.this.allRowsFetched = true;
        }

        @Override
        public void fetchComplete(FbStatement sender, FetchDirection fetchDirection, int rows) {
            if (rows > FBStatementFetcher.this.maxActualFetchSize) {
                FBStatementFetcher.this.maxActualFetchSize = rows;
                if (rows >= 15) {
                    FBStatementFetcher.this.asyncFetchOnRemaining = Math.max(rows / 3, 10);
                }
            }
        }
    }
}

