/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.associations;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.ermodel.associations.ImplicitAssociationsUtility;
import schemacrawler.ermodel.associations.TableMatchKeys;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Table;
import us.fatehi.utility.string.StringFormat;

final class ExtensionTableMatcher
implements Predicate<ColumnReference> {
    private static final Logger LOGGER = Logger.getLogger(ExtensionTableMatcher.class.getName());
    private final TableMatchKeys tableMatchKeys;

    public ExtensionTableMatcher(TableMatchKeys tableMatchKeys) {
        this.tableMatchKeys = Objects.requireNonNull(tableMatchKeys, "No table match keys provided");
    }

    @Override
    public boolean test(ColumnReference proposedAssociation) {
        String fkColumnName;
        if (proposedAssociation == null) {
            return false;
        }
        Column fkColumn = proposedAssociation.getForeignKeyColumn();
        Column pkColumn = proposedAssociation.getPrimaryKeyColumn();
        String pkColumnName = ImplicitAssociationsUtility.normalizeColumnName(pkColumn);
        if (pkColumnName.equals(fkColumnName = ImplicitAssociationsUtility.normalizeColumnName(fkColumn))) {
            boolean matches;
            Table pkTable = (Table)pkColumn.getParent();
            boolean fkIsUnique = fkColumn.isPartOfPrimaryKey() || fkColumn.isPartOfUniqueIndex();
            boolean bl = matches = fkIsUnique && this.tableMatchKeys.isTopRankedCandidate(pkTable);
            if (matches) {
                LOGGER.log(Level.FINE, new StringFormat("ExtensionTableMatcher proposed <%s>", proposedAssociation));
            }
            return matches;
        }
        return false;
    }
}

