/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.net.Socket;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnStrategy;
import oracle.net.nt.MetricsEnabledSSLSocketFactoryWrapper;
import oracle.security.jps.service.keystore.KeyStoreServiceLoadStoreParameter;

public class CustomSSLSocketFactory {
    public static final String DEFAULT_SSO_WALLET_FILE_NAME = "cwallet.sso";
    public static final String DEFAULT_PKCS12_WALLET_FILE_NAME = "ewallet.p12";
    public static final String SSO_WALLET_TYPE = "SSO";
    public static final String PKCS12_WALLET_TYPE = "PKCS12";
    public static final String PKCS11_WALLET_TYPE = "PKCS11";
    public static final String WINDOWS_MY_WALLET_TYPE = "Windows-MY";
    public static final String JKS_TYPE = "JKS";
    public static final String KSS_TYPE = "KSS";
    public static final String SUPPORTED_METHOD_TYPE = "FILE";
    private static final String SSO_FILE_EXTENSION = ".sso";
    private static final String P12_FILE_EXTENSION = ".p12";
    private static final String PFX_FILE_EXTENSION = ".pfx";
    private static final String JKS_FILE_EXTENSION = ".jks";
    private static final String KSS_URI_SCHEME = "kss://";
    private static final String ORACLE_PKI_PROVIDER_CLASS = "oracle.security.pki.OraclePKIProvider";
    private static final String KSS_PROVIDER_CLASS = "oracle.security.jps.internal.keystore.provider.FarmKeyStoreProvider";
    public static SSLSocketFactory defSSLFactory;
    public static boolean initDefFactory;
    private static final Monitor DEF_FACTORY_INIT_MONITOR;
    private static SSLContext defSSLContext;
    private static boolean initDefSSLContext;
    private static final Monitor DEF_CONTEXT_INIT_MONITOR;
    private static final SSLConfig DEF_CONTEXT_CONFIG;
    DMSFactory.DMSNoun dmsParent = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    private CustomSSLSocketFactory() {
    }

    public static SSLSocketFactory getSSLSocketFactory(Properties sslSocketProperties, DMSFactory.DMSNoun dmsParent) throws IOException {
        SSLSocketFactory result = null;
        SSLConfig config = CustomSSLSocketFactory.readSSLConfig(sslSocketProperties);
        if (config.keyStore != null && config.keyStore.equalsIgnoreCase("NONE") || config.trustStore != null && config.trustStore.equalsIgnoreCase("NONE")) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        SSLContext l_context = CustomSSLSocketFactory.getSSLContext(config);
        if (l_context == defSSLContext) {
            if (!initDefFactory) {
                try (Monitor.CloseableLock lock = DEF_FACTORY_INIT_MONITOR.acquireCloseableLock();){
                    if (!initDefFactory) {
                        defSSLFactory = l_context.getSocketFactory();
                        initDefFactory = true;
                    }
                }
            }
            result = defSSLFactory;
        } else {
            result = l_context.getSocketFactory();
            result = new MetricsEnabledSSLSocketFactoryWrapper(result, dmsParent);
        }
        return result;
    }

    public static SSLEngine getSSLSocketEngine(String host, int port, @Blind(value=PropertiesBlinder.class) Properties sslSocketProperties) throws IOException {
        SSLConfig config = CustomSSLSocketFactory.readSSLConfig(sslSocketProperties);
        if (config.keyStore != null && config.keyStore.equalsIgnoreCase("NONE") || config.trustStore != null && config.trustStore.equalsIgnoreCase("NONE")) {
            try {
                SSLEngine defSSLEngine = SSLContext.getDefault().createSSLEngine();
                defSSLEngine.setUseClientMode(true);
                return defSSLEngine;
            }
            catch (NoSuchAlgorithmException nae) {
                NetException netException = new NetException(410);
                netException.initCause(nae);
                throw netException;
            }
        }
        SSLEngine result = CustomSSLSocketFactory.getSSLContext(config).createSSLEngine(host, port);
        result.setUseClientMode(true);
        return result;
    }

    private static SSLContext getSSLContext(SSLConfig config) throws IOException {
        if (config.equals(DEF_CONTEXT_CONFIG)) {
            if (!initDefSSLContext) {
                try (Monitor.CloseableLock lock = DEF_CONTEXT_INIT_MONITOR.acquireCloseableLock();){
                    if (!initDefSSLContext) {
                        defSSLContext = CustomSSLSocketFactory.createSSLContext(config);
                        initDefSSLContext = true;
                    }
                }
            }
            return defSSLContext;
        }
        return CustomSSLSocketFactory.createSSLContext(config);
    }

    private static SSLContext createSSLContext(SSLConfig sSLConfig) throws NetException {
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        try {
            SSLConfig config;
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            if (config.keyStore != null) {
                keyManagerArray = CustomSSLSocketFactory.getKeyManagerArray(config.keyStore, config.keyStorePassword, config.keyStoreType, config.keyManagerFacAlgo);
            }
            if (config.certificateAlias != null && config.certificateAlias.trim().length() != 0 && keyManagerArray != null) {
                keyManagerArray = CustomSSLSocketFactory.wrapWithAliasKeyManager(keyManagerArray, config.certificateAlias);
            }
            if (config.trustStore != null) {
                trustManagerArray = CustomSSLSocketFactory.getTrustManagerArray(config.trustStore, config.trustStorePassword, config.trustStoreType, config.trustManagerFacAlgo, config.isCaCertsTrusted);
            }
            SSLContext l_context = SSLContext.getInstance(config.sslContextProtocol);
            l_context.init(keyManagerArray, trustManagerArray, null);
            return l_context;
        }
        catch (Exception ex) {
            if (bl) {
                CustomSSLSocketFactory.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "Error in initializing ssl context" + ex.toString());
            }
            throw (NetException)new NetException(410).initCause(ex);
        }
    }

    private static X509ExtendedKeyManager[] wrapWithAliasKeyManager(KeyManager[] keyManagers, String alias) {
        X509ExtendedKeyManager[] newKeyManagers = new X509ExtendedKeyManager[keyManagers.length];
        for (int i2 = 0; i2 < keyManagers.length; ++i2) {
            newKeyManagers[i2] = new AliasKeyManager((X509KeyManager)keyManagers[i2], alias);
        }
        return newKeyManagers;
    }

    private static SSLConfig readSSLConfig(@Blind(value=PropertiesBlinder.class) Properties sslSocketProperties) throws NetException {
        String walletLocation = (String)sslSocketProperties.get(5);
        SSLConfig sslConfig = walletLocation == null ? CustomSSLSocketFactory.readJavaxNetSSLConfig(sslSocketProperties) : CustomSSLSocketFactory.readWalletSSLConfig(sslSocketProperties);
        sslConfig.sslContextProtocol = (String)sslSocketProperties.getOrDefault((Object)38, "TLS");
        sslConfig.isCaCertsTrusted = Boolean.valueOf((String)sslSocketProperties.get(41));
        return sslConfig;
    }

    private static SSLConfig readJavaxNetSSLConfig(@Blind(value=PropertiesBlinder.class) Properties sslSocketProperties) {
        SSLConfig config = new SSLConfig();
        config.keyStore = (String)sslSocketProperties.get(8);
        config.certificateAlias = (String)sslSocketProperties.get(29);
        if (config.keyStore != null) {
            config.keyStoreType = (String)sslSocketProperties.get(9);
            if (config.keyStoreType == null) {
                config.keyStoreType = CustomSSLSocketFactory.resolveKeyStoreType(config.keyStore);
            }
            config.keyStorePassword = (OpaqueString)sslSocketProperties.get(10);
            if (config.keyStorePassword == null || config.keyStorePassword == OpaqueString.NULL) {
                config.keyStorePassword = OpaqueString.EMPTY;
            }
            config.keyManagerFacAlgo = (String)sslSocketProperties.get(14);
            if (config.keyManagerFacAlgo == null) {
                config.keyManagerFacAlgo = Security.getProperty("ssl.keyManagerFactory.algorithm");
            }
            if (config.keyManagerFacAlgo == null) {
                config.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            }
        }
        config.trustStore = (String)sslSocketProperties.get(11);
        if (config.trustStore != null) {
            config.trustStoreType = (String)sslSocketProperties.get(12);
            if (config.trustStoreType == null) {
                config.trustStoreType = CustomSSLSocketFactory.resolveKeyStoreType(config.trustStore);
            }
            config.trustStorePassword = (OpaqueString)sslSocketProperties.get(13);
            if (config.trustStorePassword == null || config.trustStorePassword == OpaqueString.NULL) {
                config.trustStorePassword = OpaqueString.EMPTY;
            }
            config.trustManagerFacAlgo = (String)sslSocketProperties.get(15);
            if (config.trustManagerFacAlgo == null) {
                config.trustManagerFacAlgo = Security.getProperty("ssl.trustManagerFactory.algorithm");
            }
            if (config.trustManagerFacAlgo == null) {
                config.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
            }
        }
        return config;
    }

    private static SSLConfig readWalletSSLConfig(@Blind(value=PropertiesBlinder.class) Properties sslSocketProperties) throws NetException {
        String walletDirectory;
        SSLConfig config = new SSLConfig();
        config.certificateAlias = (String)sslSocketProperties.get(29);
        boolean walletFileSpecified = false;
        String walletLocation = (String)sslSocketProperties.get(5);
        if (walletLocation.startsWith("(")) {
            walletDirectory = CustomSSLSocketFactory.processWalletLocation(walletLocation);
        } else {
            walletDirectory = walletLocation.startsWith("file:") ? walletLocation.substring("file:".length()) : walletLocation;
            File walletFile = new File(walletDirectory);
            if (!walletFile.exists()) {
                throw new NetException(407, "Couldn't find file at " + walletDirectory);
            }
            if (!walletFile.isDirectory()) {
                walletFileSpecified = true;
            }
        }
        OpaqueString walletPassword = (OpaqueString)sslSocketProperties.get(16);
        if (walletPassword == null || walletPassword == OpaqueString.NULL) {
            config.keyStore = !walletFileSpecified ? walletDirectory + System.getProperty("file.separator") + DEFAULT_SSO_WALLET_FILE_NAME : walletDirectory;
            config.keyStoreType = SSO_WALLET_TYPE;
            config.keyStorePassword = OpaqueString.EMPTY;
            config.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            config.trustStore = config.keyStore;
            config.trustStoreType = SSO_WALLET_TYPE;
            config.trustStorePassword = OpaqueString.EMPTY;
            config.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
        } else {
            config.keyStore = !walletFileSpecified ? walletDirectory + System.getProperty("file.separator") + DEFAULT_PKCS12_WALLET_FILE_NAME : walletDirectory;
            config.keyStoreType = PKCS12_WALLET_TYPE;
            config.keyStorePassword = walletPassword;
            config.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            config.trustStore = config.keyStore;
            config.trustStoreType = PKCS12_WALLET_TYPE;
            config.trustStorePassword = walletPassword;
            config.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyManager[] getKeyManagerArray(String string, OpaqueString opaqueString, String string2, String string3) throws IOException {
        void keyManagerFacAlgo;
        void keyStoreType;
        String keyStore;
        boolean bl;
        boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
        if (bl) {
            CustomSSLSocketFactory.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "KEY STORE IS" + keyStore);
        }
        if (bl) {
            CustomSSLSocketFactory.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "KEY STORE TYPE IS" + (String)keyStoreType);
        }
        if (bl) {
            CustomSSLSocketFactory.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "KEY MANAGER FACTORY ALGORITHM" + (String)keyManagerFacAlgo);
        }
        try {
            void keyStorePassword;
            KeyStore instKeyStore = CustomSSLSocketFactory.loadKeyStore(keyStore, (String)keyStoreType, (OpaqueString)keyStorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)keyManagerFacAlgo);
            char[] pw = keyStorePassword.getChars();
            try {
                keyManagerFactory.init(instKeyStore, pw);
                if (pw == null) return keyManagerFactory.getKeyManagers();
            }
            catch (Throwable throwable) {
                if (pw == null) throw throwable;
                for (int i2 = 0; i2 < pw.length; ++i2) {
                    pw[i2] = '\u0000';
                }
                throw throwable;
            }
            for (int i3 = 0; i3 < pw.length; ++i3) {
                pw[i3] = '\u0000';
            }
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception ex) {
            if (!bl) throw (NetException)new NetException(408).initCause(ex);
            CustomSSLSocketFactory.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "Error in initializing key store " + ex.toString());
            throw (NetException)new NetException(408).initCause(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static TrustManager[] getTrustManagerArray(String string, OpaqueString opaqueString, String string2, String string3, boolean bl) throws IOException {
        void trustManagerFacAlgo;
        void trustStoreType;
        String trustStore;
        boolean bl2;
        boolean bl3 = bl2 = (0L & TraceControllerImpl.feature) != 0L;
        if (bl2) {
            CustomSSLSocketFactory.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "TRUST STORE IS" + trustStore);
        }
        if (bl2) {
            CustomSSLSocketFactory.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "TRUST STORE TYPE IS" + (String)trustStoreType);
        }
        if (bl2) {
            CustomSSLSocketFactory.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "TRUST MANAGER FACTORY ALGORITHM" + (String)trustManagerFacAlgo);
        }
        try {
            void isCaCertsTrusted;
            void trustStorePassword;
            KeyStore instTrustStore = CustomSSLSocketFactory.loadKeyStore(trustStore, (String)trustStoreType, (OpaqueString)trustStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)trustManagerFacAlgo);
            trustManagerFactory.init(isCaCertsTrusted != false ? CustomSSLSocketFactory.mergeCaCerts(instTrustStore) : instTrustStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception ex) {
            if (bl2) {
                CustomSSLSocketFactory.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "Error in initializing trust store " + ex.toString());
            }
            throw (NetException)new NetException(409).initCause(ex);
        }
    }

    private static KeyStore mergeCaCerts(KeyStore trustStore) throws IOException, GeneralSecurityException {
        TrustManagerFactory caCertsTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        try {
            caCertsTrustManagerFactory.init((KeyStore)null);
        }
        catch (NullPointerException | KeyStoreException exception) {
            caCertsTrustManagerFactory.init(CustomSSLSocketFactory.loadCaCerts());
        }
        for (TrustManager trustManager : caCertsTrustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            for (X509Certificate certificate : ((X509TrustManager)trustManager).getAcceptedIssuers()) {
                String alias = certificate.getIssuerX500Principal().getName();
                if (trustStore.containsAlias(alias)) continue;
                trustStore.setCertificateEntry(alias, certificate);
            }
        }
        return trustStore;
    }

    private static KeyStore loadCaCerts() throws IOException, GeneralSecurityException {
        try {
            return CustomSSLSocketFactory.loadCaCerts(PKCS12_WALLET_TYPE, "SUN");
        }
        catch (IOException | GeneralSecurityException exception0) {
            try {
                return CustomSSLSocketFactory.loadCaCerts(JKS_TYPE, "SUN");
            }
            catch (IOException | GeneralSecurityException exception1) {
                exception1.addSuppressed(exception0);
                throw exception1;
            }
        }
    }

    private static KeyStore loadCaCerts(String type, String provider) throws IOException, GeneralSecurityException {
        try (InputStream inputStream = Files.newInputStream(Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts"), new OpenOption[0]);){
            KeyStore cacerts = KeyStore.getInstance(type, provider);
            cacerts.load(inputStream, null);
            KeyStore keyStore = cacerts;
            return keyStore;
        }
    }

    public static String processWalletLocation(String string) throws NetException {
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        String method = null;
        try {
            String walletLocation;
            NVNavigator nav = new NVNavigator();
            NVPair nvpWallet = new NVFactory().createNVPair(walletLocation);
            NVPair nvpMethod = nav.findNVPair(nvpWallet, "METHOD");
            NVPair nvpMethodData = nav.findNVPair(nvpWallet, "METHOD_DATA");
            NVPair nvpDirectory = nav.findNVPair(nvpMethodData, "DIRECTORY");
            method = nvpMethod.getAtom();
            if (bl) {
                CustomSSLSocketFactory.debug($$$loggerRef$$$13, Level.FINEST, $$$methodRef$$$13, "METHOD in wallet " + method);
            }
            if (bl) {
                CustomSSLSocketFactory.debug($$$loggerRef$$$13, Level.FINEST, $$$methodRef$$$13, "Directory in wallet " + nvpDirectory.getAtom());
            }
            if (method.equalsIgnoreCase(SUPPORTED_METHOD_TYPE)) {
                String directoryLoc = nvpDirectory.getAtom();
                return directoryLoc;
            }
            throw new NetException(412, method);
        }
        catch (Exception ex) {
            if (bl) {
                CustomSSLSocketFactory.debug($$$loggerRef$$$13, Level.FINEST, $$$methodRef$$$13, "Error in parsing wallet location " + ex.toString());
            }
            throw (NetException)new NetException(407).initCause(ex);
        }
    }

    private static KeyStore getKeyStoreInstance(String string) throws KeyStoreException {
        String type;
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        try {
            return KeyStore.getInstance(type);
        }
        catch (KeyStoreException err) {
            try {
                Provider provider = CustomSSLSocketFactory.loadKnownProvider(type);
                if (provider == null) {
                    throw err;
                }
                return KeyStore.getInstance(type, provider);
            }
            catch (Exception loadProviderError) {
                if (bl) {
                    CustomSSLSocketFactory.debug($$$loggerRef$$$14, Level.FINEST, $$$methodRef$$$14, "Failed to load a known Provider for key store type" + type + " after no registered Provider was found. The exception was: " + loadProviderError.getLocalizedMessage() + ". The origninal exception will be thrown");
                }
                throw err;
            }
        }
    }

    private static Provider loadKnownProvider(String type) throws Exception {
        Class<?> clazz;
        String providerClass;
        Provider providerObject = null;
        switch (type.toUpperCase()) {
            case "SSO": {
                providerClass = ORACLE_PKI_PROVIDER_CLASS;
                break;
            }
            case "KSS": {
                providerClass = KSS_PROVIDER_CLASS;
                break;
            }
            default: {
                providerClass = null;
            }
        }
        if (providerClass != null && (clazz = Class.forName(providerClass)) != null && Provider.class.isAssignableFrom(clazz)) {
            providerObject = AccessController.doPrivileged(() -> (Provider)clazz.newInstance());
        }
        return providerObject;
    }

    private static String resolveKeyStoreType(String keyStorePath) {
        if (keyStorePath == null || keyStorePath.length() == 0) {
            return KeyStore.getDefaultType();
        }
        String lowerCasePath = keyStorePath.toLowerCase();
        if (lowerCasePath.endsWith(SSO_FILE_EXTENSION)) {
            return SSO_WALLET_TYPE;
        }
        if (lowerCasePath.endsWith(P12_FILE_EXTENSION) || lowerCasePath.endsWith(PFX_FILE_EXTENSION)) {
            return PKCS12_WALLET_TYPE;
        }
        if (lowerCasePath.endsWith(JKS_FILE_EXTENSION)) {
            return JKS_TYPE;
        }
        if (lowerCasePath.startsWith(KSS_URI_SCHEME)) {
            return KSS_TYPE;
        }
        return KeyStore.getDefaultType();
    }

    @Log
    protected static void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, CustomSSLSocketFactory.class, method, msg);
    }

    private static KeyStore loadKeyStore(String path, String type, OpaqueString password) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        KeyStore instKeyStore = CustomSSLSocketFactory.getKeyStoreInstance(type);
        if (KSS_TYPE.equals(type)) {
            CustomSSLSocketFactory.loadKSSKeyStore(instKeyStore, path, password);
        } else {
            CustomSSLSocketFactory.loadFileBasedKeyStore(instKeyStore, path, password);
        }
        return instKeyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadFileBasedKeyStore(KeyStore keyStore, String path, OpaqueString password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream fileStream = Channels.newInputStream(FileChannel.open(Paths.get(path, new String[0]), StandardOpenOption.READ));){
            char[] pw = password.getChars();
            try {
                keyStore.load(fileStream, pw);
                if (pw == null) return;
            }
            catch (Throwable throwable) {
                if (pw == null) throw throwable;
                for (int i2 = 0; i2 < pw.length; ++i2) {
                    pw[i2] = '\u0000';
                }
                throw throwable;
            }
            for (int i3 = 0; i3 < pw.length; ++i3) {
                pw[i3] = '\u0000';
            }
            return;
        }
    }

    private static void loadKSSKeyStore(KeyStore keyStore, String uri, OpaqueString password) throws IOException, NoSuchAlgorithmException, CertificateException {
        final class KSSLoader {
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            KSSLoader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void load(KeyStore ks, String uri, OpaqueString password) throws IOException, NoSuchAlgorithmException, CertificateException {
                KeyStoreServiceLoadStoreParameter param = new KeyStoreServiceLoadStoreParameter();
                if (password != null && password != OpaqueString.NULL) {
                    char[] pw = password.getChars();
                    try {
                        param.setProtectionParameter((KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(pw));
                    }
                    catch (Throwable throwable) {
                        for (int i2 = 0; i2 < pw.length; ++i2) {
                            pw[i2] = '\u0000';
                        }
                        throw throwable;
                    }
                    for (int i3 = 0; i3 < pw.length; ++i3) {
                        pw[i3] = '\u0000';
                    }
                }
                param.setKssUri(uri);
                ks.load((KeyStore.LoadStoreParameter)param);
            }

            static {
                try {
                    $$$methodRef$$$1 = KSSLoader.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = KSSLoader.class.getDeclaredMethod("load", KeyStore.class, String.class, OpaqueString.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        }
        new KSSLoader().load(keyStore, uri, password);
    }

    static {
        SSLConfig systemConfig;
        try {
            $$$methodRef$$$21 = CustomSSLSocketFactory.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = CustomSSLSocketFactory.class.getDeclaredMethod("lambda$loadKnownProvider$0", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = CustomSSLSocketFactory.class.getDeclaredMethod("loadKSSKeyStore", KeyStore.class, String.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = CustomSSLSocketFactory.class.getDeclaredMethod("loadFileBasedKeyStore", KeyStore.class, String.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = CustomSSLSocketFactory.class.getDeclaredMethod("loadKeyStore", String.class, String.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = CustomSSLSocketFactory.class.getDeclaredMethod("resolveKeyStoreType", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = CustomSSLSocketFactory.class.getDeclaredMethod("loadKnownProvider", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = CustomSSLSocketFactory.class.getDeclaredMethod("getKeyStoreInstance", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = CustomSSLSocketFactory.class.getDeclaredMethod("processWalletLocation", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = CustomSSLSocketFactory.class.getDeclaredMethod("loadCaCerts", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = CustomSSLSocketFactory.class.getDeclaredMethod("loadCaCerts", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = CustomSSLSocketFactory.class.getDeclaredMethod("mergeCaCerts", KeyStore.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = CustomSSLSocketFactory.class.getDeclaredMethod("getTrustManagerArray", String.class, OpaqueString.class, String.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = CustomSSLSocketFactory.class.getDeclaredMethod("getKeyManagerArray", String.class, OpaqueString.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = CustomSSLSocketFactory.class.getDeclaredMethod("readWalletSSLConfig", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = CustomSSLSocketFactory.class.getDeclaredMethod("readJavaxNetSSLConfig", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = CustomSSLSocketFactory.class.getDeclaredMethod("readSSLConfig", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = CustomSSLSocketFactory.class.getDeclaredMethod("wrapWithAliasKeyManager", KeyManager[].class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = CustomSSLSocketFactory.class.getDeclaredMethod("createSSLContext", SSLConfig.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = CustomSSLSocketFactory.class.getDeclaredMethod("getSSLContext", SSLConfig.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = CustomSSLSocketFactory.class.getDeclaredMethod("getSSLSocketEngine", String.class, Integer.TYPE, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = CustomSSLSocketFactory.class.getDeclaredMethod("getSSLSocketFactory", Properties.class, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        DEF_FACTORY_INIT_MONITOR = Monitor.newInstance();
        DEF_CONTEXT_INIT_MONITOR = Monitor.newInstance();
        try {
            Properties socketOptions = new Properties();
            ConnStrategy.createSocketOptions(System.getProperties(), socketOptions);
            systemConfig = CustomSSLSocketFactory.readSSLConfig(socketOptions);
        }
        catch (NetException netException) {
            systemConfig = new SSLConfig();
        }
        DEF_CONTEXT_CONFIG = systemConfig;
    }

    static class AliasKeyManager
    extends X509ExtendedKeyManager {
        private final String alias;
        private final X509KeyManager keyManager;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;

        AliasKeyManager(X509KeyManager keyManager, String alias) {
            this.keyManager = keyManager;
            this.alias = alias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.chooseEngineClientAlias(keyType, issuers, null);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            for (String type : keyType) {
                if (!this.isMatchFound(this.keyManager.getClientAliases(type, issuers), this.alias)) continue;
                return this.alias;
            }
            return null;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.chooseEngineServerAlias(keyType, issuers, null);
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            String[] serverAliases = this.keyManager.getServerAliases(keyType, issuers);
            if (this.isMatchFound(serverAliases, this.alias)) {
                return this.alias;
            }
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.keyManager.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.keyManager.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }

        private boolean isMatchFound(String[] aliases, String alias) {
            if (aliases == null) {
                return false;
            }
            for (String curAlias : aliases) {
                if (!curAlias.equalsIgnoreCase(alias)) continue;
                return true;
            }
            return false;
        }

        static {
            try {
                $$$methodRef$$$9 = AliasKeyManager.class.getDeclaredConstructor(X509KeyManager.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = AliasKeyManager.class.getDeclaredMethod("isMatchFound", String[].class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = AliasKeyManager.class.getDeclaredMethod("getServerAliases", String.class, Principal[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = AliasKeyManager.class.getDeclaredMethod("getPrivateKey", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = AliasKeyManager.class.getDeclaredMethod("getClientAliases", String.class, Principal[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = AliasKeyManager.class.getDeclaredMethod("getCertificateChain", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = AliasKeyManager.class.getDeclaredMethod("chooseEngineServerAlias", String.class, Principal[].class, SSLEngine.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = AliasKeyManager.class.getDeclaredMethod("chooseServerAlias", String.class, Principal[].class, Socket.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = AliasKeyManager.class.getDeclaredMethod("chooseEngineClientAlias", String[].class, Principal[].class, SSLEngine.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = AliasKeyManager.class.getDeclaredMethod("chooseClientAlias", String[].class, Principal[].class, Socket.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static final class SSLConfig {
        String keyStore;
        String keyStoreType;
        OpaqueString keyStorePassword;
        String certificateAlias;
        String keyManagerFacAlgo;
        String trustStore;
        String trustStoreType;
        OpaqueString trustStorePassword;
        String trustManagerFacAlgo;
        String sslContextProtocol;
        boolean isCaCertsTrusted;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        private SSLConfig() {
        }

        public boolean equals(Object other) {
            if (!(other instanceof SSLConfig)) {
                return false;
            }
            SSLConfig otherSSLConfig = (SSLConfig)other;
            return Objects.equals(this.keyStore, otherSSLConfig.keyStore) && Objects.equals(this.keyStoreType, otherSSLConfig.keyStoreType) && Objects.equals(this.keyStorePassword, otherSSLConfig.keyStorePassword) && Objects.equals(this.certificateAlias, otherSSLConfig.certificateAlias) && Objects.equals(this.keyManagerFacAlgo, otherSSLConfig.keyManagerFacAlgo) && Objects.equals(this.trustStore, otherSSLConfig.trustStore) && Objects.equals(this.trustStoreType, otherSSLConfig.trustStoreType) && Objects.equals(this.trustStorePassword, otherSSLConfig.trustStorePassword) && Objects.equals(this.trustManagerFacAlgo, otherSSLConfig.trustManagerFacAlgo) && Objects.equals(this.sslContextProtocol, otherSSLConfig.sslContextProtocol) && Objects.equals(this.isCaCertsTrusted, otherSSLConfig.isCaCertsTrusted);
        }

        static {
            try {
                $$$methodRef$$$1 = SSLConfig.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = SSLConfig.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

