/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.AbstractGenerator;
import oracle.jdbc.driver.json.binary.OsonConstants;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.binary.StreamContext;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;

public final class OsonGeneratorImpl
extends AbstractGenerator
implements OracleJsonGenerator {
    private static boolean DEFAULT_SIMPLE_VALUE_SHARING;
    private static boolean DEFAULT_LAST_VALUE_SHARING;
    private static boolean DEFAULT_RELATIVE_OFFSETS;
    private static boolean DEFAULT_TINYNODE;
    private static final DuplicateKeyMode DEFAULT_DUPLICATE_KEY_MODE;
    private static int INITIAL_OPS;
    private static int OUT_BUFFER_SIZE;
    private static int SEEN_HASH_THRESHOLD;
    private static byte[] ONE;
    private static byte[] ZERO;
    private OsonGeneratorState state;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;

    public OsonGeneratorImpl(OsonGeneratorStatePool pool, OutputStream out) {
        this.state = pool != null ? pool.getState(out) : new OsonGeneratorState(null, out);
        this.state.reset(out);
    }

    public void reset(OutputStream out) {
        this.state.reset(out);
    }

    public void setTinyNodeStat(boolean value) {
        this.state.setTinyNodeStat(value);
    }

    public void setUseRelativeOffsets(boolean value) {
        this.state.setUseRelativeOffsets(value);
    }

    public void setSimpleValueSharing(boolean value) {
        this.state.setSimpleValueSharing(value);
    }

    public void setLastValueSharing(boolean value) {
        this.state.setLastValueSharing(value);
    }

    public boolean getLastValueSharing() {
        return this.state.lastValueSharing;
    }

    public boolean getSimpleValuesharing() {
        return this.state.simpleValueSharing;
    }

    public boolean getRelativeOffsets() {
        return this.state.relativeOffsets;
    }

    @Override
    public OracleJsonGenerator writeStartObject() {
        this.state.writeStartObject();
        return this;
    }

    public OracleJsonGenerator writeStartObject(boolean sort) {
        if (sort) {
            this.state.writeStartObject();
        } else {
            this.state.writeStartObjectNoSort();
        }
        return this;
    }

    @Override
    public OracleJsonGenerator writeKey(String key) {
        this.state.writeKey(key);
        return this;
    }

    @Override
    public OracleJsonGenerator writeStartArray() {
        this.state.writeStartArray();
        return this;
    }

    @Override
    public OracleJsonGenerator writeEnd() {
        this.state.writeEnd();
        return this;
    }

    @Override
    public OracleJsonGenerator write(String value) {
        this.state.writeString(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(BigDecimal value) {
        this.state.writeDecimal(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(BigInteger value) {
        this.state.writeDecimal(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(int value) {
        this.state.writeSB4(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(long value) {
        this.state.writeSB8(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(double value) {
        this.state.writeDouble(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(boolean value) {
        this.state.writeBoolean(value);
        return this;
    }

    @Override
    public OracleJsonGenerator writeNull() {
        this.state.writeNull();
        return this;
    }

    @Override
    public void close() {
        if (this.state != null) {
            this.state.close();
            if (this.state.pool != null) {
                this.state.pool.putState(this.state);
            }
            this.state = null;
        }
    }

    @Override
    public OracleJsonGenerator write(String key, byte[] value) {
        this.writeKey(key);
        this.write(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String key, LocalDateTime value) {
        this.writeKey(key);
        this.write(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String key, OffsetDateTime value) {
        this.writeKey(key);
        this.write(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(byte[] bytes) {
        this.state.writeBytes(bytes);
        return this;
    }

    @Override
    public OracleJsonGenerator writeId(byte[] bytes) {
        this.state.writeId(bytes);
        return this;
    }

    @Override
    public OracleJsonGenerator write(float value) {
        this.state.writeFloat(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(LocalDateTime local) {
        byte[] bytes = OsonPrimitiveConversions.toOracleTimestamp(this.state.getExceptionFactory(), local);
        this.state.writeTimestamp(bytes);
        return this;
    }

    @Override
    public OracleJsonGenerator write(OffsetDateTime offset) {
        byte[] bytes = OsonPrimitiveConversions.toOracleTimestampTZ(this.state.getExceptionFactory(), offset);
        this.state.writeTimestampTZ(bytes);
        return this;
    }

    public OracleJsonGenerator writeIntervalDS(Duration value) {
        byte[] bytes = OsonPrimitiveConversions.durationToIntervalDS(value);
        this.state.writeIntervalDS(bytes);
        return this;
    }

    public OracleJsonGenerator writeIntervalYM(Period value) {
        byte[] bytes = OsonPrimitiveConversions.periodToIntervalYM(this.state.getExceptionFactory(), value);
        this.state.writeIntervalYM(bytes);
        return this;
    }

    public OracleJsonGenerator writeNumberAsString(BigDecimal bd) {
        this.state.writeNumberAsString(bd);
        return this;
    }

    @Override
    protected OracleJsonGenerator writeBinary(OracleJsonBinary value) {
        byte[] bytes = value.getBytes();
        if (value.isId()) {
            this.state.writeId(bytes);
        } else {
            this.state.writeBytes(bytes);
        }
        return this;
    }

    @Override
    protected OracleJsonGenerator writeDouble(OracleJsonDouble value) {
        return this.write(value.doubleValue());
    }

    @Override
    protected OracleJsonGenerator writeFloat(OracleJsonFloat value) {
        return this.write(value.floatValue());
    }

    public void writeDecimal(BigDecimal value) {
        this.state.writeDecimal(value);
    }

    public void writeSB4(int value) {
        this.state.writeSB4(value);
    }

    public void writeSB8(long value) {
        this.state.writeSB8(value);
    }

    @Override
    protected OracleJsonGenerator writeOraNumber(OracleJsonDecimal value) {
        this.state.writeOraNumber(value);
        return this;
    }

    @Override
    protected OracleJsonGenerator writeTimestamp(OracleJsonTimestamp value) {
        this.state.writeTimestamp(((OracleJsonTimestampImpl)value).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeTimestampTZ(OracleJsonTimestampTZ value) {
        this.state.writeTimestampTZ(((OracleJsonTimestampTZImpl)value).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeDate(OracleJsonDate value) {
        this.state.writeDate(((OracleJsonDateImpl)value).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeIntervalDS(OracleJsonIntervalDS value) {
        this.state.writeIntervalDS(((OracleJsonIntervalDSImpl)value).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeIntervalYM(OracleJsonIntervalYM value) {
        this.state.writeIntervalYM(((OracleJsonIntervalYMImpl)value).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeString(OracleJsonString value) {
        return this.write(value.getString());
    }

    @Override
    public void flush() {
    }

    @Override
    public OracleJsonGenerator write(Period p2) {
        this.state.writeIntervalYM(OsonPrimitiveConversions.periodToIntervalYM(this.state.getExceptionFactory(), p2));
        return this;
    }

    @Override
    public OracleJsonGenerator write(Duration d2) {
        this.state.writeIntervalDS(OsonPrimitiveConversions.durationToIntervalDS(d2));
        return this;
    }

    @Override
    protected void writeStringFromParser(OracleJsonParser parser) {
        if (parser instanceof OsonParserImpl) {
            OsonParserImpl oparser = (OsonParserImpl)parser;
            byte[] arr = oparser.getContext().b.buffer.array();
            this.state.writeUTF8String(arr, oparser.getCurrentStringPos(), oparser.getCurrentStringLen());
        } else {
            this.state.writeString(parser.getString());
        }
    }

    @Override
    protected void writeDecimalFromParser(OracleJsonParser parser) {
        this.write(parser.getValue());
    }

    public void setDuplicateKeyMode(DuplicateKeyMode mode) {
        this.state.duplicateKeyMode = mode;
    }

    static {
        try {
            $$$methodRef$$$52 = OsonGeneratorImpl.class.getDeclaredConstructor(OsonGeneratorStatePool.class, OutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = OsonGeneratorImpl.class.getDeclaredMethod("setDuplicateKeyMode", DuplicateKeyMode.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = OsonGeneratorImpl.class.getDeclaredMethod("writeDecimalFromParser", OracleJsonParser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = OsonGeneratorImpl.class.getDeclaredMethod("writeStringFromParser", OracleJsonParser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = OsonGeneratorImpl.class.getDeclaredMethod("write", Duration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = OsonGeneratorImpl.class.getDeclaredMethod("write", Period.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = OsonGeneratorImpl.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OsonGeneratorImpl.class.getDeclaredMethod("writeString", OracleJsonString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OsonGeneratorImpl.class.getDeclaredMethod("writeIntervalYM", OracleJsonIntervalYM.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OsonGeneratorImpl.class.getDeclaredMethod("writeIntervalDS", OracleJsonIntervalDS.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OsonGeneratorImpl.class.getDeclaredMethod("writeDate", OracleJsonDate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OsonGeneratorImpl.class.getDeclaredMethod("writeTimestampTZ", OracleJsonTimestampTZ.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OsonGeneratorImpl.class.getDeclaredMethod("writeTimestamp", OracleJsonTimestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OsonGeneratorImpl.class.getDeclaredMethod("writeOraNumber", OracleJsonDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OsonGeneratorImpl.class.getDeclaredMethod("writeSB8", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OsonGeneratorImpl.class.getDeclaredMethod("writeSB4", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OsonGeneratorImpl.class.getDeclaredMethod("writeDecimal", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OsonGeneratorImpl.class.getDeclaredMethod("writeFloat", OracleJsonFloat.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OsonGeneratorImpl.class.getDeclaredMethod("writeDouble", OracleJsonDouble.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OsonGeneratorImpl.class.getDeclaredMethod("writeBinary", OracleJsonBinary.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OsonGeneratorImpl.class.getDeclaredMethod("writeNumberAsString", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OsonGeneratorImpl.class.getDeclaredMethod("writeIntervalYM", Period.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OsonGeneratorImpl.class.getDeclaredMethod("writeIntervalDS", Duration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OsonGeneratorImpl.class.getDeclaredMethod("write", OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OsonGeneratorImpl.class.getDeclaredMethod("write", LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OsonGeneratorImpl.class.getDeclaredMethod("write", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OsonGeneratorImpl.class.getDeclaredMethod("writeId", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OsonGeneratorImpl.class.getDeclaredMethod("write", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OsonGeneratorImpl.class.getDeclaredMethod("write", String.class, OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OsonGeneratorImpl.class.getDeclaredMethod("write", String.class, LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OsonGeneratorImpl.class.getDeclaredMethod("write", String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OsonGeneratorImpl.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OsonGeneratorImpl.class.getDeclaredMethod("writeNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OsonGeneratorImpl.class.getDeclaredMethod("write", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OsonGeneratorImpl.class.getDeclaredMethod("write", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OsonGeneratorImpl.class.getDeclaredMethod("write", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OsonGeneratorImpl.class.getDeclaredMethod("write", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OsonGeneratorImpl.class.getDeclaredMethod("write", BigInteger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OsonGeneratorImpl.class.getDeclaredMethod("write", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OsonGeneratorImpl.class.getDeclaredMethod("write", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OsonGeneratorImpl.class.getDeclaredMethod("writeEnd", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OsonGeneratorImpl.class.getDeclaredMethod("writeStartArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OsonGeneratorImpl.class.getDeclaredMethod("writeKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OsonGeneratorImpl.class.getDeclaredMethod("writeStartObject", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OsonGeneratorImpl.class.getDeclaredMethod("writeStartObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OsonGeneratorImpl.class.getDeclaredMethod("getRelativeOffsets", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OsonGeneratorImpl.class.getDeclaredMethod("getSimpleValuesharing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OsonGeneratorImpl.class.getDeclaredMethod("getLastValueSharing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OsonGeneratorImpl.class.getDeclaredMethod("setLastValueSharing", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OsonGeneratorImpl.class.getDeclaredMethod("setSimpleValueSharing", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OsonGeneratorImpl.class.getDeclaredMethod("setUseRelativeOffsets", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OsonGeneratorImpl.class.getDeclaredMethod("setTinyNodeStat", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OsonGeneratorImpl.class.getDeclaredMethod("reset", OutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        DEFAULT_SIMPLE_VALUE_SHARING = "true".equals(System.getProperty("oracle.jdbc.driver.json.binary.DEFAULT_SIMPLE_VALUE_SHARING", "false"));
        DEFAULT_LAST_VALUE_SHARING = "true".equals(System.getProperty("oracle.jdbc.driver.json.binary.DEFAULT_LAST_VALUE_SHARING", "false"));
        DEFAULT_RELATIVE_OFFSETS = "true".equals(System.getProperty("oracle.jdbc.driver.json.binary.DEFAULT_RELATIVE_OFFSETS", "false"));
        DEFAULT_TINYNODE = "true".equals(System.getProperty("oracle.jdbc.driver.json.binary.DEFAULT_TINYNODE", "true"));
        INITIAL_OPS = 64;
        OUT_BUFFER_SIZE = 8192;
        SEEN_HASH_THRESHOLD = 64;
        ONE = OsonPrimitiveConversions.toNumber(1);
        ZERO = OsonPrimitiveConversions.toNumber(0);
        String modeStr = System.getProperty("oracle.jdbc.driver.json.binary.OsonGeneratorImpl.DEFAULT_DUPLICATE_KEY_MODE");
        DuplicateKeyMode mode = null;
        mode = modeStr == null ? DuplicateKeyMode.DISALLOW : DuplicateKeyMode.valueOf(modeStr);
        DEFAULT_DUPLICATE_KEY_MODE = mode;
    }

    public static final class OsonGeneratorStatePool {
        private volatile WeakReference<ConcurrentLinkedQueue<OsonGeneratorState>> queue;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private OsonGeneratorState getState(OutputStream out) {
            ConcurrentLinkedQueue<OsonGeneratorState> list = this.getQueue();
            OsonGeneratorState result = null;
            if (list != null) {
                result = list.poll();
            }
            if (result == null) {
                result = new OsonGeneratorState(this, out);
            }
            return result;
        }

        private void putState(OsonGeneratorState state) {
            ConcurrentLinkedQueue<OsonGeneratorState> list = this.getQueue();
            if (list == null) {
                list = new ConcurrentLinkedQueue();
                list.offer(state);
                this.queue = new WeakReference<ConcurrentLinkedQueue<OsonGeneratorState>>(list);
            } else {
                list.offer(state);
            }
        }

        private ConcurrentLinkedQueue<OsonGeneratorState> getQueue() {
            WeakReference<ConcurrentLinkedQueue<OsonGeneratorState>> queue = this.queue;
            return queue == null ? null : (ConcurrentLinkedQueue)queue.get();
        }

        static {
            try {
                $$$methodRef$$$3 = OsonGeneratorStatePool.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = OsonGeneratorStatePool.class.getDeclaredMethod("getQueue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = OsonGeneratorStatePool.class.getDeclaredMethod("putState", OsonGeneratorState.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = OsonGeneratorStatePool.class.getDeclaredMethod("getState", OutputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static final class OsonGeneratorState {
        private int[][] keys = new int[256][];
        private int[][] keysLastSeenValue;
        private boolean keysNeedReset = true;
        int[] seenHash = new int[SEEN_HASH_THRESHOLD];
        int seenHashSize;
        int keyI;
        int keyJ;
        private String[] distinctKeys = new String[16];
        private int distinctKeysSize;
        private byte[] keyHeap;
        private int keyHeapSize;
        private int[] keyHeapOffsets;
        private int[] fidMap;
        private int numOps;
        private byte[] ops = new byte[INITIAL_OPS];
        private int[] nextSiblings = new int[INITIAL_OPS];
        private int[] fieldIDs = new int[INITIAL_OPS];
        private byte[] depths = new byte[INITIAL_OPS];
        private int[] valueIndex = new int[INITIAL_OPS];
        private int[] numChildren = new int[INITIAL_OPS];
        private int[] offsets;
        private int treeSegmentSize;
        private byte[] valueHeap = new byte[1024];
        private int valueHeapSize;
        private int tinyNodeCount;
        short headerFlags;
        private int[] opStack = new int[2];
        private byte depth;
        private int previousSiblingIdx;
        private int[] temporaryIntArray;
        private long[] temporaryLongArray;
        private final StreamContext ctx = new StreamContext(null);
        private OutputStream out;
        private byte[] outBuffer = new byte[OUT_BUFFER_SIZE];
        private int outBufferPos;
        public boolean relativeOffsets;
        public boolean simpleValueSharing;
        public boolean lastValueSharing;
        int opNull;
        int opTrue;
        int opFalse;
        int opZero;
        int opOne;
        int opEmptyString;
        int opEmptyObject;
        int opEmptyArray;
        int opLastValue;
        private OsonGeneratorStatePool pool;
        private DuplicateKeyMode duplicateKeyMode = DEFAULT_DUPLICATE_KEY_MODE;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;
        private static Executable $$$methodRef$$$21;
        private static Logger $$$loggerRef$$$21;
        private static Executable $$$methodRef$$$22;
        private static Logger $$$loggerRef$$$22;
        private static Executable $$$methodRef$$$23;
        private static Logger $$$loggerRef$$$23;
        private static Executable $$$methodRef$$$24;
        private static Logger $$$loggerRef$$$24;
        private static Executable $$$methodRef$$$25;
        private static Logger $$$loggerRef$$$25;
        private static Executable $$$methodRef$$$26;
        private static Logger $$$loggerRef$$$26;
        private static Executable $$$methodRef$$$27;
        private static Logger $$$loggerRef$$$27;
        private static Executable $$$methodRef$$$28;
        private static Logger $$$loggerRef$$$28;
        private static Executable $$$methodRef$$$29;
        private static Logger $$$loggerRef$$$29;
        private static Executable $$$methodRef$$$30;
        private static Logger $$$loggerRef$$$30;
        private static Executable $$$methodRef$$$31;
        private static Logger $$$loggerRef$$$31;
        private static Executable $$$methodRef$$$32;
        private static Logger $$$loggerRef$$$32;
        private static Executable $$$methodRef$$$33;
        private static Logger $$$loggerRef$$$33;
        private static Executable $$$methodRef$$$34;
        private static Logger $$$loggerRef$$$34;
        private static Executable $$$methodRef$$$35;
        private static Logger $$$loggerRef$$$35;
        private static Executable $$$methodRef$$$36;
        private static Logger $$$loggerRef$$$36;
        private static Executable $$$methodRef$$$37;
        private static Logger $$$loggerRef$$$37;
        private static Executable $$$methodRef$$$38;
        private static Logger $$$loggerRef$$$38;
        private static Executable $$$methodRef$$$39;
        private static Logger $$$loggerRef$$$39;
        private static Executable $$$methodRef$$$40;
        private static Logger $$$loggerRef$$$40;
        private static Executable $$$methodRef$$$41;
        private static Logger $$$loggerRef$$$41;
        private static Executable $$$methodRef$$$42;
        private static Logger $$$loggerRef$$$42;
        private static Executable $$$methodRef$$$43;
        private static Logger $$$loggerRef$$$43;
        private static Executable $$$methodRef$$$44;
        private static Logger $$$loggerRef$$$44;
        private static Executable $$$methodRef$$$45;
        private static Logger $$$loggerRef$$$45;
        private static Executable $$$methodRef$$$46;
        private static Logger $$$loggerRef$$$46;
        private static Executable $$$methodRef$$$47;
        private static Logger $$$loggerRef$$$47;
        private static Executable $$$methodRef$$$48;
        private static Logger $$$loggerRef$$$48;
        private static Executable $$$methodRef$$$49;
        private static Logger $$$loggerRef$$$49;
        private static Executable $$$methodRef$$$50;
        private static Logger $$$loggerRef$$$50;
        private static Executable $$$methodRef$$$51;
        private static Logger $$$loggerRef$$$51;
        private static Executable $$$methodRef$$$52;
        private static Logger $$$loggerRef$$$52;
        private static Executable $$$methodRef$$$53;
        private static Logger $$$loggerRef$$$53;
        private static Executable $$$methodRef$$$54;
        private static Logger $$$loggerRef$$$54;
        private static Executable $$$methodRef$$$55;
        private static Logger $$$loggerRef$$$55;
        private static Executable $$$methodRef$$$56;
        private static Logger $$$loggerRef$$$56;
        private static Executable $$$methodRef$$$57;
        private static Logger $$$loggerRef$$$57;
        private static Executable $$$methodRef$$$58;
        private static Logger $$$loggerRef$$$58;
        private static Executable $$$methodRef$$$59;
        private static Logger $$$loggerRef$$$59;
        private static Executable $$$methodRef$$$60;
        private static Logger $$$loggerRef$$$60;
        private static Executable $$$methodRef$$$61;
        private static Logger $$$loggerRef$$$61;
        private static Executable $$$methodRef$$$62;
        private static Logger $$$loggerRef$$$62;
        private static Executable $$$methodRef$$$63;
        private static Logger $$$loggerRef$$$63;
        private static Executable $$$methodRef$$$64;
        private static Logger $$$loggerRef$$$64;
        private static Executable $$$methodRef$$$65;
        private static Logger $$$loggerRef$$$65;
        private static Executable $$$methodRef$$$66;
        private static Logger $$$loggerRef$$$66;
        private static Executable $$$methodRef$$$67;
        private static Logger $$$loggerRef$$$67;
        private static Executable $$$methodRef$$$68;
        private static Logger $$$loggerRef$$$68;
        private static Executable $$$methodRef$$$69;
        private static Logger $$$loggerRef$$$69;
        private static Executable $$$methodRef$$$70;
        private static Logger $$$loggerRef$$$70;
        private static Executable $$$methodRef$$$71;
        private static Logger $$$loggerRef$$$71;
        private static Executable $$$methodRef$$$72;
        private static Logger $$$loggerRef$$$72;
        private static Executable $$$methodRef$$$73;
        private static Logger $$$loggerRef$$$73;
        private static Executable $$$methodRef$$$74;
        private static Logger $$$loggerRef$$$74;
        private static Executable $$$methodRef$$$75;
        private static Logger $$$loggerRef$$$75;
        private static Executable $$$methodRef$$$76;
        private static Logger $$$loggerRef$$$76;
        private static Executable $$$methodRef$$$77;
        private static Logger $$$loggerRef$$$77;
        private static Executable $$$methodRef$$$78;
        private static Logger $$$loggerRef$$$78;
        private static Executable $$$methodRef$$$79;
        private static Logger $$$loggerRef$$$79;
        private static Executable $$$methodRef$$$80;
        private static Logger $$$loggerRef$$$80;
        private static Executable $$$methodRef$$$81;
        private static Logger $$$loggerRef$$$81;
        private static Executable $$$methodRef$$$82;
        private static Logger $$$loggerRef$$$82;
        private static Executable $$$methodRef$$$83;
        private static Logger $$$loggerRef$$$83;
        private static Executable $$$methodRef$$$84;
        private static Logger $$$loggerRef$$$84;
        private static Executable $$$methodRef$$$85;
        private static Logger $$$loggerRef$$$85;
        private static Executable $$$methodRef$$$86;
        private static Logger $$$loggerRef$$$86;
        private static Executable $$$methodRef$$$87;
        private static Logger $$$loggerRef$$$87;
        private static Executable $$$methodRef$$$88;
        private static Logger $$$loggerRef$$$88;
        private static Executable $$$methodRef$$$89;
        private static Logger $$$loggerRef$$$89;
        private static Executable $$$methodRef$$$90;
        private static Logger $$$loggerRef$$$90;
        private static Executable $$$methodRef$$$91;
        private static Logger $$$loggerRef$$$91;
        private static Executable $$$methodRef$$$92;
        private static Logger $$$loggerRef$$$92;
        private static Executable $$$methodRef$$$93;
        private static Logger $$$loggerRef$$$93;

        private OsonGeneratorState(OsonGeneratorStatePool pool, OutputStream out) {
            this.pool = pool;
            this.out = out;
            this.ctx.setExceptionFactory(this.getExceptionFactory());
        }

        private void writeNumber(byte[] bytes) {
            if (bytes.length <= 8) {
                int op = bytes.length - 1 | OsonConstants.MASK_ORANUM_16;
                if (this.simpleValueSharing) {
                    if (Arrays.equals(ONE, bytes)) {
                        this.addOpAndValueNoPostOp(op, bytes);
                        if (this.opOne == -1) {
                            this.opOne = this.numOps - 1;
                        } else {
                            this.headerFlags = (short)(this.headerFlags | 0x20);
                            this.markDuplicate(this.numOps - 1, this.opOne);
                        }
                        this.postOp(false);
                        return;
                    }
                    if (Arrays.equals(ZERO, bytes)) {
                        this.addOpAndValueNoPostOp(op, bytes);
                        if (this.opZero == -1) {
                            this.opZero = this.numOps - 1;
                        } else {
                            this.headerFlags = (short)(this.headerFlags | 0x20);
                            this.markDuplicate(this.numOps - 1, this.opZero);
                        }
                        this.postOp(false);
                        return;
                    }
                }
                this.addOpAndValue(op, bytes);
            } else if (bytes.length < 256) {
                this.addOpAndValue(52, bytes);
            }
        }

        private void push(int opIndex) {
            if (this.ctx.depth >= this.opStack.length) {
                this.opStack = Arrays.copyOf(this.opStack, this.opStack.length * 2);
            }
            this.opStack[this.depth] = opIndex;
            this.depth = (byte)(this.depth + 1);
            this.previousSiblingIdx = -1;
        }

        private void addOp(int op) {
            int thisOp = this.numOps++;
            this.ops[thisOp] = (byte)op;
            this.depths[thisOp] = this.depth;
            if (this.previousSiblingIdx != -1) {
                this.nextSiblings[this.previousSiblingIdx] = thisOp;
            }
            this.nextSiblings[thisOp] = -1;
            if (this.depth > 0) {
                int n2 = this.opStack[this.depth - 1];
                this.numChildren[n2] = this.numChildren[n2] + 1;
            }
            this.previousSiblingIdx = thisOp;
        }

        private void expandOp() {
            int l2 = this.ops.length * 2;
            this.ops = Arrays.copyOf(this.ops, l2);
            this.nextSiblings = Arrays.copyOf(this.nextSiblings, l2);
            this.fieldIDs = Arrays.copyOf(this.fieldIDs, l2);
            this.depths = Arrays.copyOf(this.depths, l2);
            this.numChildren = Arrays.copyOf(this.numChildren, l2);
            this.valueIndex = Arrays.copyOf(this.valueIndex, l2);
        }

        private void preOp() {
            if (this.numOps >= this.ops.length) {
                this.expandOp();
            }
            this.numChildren[this.numOps] = 0;
        }

        private void postOp(boolean shareable) {
            if (this.lastValueSharing && this.keyI != -1 && this.keyJ != -1) {
                this.initKeysLastSeenValue(this.keyI);
                int idx = this.numOps - 1;
                if (this.numChildren[idx] >= 0 && shareable) {
                    this.keysLastSeenValue[this.keyI][this.keyJ] = idx;
                }
                this.keyJ = -1;
                this.keyI = -1;
            }
            this.opLastValue = -1;
        }

        private void addValue(byte[] bytes) {
            this.expandValueHeap(bytes.length);
            this.addValueNoCheck(bytes);
        }

        private void addValueNoCheck(byte[] bytes) {
            this.valueIndex[this.numOps] = this.valueHeapSize;
            System.arraycopy(bytes, 0, this.valueHeap, this.valueHeapSize, bytes.length);
            this.valueHeapSize += bytes.length;
        }

        private boolean equals(byte[] a1, int a1Start, byte[] a2, int a2Start, int len) {
            for (int i2 = 0; i2 < len; ++i2) {
                if (a1[a1Start] != a2[a2Start]) {
                    return false;
                }
                ++a1Start;
                ++a2Start;
            }
            return true;
        }

        private void expandValueHeap(int len) {
            if (len + this.valueHeapSize >= this.valueHeap.length) {
                int newSize = (len + this.valueHeapSize) * 2;
                if (newSize <= 0) {
                    throw OracleJsonExceptions.IMAGE_TOO_BIG.create(this.getExceptionFactory(), new Object[0]);
                }
                this.valueHeap = Arrays.copyOf(this.valueHeap, newSize);
            }
        }

        private void initializeKeyHeap() throws UnsupportedEncodingException {
            if (this.keyHeap == null) {
                this.keyHeap = new byte[this.distinctKeysSize * 15];
            }
            if (this.keyHeapOffsets == null || this.keyHeapOffsets.length < this.distinctKeysSize) {
                this.keyHeapOffsets = new int[this.distinctKeysSize];
            }
            this.keyHeapSize = 0;
            for (int i2 = 0; i2 < this.distinctKeysSize; ++i2) {
                int result;
                int len;
                this.keyHeapOffsets[i2] = this.keyHeapSize;
                String key = this.distinctKeys[i2];
                int maxBytesAdded = 1 + key.length() * 4;
                if (maxBytesAdded + this.keyHeapSize >= this.keyHeap.length) {
                    this.keyHeap = Arrays.copyOf(this.keyHeap, (this.keyHeap.length + maxBytesAdded) * 2);
                }
                if ((len = (result = this.writeString(key, this.keyHeap, this.keyHeapSize + 1)) - this.keyHeapSize - 1) > 256) {
                    throw OracleJsonExceptions.LONG_KEY.create(this.getExceptionFactory(), key);
                }
                this.keyHeap[this.keyHeapSize] = (byte)len;
                this.keyHeapSize = result;
            }
        }

        public OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
            return OracleJsonExceptions.ORACLE_FACTORY;
        }

        private int writeString(String value, byte[] destination, int destinationPos) {
            int ct = destinationPos;
            int len = value.length();
            for (int i2 = 0; i2 < len; ++i2) {
                char c2 = value.charAt(i2);
                if (c2 >= '\u007f') {
                    return this.slowWriteString(value, destination, destinationPos);
                }
                destination[ct++] = (byte)c2;
            }
            return ct;
        }

        private int writeUTF8String(byte[] source, int sourceOffset, int len, byte[] destination, int destinationPos) {
            int ct = destinationPos;
            for (int i2 = 0; i2 < len; ++i2) {
                destination[ct++] = source[sourceOffset++];
            }
            return ct;
        }

        private int slowWriteString(String value, byte[] destination, int destinationPos) {
            byte[] result = value.getBytes(StandardCharsets.UTF_8);
            for (int i2 = 0; i2 < result.length; ++i2) {
                destination[destinationPos++] = result[i2];
            }
            return destinationPos;
        }

        private void writeHeader() throws IOException {
            this.writeInt(-11904511);
            if (this.distinctKeysSize >= 65536) {
                this.headerFlags = (short)(this.headerFlags | 8);
            } else if (this.distinctKeysSize >= 256) {
                this.headerFlags = (short)(this.headerFlags | 0x400);
            }
            if (this.distinctKeysSize > 0) {
                this.headerFlags = (short)(this.headerFlags | 0x100);
            }
            if (this.keyHeapSize >= 65536) {
                this.headerFlags = (short)(this.headerFlags | 0x800);
            }
            if (this.treeSegmentSize > 65536) {
                this.headerFlags = (short)(this.headerFlags | 0x1000);
            }
            if (this.relativeOffsets) {
                this.headerFlags = (short)(this.headerFlags | 1);
            }
            if (this.numOps == 1 && !this.isObject(this.ops[0]) && !this.isArray(this.ops[0])) {
                int flags = this.headerFlags;
                flags &= 0xFFFFDFFF;
                this.writeShort(flags |= 0x10);
                this.writeTreeSegmentSize();
                return;
            }
            this.writeShort(this.headerFlags);
            if (this.distinctKeysSize >= 65536) {
                this.writeInt(this.distinctKeysSize);
            } else if (this.distinctKeysSize >= 256) {
                this.writeShort(this.distinctKeysSize);
            } else {
                this.writeByte(this.distinctKeysSize);
            }
            if (this.keyHeapSize >= 65536) {
                this.writeInt(this.keyHeapSize);
            } else {
                this.writeShort(this.keyHeapSize);
            }
            this.writeTreeSegmentSize();
            if ((this.headerFlags & 0x2000) != 0) {
                this.writeShort(this.tinyNodeCount);
            } else {
                this.writeShort(0);
            }
        }

        private void writeTreeSegmentSize() throws IOException {
            if (this.treeSegmentSize > 65536) {
                this.writeInt(this.treeSegmentSize);
            } else {
                this.writeShort(this.treeSegmentSize);
            }
        }

        private void writeNameDictionary() throws IOException {
            if (this.fidMap == null || this.fidMap.length < this.distinctKeysSize) {
                this.fidMap = new int[this.distinctKeysSize];
            }
            this.initTemporaryIntArray(this.distinctKeysSize);
            if (this.seenHashSize < SEEN_HASH_THRESHOLD) {
                Arrays.sort(this.seenHash, 0, this.seenHashSize);
                int offIdx = 0;
                for (int k2 = 0; k2 < this.seenHashSize; ++k2) {
                    int i2 = this.seenHash[k2];
                    offIdx = this.processBucket(offIdx, i2);
                }
            } else {
                int offIdx = 0;
                for (int i3 = 0; i3 < this.keys.length; ++i3) {
                    if (this.keys[i3] == null) continue;
                    offIdx = this.processBucket(offIdx, i3);
                }
            }
            this.keysNeedReset = false;
            if (this.keyHeapSize >= 65536) {
                this.writeUb4Array(this.temporaryIntArray, this.distinctKeysSize);
            } else {
                this.writeUb2Array(this.temporaryIntArray, this.distinctKeysSize);
            }
            this.write(this.keyHeap, 0, this.keyHeapSize);
        }

        private int processBucket(int offIdx, int hash) throws IOException {
            int off;
            int[] bucket = this.keys[hash];
            int[] lastValuesBucket = this.lastValueSharing ? this.keysLastSeenValue[hash] : null;
            this.sortBucket(bucket);
            for (int j2 = 0; j2 < bucket.length && (off = bucket[j2] - 1) != -1; ++j2) {
                this.writeByte(hash);
                bucket[j2] = 0;
                if (this.lastValueSharing) {
                    lastValuesBucket[j2] = 0;
                }
                this.fidMap[off] = offIdx;
                this.temporaryIntArray[offIdx++] = this.keyHeapOffsets[off];
            }
            return offIdx;
        }

        private void sortBucket(int[] bucket) {
            for (int i2 = 0; i2 < bucket.length && bucket[i2] != 0; ++i2) {
                for (int j2 = i2 + 1; j2 < bucket.length && bucket[j2] != 0; ++j2) {
                    int keyHeapOff2 = this.keyHeapOffsets[bucket[j2] - 1];
                    int l2 = this.keyHeap[keyHeapOff2] & 0xFF;
                    int keyHeapOff1 = this.keyHeapOffsets[bucket[i2] - 1];
                    int l1 = this.keyHeap[keyHeapOff1] & 0xFF;
                    if (l2 >= l1 && (l2 != l1 || this.memcmp(keyHeapOff2 + 1, keyHeapOff1 + 1, l1) >= 0)) continue;
                    int tmp = bucket[i2];
                    bucket[i2] = bucket[j2];
                    bucket[j2] = tmp;
                }
            }
        }

        private int memcmp(int i2, int j2, int length) {
            for (int k2 = 0; k2 < length; ++k2) {
                int d2 = (this.keyHeap[i2 + k2] & 0xFF) - (this.keyHeap[j2 + k2] & 0xFF);
                if (d2 == 0) continue;
                return d2;
            }
            return 0;
        }

        private void writeTreeNodeSegment() throws IOException {
            block20: for (int index = 0; index < this.numOps; ++index) {
                int i2;
                int childCt;
                int parentOffset;
                byte op = this.ops[index];
                if (this.isShared(index)) continue;
                if (this.isArray(op)) {
                    parentOffset = this.offsets[index];
                    childCt = this.numChildren[index];
                    this.writeByte(this.flagObjectOrArray(op, childCt));
                    if (childCt < 256) {
                        this.writeByte(childCt);
                    } else if (childCt < 65536) {
                        this.writeShort(childCt);
                    } else {
                        this.writeInt(childCt);
                    }
                    this.initTemporaryIntArray(childCt);
                    int childIdx = index + 1;
                    for (i2 = 0; i2 < childCt; ++i2) {
                        this.temporaryIntArray[i2] = this.offsets[childIdx];
                        childIdx = this.nextSiblings[childIdx];
                    }
                    this.writeChildOffsets(childCt, this.temporaryIntArray, parentOffset);
                    continue;
                }
                if (this.isObject(op)) {
                    parentOffset = this.offsets[index];
                    childCt = this.numChildren[index];
                    this.writeByte(this.flagObject(op, childCt));
                    this.initTemporaryLongArray(childCt);
                    if (this.sharesFields(op)) {
                        int firstChild = this.firstChild(index);
                        int delagateIdx = this.fieldIDs[firstChild];
                        int delagate = this.offsets[delagateIdx];
                        this.fieldIDs[firstChild] = this.fieldIDs[this.firstChild(delagateIdx)];
                        if (this.treeSegmentSize < 65536) {
                            this.writeShort(delagate);
                        } else {
                            this.writeInt(delagate);
                        }
                        this.packOffsets(index, childCt, this.temporaryLongArray);
                        if (childCt > 10 && (op & 4) == 0) {
                            Arrays.sort(this.temporaryLongArray, 0, childCt);
                        }
                        this.writeChildOffsets(childCt, this.temporaryLongArray, parentOffset);
                        continue;
                    }
                    this.packOffsets(index, childCt, this.temporaryLongArray);
                    if (childCt > 10 && (op & 4) == 0) {
                        Arrays.sort(this.temporaryLongArray, 0, childCt);
                    } else if (this.duplicateKeyMode == DuplicateKeyMode.DISALLOW) {
                        this.checkDuplicateKeys(this.temporaryLongArray, childCt);
                    }
                    if (childCt < 256) {
                        this.writeByte(childCt);
                    } else if (childCt < 65536) {
                        this.writeShort(childCt);
                    } else {
                        this.writeInt(childCt);
                    }
                    int lastFid = -1;
                    for (i2 = 0; i2 < childCt; ++i2) {
                        int fid = this.unpackFid(this.temporaryLongArray[i2]);
                        if (fid == lastFid && this.duplicateKeyMode == DuplicateKeyMode.DISALLOW) {
                            throw OracleJsonExceptions.DUPLICATE_KEY.create(this.getExceptionFactory(), this.reverseFidMap(fid));
                        }
                        lastFid = fid;
                        if (this.distinctKeysSize >= 65536) {
                            this.writeInt(fid);
                            continue;
                        }
                        if (this.distinctKeysSize >= 256) {
                            this.writeShort(fid);
                            continue;
                        }
                        this.writeByte(fid);
                    }
                    this.writeChildOffsets(childCt, this.temporaryLongArray, parentOffset);
                    continue;
                }
                if (op <= 31) {
                    this.writeOpAndData(op, this.valueHeap, this.valueIndex[index], op);
                    continue;
                }
                if (OsonConstants.isSB4(op) || OsonConstants.isSB8(op) || OsonConstants.isOraNum16(op) || OsonConstants.isDec_16(op)) {
                    this.writeByte(op);
                    this.write(this.valueHeap, this.valueIndex[index], this.numChildren[index]);
                    continue;
                }
                switch (op) {
                    case 49: {
                        this.writeByte(op);
                        continue block20;
                    }
                    case 50: {
                        this.writeByte(op);
                        continue block20;
                    }
                    case 48: {
                        this.writeByte(op);
                        continue block20;
                    }
                    case 51: 
                    case 52: 
                    case 116: {
                        this.writeByte(op);
                        int size = this.numChildren[index];
                        this.writeByte(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block20;
                    }
                    case 55: {
                        this.writeByte(op);
                        int size = this.numChildren[index];
                        this.writeShort(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block20;
                    }
                    case 56: {
                        this.writeByte(op);
                        int size = this.numChildren[index];
                        this.writeInt(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block20;
                    }
                    case 54: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], 8);
                        continue block20;
                    }
                    case 127: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], 4);
                        continue block20;
                    }
                    case 126: {
                        this.writeByte(op);
                        int size = this.numChildren[index];
                        this.writeByte(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block20;
                    }
                    case 58: {
                        this.writeByte(op);
                        int size = this.numChildren[index];
                        this.writeShort(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block20;
                    }
                    case 59: {
                        this.writeByte(op);
                        int size = this.numChildren[index];
                        this.writeInt(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block20;
                    }
                    case 57: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], OsonPrimitiveConversions.SIZE_TIMESTAMP);
                        continue block20;
                    }
                    case 125: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], OsonPrimitiveConversions.SIZE_TIMESTAMP_NOFRAC);
                        continue block20;
                    }
                    case 124: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], OsonPrimitiveConversions.SIZE_TIMESTAMPTZ);
                        continue block20;
                    }
                    case 60: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], OsonPrimitiveConversions.SIZE_DATE);
                        continue block20;
                    }
                    case 62: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], 11);
                        continue block20;
                    }
                    case 61: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], 5);
                        continue block20;
                    }
                    case 53: {
                        int size = this.numChildren[index];
                        if (size == 0) continue block20;
                        this.writeByte(op);
                        this.writeByte(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block20;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.valueOf(op));
                    }
                }
            }
        }

        private String reverseFidMap(int fid) {
            for (int i2 = 0; i2 < this.distinctKeysSize; ++i2) {
                if (this.fidMap[i2] != fid - 1) continue;
                return this.distinctKeys[i2];
            }
            return "";
        }

        private void packOffsets(int index, int childCt, long[] packedArray) {
            int childIdx = index + 1;
            for (int i2 = 0; i2 < childCt; ++i2) {
                int childKeyIdx = this.fieldIDs[childIdx];
                long fid = this.fidMap[childKeyIdx] + 1;
                packedArray[i2] = fid << 32 | (long)this.offsets[childIdx];
                childIdx = this.nextSiblings[childIdx];
            }
        }

        private boolean sharesFields(int op) {
            return (op & 0x18) == 24;
        }

        private boolean isReferredTo(int op) {
            return (op & 2) == 2;
        }

        private void tryFieldIdSharing(int primaryIndex) {
            int siblingIndex = this.nextSiblings[primaryIndex];
            while (siblingIndex != -1) {
                if (this.sameFieldIds(primaryIndex, siblingIndex)) {
                    int n2 = siblingIndex;
                    this.ops[n2] = (byte)(this.ops[n2] | 0x18);
                    int n3 = primaryIndex;
                    this.ops[n3] = (byte)(this.ops[n3] | 2);
                    int firstChild = this.firstChild(siblingIndex);
                    this.fieldIDs[firstChild] = primaryIndex;
                }
                siblingIndex = this.nextSiblings[siblingIndex];
            }
        }

        private int firstChild(int index) {
            if (index + 1 >= this.numOps) {
                return -1;
            }
            byte nextDepth = this.depths[index + 1];
            byte thisDepth = this.depths[index];
            if (nextDepth == thisDepth + 1) {
                return index + 1;
            }
            return -1;
        }

        private boolean sameFieldIds(int p1, int p2) {
            if (!this.isObject(this.ops[p1]) || !this.isObject(this.ops[p2]) || this.numChildren[p1] != this.numChildren[p2] || this.numChildren[p1] == 0 || (this.ops[p1] & 4) != 0 || (this.ops[p2] & 4) != 0) {
                return false;
            }
            int child1 = this.firstChild(p1);
            int child2 = this.firstChild(p2);
            do {
                if (this.fieldIDs[child1] != this.fieldIDs[child2]) {
                    return false;
                }
                child1 = this.nextSiblings[child1];
                child2 = this.nextSiblings[child2];
                if (child1 != -1) continue;
                return child2 == -1;
            } while (child2 != -1);
            return false;
        }

        private boolean isArray(int op) {
            return (op & 0xC0) == 192;
        }

        private boolean isObject(int op) {
            return (op & 0xC0) == 128;
        }

        private boolean isStructure(int op) {
            return op < 0;
        }

        private void writeChildOffsets(int childCt, long[] arr, int fixedOffset) throws IOException {
            int delta;
            int n2 = delta = this.relativeOffsets ? fixedOffset : 0;
            if (this.treeSegmentSize < 65536) {
                for (int i2 = 0; i2 < childCt; ++i2) {
                    short off = (short)(arr[i2] & 0xFFFFL);
                    off = (short)(off - delta);
                    this.writeShort(off);
                }
            } else {
                for (int i3 = 0; i3 < childCt; ++i3) {
                    int off = (int)(arr[i3] & 0xFFFFFFFFFFFFFFFFL);
                    this.writeInt(off -= delta);
                }
            }
        }

        private void writeChildOffsets(int childCt, int[] arr, int fixedOffset) throws IOException {
            int delta;
            int n2 = delta = this.relativeOffsets ? fixedOffset : 0;
            if (this.treeSegmentSize < 65536) {
                for (int i2 = 0; i2 < childCt; ++i2) {
                    short off = (short)(arr[i2] & 0xFFFF);
                    this.writeShort(off - delta);
                }
            } else {
                for (int i3 = 0; i3 < childCt; ++i3) {
                    int off = arr[i3];
                    this.writeInt(off - delta);
                }
            }
        }

        private void initTemporaryLongArray(int ct) {
            if (this.temporaryLongArray == null || this.temporaryLongArray.length < ct) {
                this.temporaryLongArray = new long[ct];
            }
        }

        private int unpackFid(long packed) {
            return (int)(packed >>> 32);
        }

        public void checkDuplicateKeys(long[] children, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int fid = this.unpackFid(children[i2]);
                for (int j2 = i2 + 1; j2 < count; ++j2) {
                    if (this.unpackFid(children[j2]) != fid) continue;
                    throw OracleJsonExceptions.DUPLICATE_KEY.create(this.getExceptionFactory(), this.distinctKeys[fid - 1]);
                }
            }
        }

        private void initTemporaryIntArray(int ct) {
            if (this.temporaryIntArray == null || this.temporaryIntArray.length < ct) {
                this.temporaryIntArray = new int[ct];
            }
        }

        private void computeOffsets() {
            int size;
            int i2;
            if (this.offsets == null || this.numOps > this.offsets.length) {
                this.offsets = new int[this.numOps];
            }
            int offset = 0;
            this.tinyNodeCount = 0;
            for (i2 = 0; i2 < this.numOps; ++i2) {
                if (this.isShared(i2)) {
                    this.offsets[i2] = this.offsets[-this.numChildren[i2]];
                    continue;
                }
                this.offsets[i2] = offset;
                if (this.isFirstChildObjectOfArray(i2)) {
                    this.tryFieldIdSharing(i2);
                }
                size = this.sizeOfOp(i2, 2);
                this.countTiny(i2, size);
                if ((offset += size) < 65536) continue;
                offset = -1;
                break;
            }
            if (offset != -1) {
                this.treeSegmentSize = offset;
                return;
            }
            offset = 0;
            this.tinyNodeCount = 0;
            for (i2 = 0; i2 < this.numOps; ++i2) {
                if (this.isShared(i2)) {
                    this.offsets[i2] = this.offsets[-this.numChildren[i2]];
                    continue;
                }
                this.offsets[i2] = offset;
                if (this.isFirstChildObjectOfArray(i2)) {
                    this.tryFieldIdSharing(i2);
                }
                size = this.sizeOfOp(i2, 4);
                this.countTiny(i2, size);
                if ((offset += size) >= 0) continue;
                throw OracleJsonExceptions.IMAGE_TOO_BIG.create(this.getExceptionFactory(), new Object[0]);
            }
            this.treeSegmentSize = offset;
        }

        private boolean isShared(int opIndex) {
            return this.numChildren[opIndex] < 0;
        }

        private void countTiny(int i2, int size) {
            if (this.isStructure(this.ops[i2]) && (size < 5 || this.isObject(this.ops[i2]) && this.isReferredTo(this.ops[i2]))) {
                ++this.tinyNodeCount;
            }
        }

        private boolean isFirstChildObjectOfArray(int i2) {
            return this.isObject(this.ops[i2]) && i2 > 0 && this.firstChild(i2 - 1) == i2 && this.isArray(this.ops[i2 - 1]);
        }

        private int sizeOfOp(int index, int offsetSize) {
            byte op = this.ops[index];
            if (this.isShared(index)) {
                return 0;
            }
            if (this.isArray(op)) {
                int numOfChildren = this.numChildren[index];
                int bytesForNumChildren = this.bytesForNum(numOfChildren);
                int size = 1 + bytesForNumChildren;
                return size += offsetSize * numOfChildren;
            }
            if (this.isObject(op)) {
                int numOfChildren = this.numChildren[index];
                if (this.sharesFields(op)) {
                    return 1 + offsetSize + numOfChildren * offsetSize;
                }
                int bytesForNumChildren = this.bytesForNum(numOfChildren);
                int fidArraySize = numOfChildren;
                if (this.distinctKeysSize >= 65536) {
                    fidArraySize *= 4;
                } else if (this.distinctKeysSize >= 256) {
                    fidArraySize *= 2;
                }
                int size = 1 + bytesForNumChildren + fidArraySize;
                return size += numOfChildren * offsetSize;
            }
            if (op <= 31) {
                return 1 + op;
            }
            if (OsonConstants.isSB4(op) || OsonConstants.isSB8(op) || OsonConstants.isOraNum16(op) || OsonConstants.isDec_16(op)) {
                return 1 + this.numChildren[index];
            }
            switch (op) {
                case 49: {
                    return 1;
                }
                case 50: {
                    return 1;
                }
                case 48: {
                    return 1;
                }
                case 51: {
                    return 2 + this.numChildren[index];
                }
                case 55: {
                    return 3 + this.numChildren[index];
                }
                case 56: {
                    return 5 + this.numChildren[index];
                }
                case 52: 
                case 116: {
                    return 2 + this.numChildren[index];
                }
                case 54: {
                    return 9;
                }
                case 127: {
                    return 5;
                }
                case 58: {
                    return 3 + this.numChildren[index];
                }
                case 59: {
                    return 5 + this.numChildren[index];
                }
                case 126: {
                    return 2 + this.numChildren[index];
                }
                case 57: {
                    return OsonPrimitiveConversions.SIZE_TIMESTAMP + 1;
                }
                case 125: {
                    return OsonPrimitiveConversions.SIZE_TIMESTAMP_NOFRAC + 1;
                }
                case 124: {
                    return OsonPrimitiveConversions.SIZE_TIMESTAMPTZ + 1;
                }
                case 60: {
                    return OsonPrimitiveConversions.SIZE_DATE + 1;
                }
                case 62: {
                    return 12;
                }
                case 61: {
                    return 6;
                }
                case 53: {
                    int size = this.numChildren[index];
                    return size == 0 ? 0 : 2 + size;
                }
            }
            throw new UnsupportedOperationException(String.valueOf(op));
        }

        private int bytesForNum(int i2) {
            if (i2 < 256) {
                return 1;
            }
            if (i2 < 65536) {
                return 2;
            }
            return 4;
        }

        private int flagObject(int op, int numChildren) {
            if (numChildren <= 10) {
                return this.flagObjectOrArray(op, numChildren) | 4;
            }
            return this.flagObjectOrArray(op, numChildren);
        }

        private int flagObjectOrArray(int op, int numChildren) {
            if (numChildren >= 256) {
                op = numChildren < 65536 ? (op |= 8) : (op |= 0x10);
            }
            if (this.treeSegmentSize > 65536) {
                op |= 0x20;
            }
            return op;
        }

        private void writeUb2Array(int[] arr, int len) throws IOException {
            for (int i2 = 0; i2 < len; ++i2) {
                this.writeShort(arr[i2]);
            }
        }

        private void writeUb4Array(int[] arr, int len) throws IOException {
            for (int i2 = 0; i2 < len; ++i2) {
                this.writeInt(arr[i2]);
            }
        }

        private final void writeInt(int value) throws IOException {
            if (this.outBufferPos + 3 >= this.outBuffer.length) {
                this.flushBuffer();
            }
            this.outBuffer[this.outBufferPos++] = (byte)(value >>> 24 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(value >>> 16 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(value >>> 8 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(value >>> 0 & 0xFF);
        }

        private final void writeShort(int value) throws IOException {
            if (this.outBufferPos + 1 >= this.outBuffer.length) {
                this.flushBuffer();
            }
            this.outBuffer[this.outBufferPos++] = (byte)(value >>> 8 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(value >>> 0 & 0xFF);
        }

        private final void writeByte(int b2) throws IOException {
            if (this.outBufferPos >= this.outBuffer.length) {
                this.flushBuffer();
            }
            this.outBuffer[this.outBufferPos++] = (byte)b2;
        }

        private void flushBuffer() throws IOException {
            this.out.write(this.outBuffer, 0, this.outBufferPos);
            this.outBufferPos = 0;
        }

        private final void write(byte[] bytes, int start, int len) throws IOException {
            if (this.outBufferPos + len > this.outBuffer.length) {
                this.flushBuffer();
                if (len >= this.outBuffer.length) {
                    this.out.write(bytes, start, len);
                    return;
                }
            }
            System.arraycopy(bytes, start, this.outBuffer, this.outBufferPos, len);
            this.outBufferPos += len;
        }

        private final void writeOpAndData(int op, byte[] bytes, int start, int len) throws IOException {
            if (this.outBufferPos + (len + 1) > this.outBuffer.length) {
                this.flushBuffer();
                if (len + 1 >= this.outBuffer.length) {
                    this.out.write(op);
                    this.out.write(bytes, start, len);
                    return;
                }
            }
            this.outBuffer[this.outBufferPos++] = (byte)op;
            System.arraycopy(bytes, start, this.outBuffer, this.outBufferPos, len);
            this.outBufferPos += len;
        }

        private void reset(OutputStream out) {
            this.out = out;
            this.valueHeapSize = 0;
            this.numOps = 0;
            this.distinctKeysSize = 0;
            this.seenHashSize = 0;
            this.headerFlags = (short)8198;
            this.setUseRelativeOffsets(DEFAULT_RELATIVE_OFFSETS);
            this.setTinyNodeStat(DEFAULT_TINYNODE);
            this.setSimpleValueSharing(DEFAULT_SIMPLE_VALUE_SHARING);
            this.setLastValueSharing(DEFAULT_LAST_VALUE_SHARING);
            if (this.keysNeedReset) {
                for (int i2 = 0; i2 < this.keys.length; ++i2) {
                    for (int j2 = 0; this.keys[i2] != null && j2 < this.keys[i2].length && this.keys[i2][j2] != 0; ++j2) {
                        this.keys[i2][j2] = 0;
                        if (!this.lastValueSharing) continue;
                        this.keysLastSeenValue[i2][j2] = 0;
                    }
                }
            }
            this.opLastValue = -1;
            this.keysNeedReset = true;
            this.depth = 0;
            this.outBufferPos = 0;
            this.tinyNodeCount = 0;
            this.duplicateKeyMode = DEFAULT_DUPLICATE_KEY_MODE;
            this.opEmptyArray = -1;
            this.opEmptyObject = -1;
            this.opEmptyString = -1;
            this.opOne = -1;
            this.opZero = -1;
            this.opNull = -1;
            this.opFalse = -1;
            this.opTrue = -1;
            this.keyJ = -1;
            this.keyI = -1;
            this.ctx.init();
            this.ctx.setExceptionFactory(this.getExceptionFactory());
        }

        private void initKeysLastSeenValue(int i2) {
            if (this.keysLastSeenValue == null) {
                this.keysLastSeenValue = new int[256][];
            }
            if (this.keysLastSeenValue[i2] == null) {
                this.keysLastSeenValue[i2] = new int[this.keys[i2].length];
            } else if (this.keysLastSeenValue[i2].length < this.keys[i2].length) {
                this.keysLastSeenValue[i2] = Arrays.copyOf(this.keysLastSeenValue[i2], this.keys[i2].length);
            }
        }

        public void setTinyNodeStat(boolean value) {
            this.headerFlags = value ? (short)(this.headerFlags | 0x2000) : (short)(this.headerFlags & 0xFFFFDFFF);
        }

        public void setUseRelativeOffsets(boolean value) {
            this.relativeOffsets = value;
        }

        public void setSimpleValueSharing(boolean value) {
            this.simpleValueSharing = value;
        }

        public void setLastValueSharing(boolean value) {
            this.lastValueSharing = value;
        }

        private void writeTimestamp(byte[] raw) {
            if (raw.length == OsonPrimitiveConversions.SIZE_TIMESTAMP) {
                this.fixedBinary(57, raw.length, raw);
            } else {
                this.fixedBinary(125, raw.length, raw);
            }
        }

        public void writeTimestampTZ(byte[] raw) {
            OsonPrimitiveConversions.assertNoRegionTimestampTZ(this.getExceptionFactory(), raw);
            this.fixedBinary(124, raw.length, raw);
        }

        private void writeDate(byte[] raw) {
            this.fixedBinary(60, OsonPrimitiveConversions.SIZE_DATE, raw);
        }

        private void writeIntervalYM(byte[] raw) {
            this.fixedBinary(61, 5, raw);
        }

        private void writeIntervalDS(byte[] raw) {
            this.fixedBinary(62, 11, raw);
        }

        private void fixedBinary(int op, int len, byte[] bytes) {
            if (len != bytes.length) {
                throw new IllegalArgumentException();
            }
            this.addOpAndValue(op, bytes);
        }

        public void close() {
            this.ctx.close();
            try {
                this.initializeKeyHeap();
                this.computeOffsets();
                this.writeHeader();
                this.writeNameDictionary();
                this.writeTreeNodeSegment();
                this.flushBuffer();
                this.out.close();
            }
            catch (IOException e2) {
                throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e2, new Object[0]);
            }
        }

        private void writeString(String value) {
            this.preOp();
            this.expandValueHeap(value.length() * 4);
            this.valueIndex[this.numOps] = this.valueHeapSize;
            int newPos = this.writeString(value, this.valueHeap, this.valueHeapSize);
            int len = newPos - this.valueHeapSize;
            this.valueHeapSize = newPos;
            this.writeStringOp(newPos, len);
            boolean duplicate = this.checkStringDuplicate(len);
            this.postOp(!duplicate);
        }

        private boolean checkStringDuplicate(int len) {
            if (this.lastValueSharing && this.opLastValue != -1 && this.ops[this.numOps - 1] == this.ops[this.opLastValue] && this.numChildren[this.opLastValue] == len && this.equals(this.valueHeap, this.valueIndex[this.numOps - 1], this.valueHeap, this.valueIndex[this.opLastValue], len)) {
                this.markDuplicate(this.numOps - 1, this.opLastValue);
                this.headerFlags = (short)(this.headerFlags | 0x40);
                return true;
            }
            if (len == 0 && this.simpleValueSharing) {
                if (this.opEmptyString == -1) {
                    this.opEmptyString = this.numOps - 1;
                } else {
                    this.headerFlags = (short)(this.headerFlags | 0x20);
                    this.markDuplicate(this.numOps - 1, this.opEmptyString);
                }
                return true;
            }
            return false;
        }

        private void writeUTF8String(byte[] array, int offset, int len) {
            int newPos;
            this.preOp();
            this.expandValueHeap(len);
            this.valueIndex[this.numOps] = this.valueHeapSize;
            this.valueHeapSize = newPos = this.writeUTF8String(array, offset, len, this.valueHeap, this.valueHeapSize);
            this.writeStringOp(newPos, len);
            this.checkStringDuplicate(len);
            this.postOp(true);
        }

        private void writeStringOp(int newPos, int len) {
            if (len <= 31) {
                this.addOp(len);
            } else if (len < 256) {
                this.addOp(51);
            } else if (len < 65536) {
                this.addOp(55);
            } else {
                this.addOp(56);
            }
            this.numChildren[this.numOps - 1] = len;
            this.ctx.primitive();
        }

        private void writeStartObject() {
            this.preOp();
            this.addOp(128);
            this.push(this.numOps - 1);
            this.ctx.startObject();
            this.postOp(false);
        }

        private void writeStartObjectNoSort() {
            this.preOp();
            this.addOp(132);
            this.push(this.numOps - 1);
            this.ctx.startObject();
            this.postOp(false);
        }

        private void writeStartArray() {
            this.preOp();
            this.addOp(192);
            this.push(this.numOps - 1);
            this.ctx.startArray();
            this.postOp(false);
        }

        public void writeEnd() {
            this.ctx.end();
            this.depth = (byte)(this.depth - 1);
            this.previousSiblingIdx = this.opStack[this.depth];
            if (this.simpleValueSharing && this.numChildren[this.opStack[this.depth]] == 0) {
                int index = this.opStack[this.depth];
                if (this.isArray(this.ops[index])) {
                    if (this.opEmptyArray == -1) {
                        this.opEmptyArray = index;
                    } else {
                        this.headerFlags = (short)(this.headerFlags | 0x20);
                        this.markDuplicate(index, this.opEmptyArray);
                    }
                } else if (this.opEmptyObject == -1) {
                    this.opEmptyObject = index;
                } else {
                    this.headerFlags = (short)(this.headerFlags | 0x20);
                    this.markDuplicate(index, this.opEmptyObject);
                }
            }
        }

        private void writeDouble(double value) {
            byte[] bytes = OsonPrimitiveConversions.doubleToCanonicalFormatBytes(value);
            this.addOpAndValue(54, bytes);
        }

        private void writeBoolean(boolean value) {
            this.preOp();
            if (value) {
                this.addOp(49);
                if (this.simpleValueSharing) {
                    if (this.opTrue == -1) {
                        this.opTrue = this.numOps - 1;
                    } else {
                        this.headerFlags = (short)(this.headerFlags | 0x20);
                        this.markDuplicate(this.numOps - 1, this.opTrue);
                    }
                }
            } else {
                this.addOp(50);
                if (this.simpleValueSharing) {
                    if (this.opFalse == -1) {
                        this.opFalse = this.numOps - 1;
                    } else {
                        this.headerFlags = (short)(this.headerFlags | 0x20);
                        this.markDuplicate(this.numOps - 1, this.opFalse);
                    }
                }
            }
            this.ctx.primitive();
            this.postOp(true);
        }

        private void writeOraNumber(OracleJsonDecimal value) {
            OracleJsonDecimalImpl impl = (OracleJsonDecimalImpl)value;
            if (impl.isDec()) {
                this.writeDecimal(impl.bigDecimalValue());
            } else if (impl.isSB4()) {
                this.writeSB4(impl.intValue());
            } else if (impl.isSB8()) {
                this.writeSB8(impl.longValue());
            } else {
                this.writeNumber(impl.raw());
            }
        }

        private void writeDecimal(BigDecimal value) {
            byte[] bytes = OsonPrimitiveConversions.toNumber(value);
            this.writeDecimal(bytes);
        }

        private void writeDecimal(byte[] bytes) {
            if (bytes.length <= 8) {
                this.addOpAndValue(bytes.length - 1 | OsonConstants.MASK_DEC_16, bytes);
            } else if (bytes.length < 256) {
                this.addOpAndValue(116, bytes);
            }
        }

        private void writeDecimal(BigInteger value) {
            this.writeDecimal(OsonPrimitiveConversions.toNumber(value));
        }

        private void writeSB4(int value) {
            byte[] raw = OsonPrimitiveConversions.toNumber(value);
            int op = raw.length | OsonConstants.MASK_SB4;
            this.addOpAndValue(op, raw);
        }

        private void markDuplicate(int index, int replacingIndex) {
            this.numChildren[index] = -replacingIndex;
        }

        private boolean tryMarkDuplicate(int op, byte[] bytes) {
            if (this.lastValueSharing && this.opLastValue != -1 && op == this.ops[this.opLastValue] && this.numChildren[this.opLastValue] == bytes.length && this.equals(bytes, 0, this.valueHeap, this.valueIndex[this.opLastValue], bytes.length)) {
                this.markDuplicate(this.numOps, this.opLastValue);
                this.headerFlags = (short)(this.headerFlags | 0x40);
                return true;
            }
            return false;
        }

        private void addOpAndValue(int op, byte[] raw) {
            this.addOpAndValueNoPostOp(op, raw);
            this.postOp(true);
        }

        private void addOpAndValueNoPostOp(int op, byte[] raw) {
            this.preOp();
            if (!this.tryMarkDuplicate(op, raw)) {
                this.addValue(raw);
                this.numChildren[this.numOps] = raw.length;
            }
            this.addOp(op);
            this.ctx.primitive();
        }

        public void writeSB8(long value) {
            byte[] raw = OsonPrimitiveConversions.toNumber(value);
            this.addOpAndValue(raw.length | OsonConstants.MASK_SB8, raw);
        }

        private void writeNumberAsString(BigDecimal bd) {
            byte[] bytes = bd.toString().getBytes(StandardCharsets.UTF_8);
            if (bytes.length > 256) {
                throw new IllegalArgumentException();
            }
            this.addOpAndValue(53, bytes);
        }

        private void writeBytes(byte[] bytes) {
            int op = bytes.length < 65536 ? 58 : 59;
            this.addOpAndValue(op, bytes);
        }

        protected void writeId(byte[] bytes) {
            if (bytes.length > 16) {
                throw new UnsupportedOperationException();
            }
            this.addOpAndValue(126, bytes);
        }

        private void writeFloat(float value) {
            byte[] bytes = OsonPrimitiveConversions.floatToCanonicalFormatBytes(value);
            this.addOpAndValue(127, bytes);
        }

        private void writeKey(String key) {
            int fid;
            this.ctx.pendingKey();
            if (this.numOps >= this.ops.length) {
                this.expandOp();
            }
            this.keyI = OsonHeader.ub1hash(key);
            int[] fids = this.keys[this.keyI];
            if (fids == null) {
                this.keys[this.keyI] = new int[2];
                fids = this.keys[this.keyI];
            }
            this.keyJ = 0;
            while (this.keyJ < fids.length && (fid = fids[this.keyJ] - 1) != -1) {
                if (this.distinctKeys[fid].equals(key)) {
                    this.fieldIDs[this.numOps] = fid;
                    if (this.lastValueSharing) {
                        this.opLastValue = this.keysLastSeenValue[this.keyI][this.keyJ];
                    }
                    return;
                }
                ++this.keyJ;
            }
            if (this.keyJ >= fids.length) {
                this.keys[this.keyI] = Arrays.copyOf(this.keys[this.keyI], this.keys[this.keyI].length * 2);
                fids = this.keys[this.keyI];
            } else if (this.keyJ == 0 && this.seenHashSize < SEEN_HASH_THRESHOLD) {
                this.seenHash[this.seenHashSize++] = this.keyI;
            }
            if (this.distinctKeysSize + 1 >= this.distinctKeys.length) {
                this.distinctKeys = Arrays.copyOf(this.distinctKeys, this.distinctKeys.length * 2);
            }
            this.fieldIDs[this.numOps] = this.distinctKeysSize;
            this.distinctKeys[this.distinctKeysSize++] = key;
            fids[this.keyJ] = this.distinctKeysSize;
        }

        private void writeNull() {
            this.preOp();
            this.addOp(48);
            if (this.simpleValueSharing) {
                if (this.opNull == -1) {
                    this.opNull = this.numOps - 1;
                } else {
                    this.headerFlags = (short)(this.headerFlags | 0x20);
                    this.markDuplicate(this.numOps - 1, this.opNull);
                }
            }
            this.ctx.primitive();
            this.postOp(true);
        }

        static {
            try {
                $$$methodRef$$$93 = OsonGeneratorState.class.getDeclaredConstructor(OsonGeneratorStatePool.class, OutputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$92 = OsonGeneratorState.class.getDeclaredMethod("writeNull", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$91 = OsonGeneratorState.class.getDeclaredMethod("writeKey", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$90 = OsonGeneratorState.class.getDeclaredMethod("writeFloat", Float.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$89 = OsonGeneratorState.class.getDeclaredMethod("writeId", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$88 = OsonGeneratorState.class.getDeclaredMethod("writeBytes", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$87 = OsonGeneratorState.class.getDeclaredMethod("writeNumberAsString", BigDecimal.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$86 = OsonGeneratorState.class.getDeclaredMethod("writeSB8", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$85 = OsonGeneratorState.class.getDeclaredMethod("addOpAndValueNoPostOp", Integer.TYPE, byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$84 = OsonGeneratorState.class.getDeclaredMethod("addOpAndValue", Integer.TYPE, byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$83 = OsonGeneratorState.class.getDeclaredMethod("tryMarkDuplicate", Integer.TYPE, byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$82 = OsonGeneratorState.class.getDeclaredMethod("markDuplicate", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$81 = OsonGeneratorState.class.getDeclaredMethod("writeSB4", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$80 = OsonGeneratorState.class.getDeclaredMethod("writeDecimal", BigInteger.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$79 = OsonGeneratorState.class.getDeclaredMethod("writeDecimal", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$78 = OsonGeneratorState.class.getDeclaredMethod("writeDecimal", BigDecimal.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$77 = OsonGeneratorState.class.getDeclaredMethod("writeOraNumber", OracleJsonDecimal.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$76 = OsonGeneratorState.class.getDeclaredMethod("writeBoolean", Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$75 = OsonGeneratorState.class.getDeclaredMethod("writeDouble", Double.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$74 = OsonGeneratorState.class.getDeclaredMethod("writeEnd", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$73 = OsonGeneratorState.class.getDeclaredMethod("writeStartArray", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$72 = OsonGeneratorState.class.getDeclaredMethod("writeStartObjectNoSort", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$71 = OsonGeneratorState.class.getDeclaredMethod("writeStartObject", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$70 = OsonGeneratorState.class.getDeclaredMethod("writeStringOp", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$69 = OsonGeneratorState.class.getDeclaredMethod("writeUTF8String", byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$68 = OsonGeneratorState.class.getDeclaredMethod("checkStringDuplicate", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$67 = OsonGeneratorState.class.getDeclaredMethod("writeString", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$66 = OsonGeneratorState.class.getDeclaredMethod("close", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$65 = OsonGeneratorState.class.getDeclaredMethod("fixedBinary", Integer.TYPE, Integer.TYPE, byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$64 = OsonGeneratorState.class.getDeclaredMethod("writeIntervalDS", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$63 = OsonGeneratorState.class.getDeclaredMethod("writeIntervalYM", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$62 = OsonGeneratorState.class.getDeclaredMethod("writeDate", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$61 = OsonGeneratorState.class.getDeclaredMethod("writeTimestampTZ", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$60 = OsonGeneratorState.class.getDeclaredMethod("writeTimestamp", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$59 = OsonGeneratorState.class.getDeclaredMethod("setLastValueSharing", Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$58 = OsonGeneratorState.class.getDeclaredMethod("setSimpleValueSharing", Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$57 = OsonGeneratorState.class.getDeclaredMethod("setUseRelativeOffsets", Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$56 = OsonGeneratorState.class.getDeclaredMethod("setTinyNodeStat", Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$55 = OsonGeneratorState.class.getDeclaredMethod("initKeysLastSeenValue", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$54 = OsonGeneratorState.class.getDeclaredMethod("reset", OutputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$53 = OsonGeneratorState.class.getDeclaredMethod("writeOpAndData", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$52 = OsonGeneratorState.class.getDeclaredMethod("write", byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$51 = OsonGeneratorState.class.getDeclaredMethod("flushBuffer", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$50 = OsonGeneratorState.class.getDeclaredMethod("writeByte", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$49 = OsonGeneratorState.class.getDeclaredMethod("writeShort", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$48 = OsonGeneratorState.class.getDeclaredMethod("writeInt", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$47 = OsonGeneratorState.class.getDeclaredMethod("writeUb4Array", int[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$46 = OsonGeneratorState.class.getDeclaredMethod("writeUb2Array", int[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$45 = OsonGeneratorState.class.getDeclaredMethod("flagObjectOrArray", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$44 = OsonGeneratorState.class.getDeclaredMethod("flagObject", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$43 = OsonGeneratorState.class.getDeclaredMethod("bytesForNum", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$42 = OsonGeneratorState.class.getDeclaredMethod("sizeOfOp", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$41 = OsonGeneratorState.class.getDeclaredMethod("isFirstChildObjectOfArray", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$40 = OsonGeneratorState.class.getDeclaredMethod("countTiny", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$39 = OsonGeneratorState.class.getDeclaredMethod("isShared", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$38 = OsonGeneratorState.class.getDeclaredMethod("computeOffsets", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$37 = OsonGeneratorState.class.getDeclaredMethod("initTemporaryIntArray", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$36 = OsonGeneratorState.class.getDeclaredMethod("checkDuplicateKeys", long[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$35 = OsonGeneratorState.class.getDeclaredMethod("unpackFid", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$34 = OsonGeneratorState.class.getDeclaredMethod("initTemporaryLongArray", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$33 = OsonGeneratorState.class.getDeclaredMethod("writeChildOffsets", Integer.TYPE, int[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$32 = OsonGeneratorState.class.getDeclaredMethod("writeChildOffsets", Integer.TYPE, long[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$31 = OsonGeneratorState.class.getDeclaredMethod("isStructure", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$30 = OsonGeneratorState.class.getDeclaredMethod("isObject", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$29 = OsonGeneratorState.class.getDeclaredMethod("isArray", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$28 = OsonGeneratorState.class.getDeclaredMethod("sameFieldIds", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$27 = OsonGeneratorState.class.getDeclaredMethod("firstChild", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$26 = OsonGeneratorState.class.getDeclaredMethod("tryFieldIdSharing", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$25 = OsonGeneratorState.class.getDeclaredMethod("isReferredTo", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$24 = OsonGeneratorState.class.getDeclaredMethod("sharesFields", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$23 = OsonGeneratorState.class.getDeclaredMethod("packOffsets", Integer.TYPE, Integer.TYPE, long[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$22 = OsonGeneratorState.class.getDeclaredMethod("reverseFidMap", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$21 = OsonGeneratorState.class.getDeclaredMethod("writeTreeNodeSegment", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$20 = OsonGeneratorState.class.getDeclaredMethod("memcmp", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$19 = OsonGeneratorState.class.getDeclaredMethod("sortBucket", int[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$18 = OsonGeneratorState.class.getDeclaredMethod("processBucket", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$17 = OsonGeneratorState.class.getDeclaredMethod("writeNameDictionary", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$16 = OsonGeneratorState.class.getDeclaredMethod("writeTreeSegmentSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$15 = OsonGeneratorState.class.getDeclaredMethod("writeHeader", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$14 = OsonGeneratorState.class.getDeclaredMethod("slowWriteString", String.class, byte[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$13 = OsonGeneratorState.class.getDeclaredMethod("writeUTF8String", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$12 = OsonGeneratorState.class.getDeclaredMethod("writeString", String.class, byte[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$11 = OsonGeneratorState.class.getDeclaredMethod("getExceptionFactory", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = OsonGeneratorState.class.getDeclaredMethod("initializeKeyHeap", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = OsonGeneratorState.class.getDeclaredMethod("expandValueHeap", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = OsonGeneratorState.class.getDeclaredMethod("equals", byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = OsonGeneratorState.class.getDeclaredMethod("addValueNoCheck", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = OsonGeneratorState.class.getDeclaredMethod("addValue", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = OsonGeneratorState.class.getDeclaredMethod("postOp", Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = OsonGeneratorState.class.getDeclaredMethod("preOp", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = OsonGeneratorState.class.getDeclaredMethod("expandOp", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = OsonGeneratorState.class.getDeclaredMethod("addOp", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = OsonGeneratorState.class.getDeclaredMethod("push", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = OsonGeneratorState.class.getDeclaredMethod("writeNumber", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static final class DuplicateKeyMode
    extends Enum<DuplicateKeyMode> {
        public static final /* enum */ DuplicateKeyMode ALLOW;
        public static final /* enum */ DuplicateKeyMode DISALLOW;
        private static final /* synthetic */ DuplicateKeyMode[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static DuplicateKeyMode[] values() {
            return (DuplicateKeyMode[])$VALUES.clone();
        }

        public static DuplicateKeyMode valueOf(String name) {
            return Enum.valueOf(DuplicateKeyMode.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = DuplicateKeyMode.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = DuplicateKeyMode.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = DuplicateKeyMode.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            ALLOW = new DuplicateKeyMode();
            DISALLOW = new DuplicateKeyMode();
            $VALUES = new DuplicateKeyMode[]{ALLOW, DISALLOW};
        }
    }
}

