/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.modules.io.FileIOBuiltins;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;

final class OwnFD
extends AsyncHandler.SharedFinalizer.FinalizableReference {
    private final PythonContext context;

    public OwnFD(Object referent, int fd, PythonContext context) {
        super(referent, fd, context.getSharedFinalizer());
        this.context = context;
    }

    void doRelease() {
        this.markReleased();
        try (GilNode.UncachedRelease gil = GilNode.uncachedRelease();){
            PosixSupportLibrary.getUncached().close(this.context.getPosixSupport(), (Integer)this.getReference());
        }
        catch (PosixSupportLibrary.PosixException posixException) {
            // empty catch block
        }
    }

    @Override
    public AsyncHandler.AsyncAction release() {
        if (!this.isReleased()) {
            return new FileIOBuiltins.FDReleaseCallback(this);
        }
        return null;
    }
}

