/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.IteratorCompleteNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.JSInteropCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;

@ImportStatic(value={JSConfig.class, JSRuntime.class, Strings.class})
@GenerateUncached
public abstract class JSInteropGetIteratorNextNode
extends JSInteropCallNode {
    JSInteropGetIteratorNextNode() {
    }

    public final Object getIteratorNextElement(IteratorRecord receiver, JavaScriptLanguage language, Object stopValue) {
        try {
            return this.execute(receiver, language, stopValue);
        }
        catch (StopIterationException e) {
            throw Errors.shouldNotReachHere(e);
        }
    }

    public final Object getIteratorNextElement(IteratorRecord iterator, JavaScriptLanguage language) throws StopIterationException {
        return this.execute(iterator, language, null);
    }

    protected abstract Object execute(IteratorRecord var1, JavaScriptLanguage var2, Object var3) throws StopIterationException;

    @Specialization
    Object doDefault(IteratorRecord iterator, JavaScriptLanguage language, Object stopValue, @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callNode, @Cached IsObjectNode isObjectNode, @Cached IteratorCompleteNode iteratorCompleteNode, @Cached IteratorValueNode iteratorValueNode, @Cached ExportValueNode exportValueNode, @Cached InlinedBranchProfile exceptionBranch) throws StopIterationException {
        Object iterResult = callNode.executeCall(JSArguments.createZeroArg(iterator.getIterator(), iterator.getNextMethod()));
        if (isObjectNode.executeBoolean(iterResult)) {
            if (iteratorCompleteNode.execute(iterResult)) {
                if (stopValue != null) {
                    return stopValue;
                }
                throw StopIterationException.create();
            }
            Object value = iteratorValueNode.execute(iterResult);
            return exportValueNode.execute(value);
        }
        exceptionBranch.enter((Node)this);
        throw Errors.createTypeErrorIteratorResultNotObject(iterResult, null);
    }
}

