/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import com.informix.jdbc.IfxBSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.EnhancedBsonBinaryReader;
import org.bson.EnhancedBsonBinaryWriter;
import org.bson.Transformer;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.json.IfxJsonReader;

public class IfxDocumentCodec
extends DocumentCodec {
    private final Transformer valueTransformer;
    private final CodecRegistry registry;
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private static final String ID_FIELD_NAME = "_id";

    public IfxDocumentCodec(CodecRegistry registry) {
        this(registry, new BsonTypeClassMap());
    }

    public IfxDocumentCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap) {
        this(registry, bsonTypeClassMap, null);
    }

    public IfxDocumentCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        super(registry, bsonTypeClassMap, valueTransformer);
        this.registry = registry;
        this.bsonTypeCodecMap = new BsonTypeCodecMap((BsonTypeClassMap)Assertions.notNull((String)"bsonTypeClassMap", (Object)bsonTypeClassMap), registry);
        this.valueTransformer = valueTransformer != null ? valueTransformer : new Transformer(){

            public Object transform(Object value) {
                return value;
            }
        };
    }

    public void encode(BsonWriter writer, Document document, EncoderContext encoderContext) {
        this.writeMap(writer, (Map<String, Object>)document, encoderContext);
    }

    private void writeMap(BsonWriter writer, Map<String, Object> map, EncoderContext encoderContext) {
        writer.writeStartDocument();
        this.beforeFields(writer, encoderContext, map);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (this.skipField(encoderContext, entry.getKey())) continue;
            writer.writeName(entry.getKey());
            this.writeValue(writer, encoderContext, entry.getValue());
        }
        writer.writeEndDocument();
    }

    private boolean skipField(EncoderContext encoderContext, String key) {
        return encoderContext.isEncodingCollectibleDocument() && key.equals(ID_FIELD_NAME);
    }

    private void beforeFields(BsonWriter bsonWriter, EncoderContext encoderContext, Map<String, Object> document) {
        if (encoderContext.isEncodingCollectibleDocument() && document.containsKey(ID_FIELD_NAME)) {
            bsonWriter.writeName(ID_FIELD_NAME);
            this.writeValue(bsonWriter, encoderContext, document.get(ID_FIELD_NAME));
        }
    }

    private void writeValue(BsonWriter writer, EncoderContext encoderContext, Object value) {
        if (value == null) {
            writer.writeNull();
        } else if (value instanceof Iterable) {
            this.writeIterable(writer, (Iterable)value, encoderContext.getChildContext());
        } else if (value instanceof Map) {
            if (value instanceof IfxBSONObject && ((IfxBSONObject)value).isRawDocument() && writer instanceof EnhancedBsonBinaryWriter) {
                ((EnhancedBsonBinaryWriter)writer).doWriteDocumentAsBytes(((IfxBSONObject)value).getBytes());
            } else {
                this.writeMap(writer, (Map)value, encoderContext.getChildContext());
            }
        } else {
            Codec codec = this.registry.get(value.getClass());
            encoderContext.encodeWithChildContext((Encoder)codec, writer, value);
        }
    }

    private void writeIterable(BsonWriter writer, Iterable<Object> list, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (Object value : list) {
            this.writeValue(writer, encoderContext, value);
        }
        writer.writeEndArray();
    }

    public Document decode(BsonReader reader, DecoderContext decoderContext) {
        Document document = new Document();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            document.put(fieldName, this.readIfxValue(reader, decoderContext));
        }
        reader.readEndDocument();
        return document;
    }

    private Object readIfxValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.UNDEFINED && reader instanceof IfxJsonReader) {
            reader.readUndefined();
            return ((IfxJsonReader)reader).doGetValue();
        }
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        if (bsonType == BsonType.ARRAY) {
            return this.ifxReadList(reader, decoderContext);
        }
        if (bsonType == BsonType.BINARY && BsonBinarySubType.isUuid((byte)reader.peekBinarySubType()) && reader.peekBinarySize() == 16) {
            return this.registry.get(UUID.class).decode(reader, decoderContext);
        }
        if (bsonType == BsonType.DOCUMENT && reader instanceof EnhancedBsonBinaryReader) {
            return new IfxBSONObject(((EnhancedBsonBinaryReader)reader).getDocumentAsBytes());
        }
        return this.valueTransformer.transform(this.bsonTypeCodecMap.get(bsonType).decode(reader, decoderContext));
    }

    private List<Object> ifxReadList(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.add(this.readIfxValue(reader, decoderContext));
        }
        reader.readEndArray();
        return list;
    }
}

