/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RawCommonAccessor;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class RawAccessor
extends RawCommonAccessor {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    RawAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(stmt, stmt.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK ? Math.max(stmt.connection.maxRawBytesPlsql, max_len) : stmt.connection.maxRawLength, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, RawAccessor.class, $$$methodRef$$$1, null, stmt, max_len, form, external_type, forBind);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "representationMaxLength: " + this.representationMaxLength);
            }
            this.init(stmt, 23, 15, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, RawAccessor.class, $$$methodRef$$$1, null);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, RawAccessor.class, $$$methodRef$$$1, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, RawAccessor.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    RawAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(stmt, stmt.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK ? stmt.connection.maxRawBytesPlsql : stmt.connection.maxRawLength, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, RawAccessor.class, $$$methodRef$$$2, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.init(stmt, 23, 15, form, false);
            this.initForDescribe(23, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            int max_field_size = stmt.maxFieldSize;
            if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
                max_len = max_field_size;
            }
            this.initForDataAccess(0, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, RawAccessor.class, $$$methodRef$$$2, null);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RawAccessor.class, $$$methodRef$$$2, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RawAccessor.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void typeName;
            void max_len;
            void external_type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, RawAccessor.class, $$$methodRef$$$0, this, n2, n3, string);
            }
            super.initForDataAccess((int)external_type, (int)max_len, (String)typeName);
            this.byteLength += 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, RawAccessor.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, RawAccessor.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, RawAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$2 = RawAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = RawAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = RawAccessor.class.getDeclaredMethod("initForDataAccess", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

