/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleOCIConnectionPool;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
public abstract class OracleOCIConnection
extends T2CConnection {
    OracleOCIConnectionPool ociConnectionPool;
    boolean isPool;
    boolean aliasing;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    public OracleOCIConnection(String ur, @Blind(value=PropertiesBlinder.class) Properties info, Object ext) throws SQLException {
        this(ur, info, (OracleDriverExtension)ext);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$5, null, ur, TraceControllerImpl.blind(PropertiesBlinder.class, info), ext);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$5, null);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$5, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    OracleOCIConnection(String ur, @Blind(value=PropertiesBlinder.class) Properties info, OracleDriverExtension ext) throws SQLException {
        super(ur, info, ext);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$6, null, ur, TraceControllerImpl.blind(PropertiesBlinder.class, info), ext);
            }
            this.ociConnectionPool = null;
            this.isPool = false;
            this.aliasing = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getConnectionId() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] byArray;
            block20: {
                Monitor.CloseableLock lock;
                block21: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$0, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        byte[] connId = this.t2cGetConnectionId(this.m_nativeState);
                        if (connId == null) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 254, "Cannot create a ByteArray for the connectionId").fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$0, this, sQLException);
                            }
                            throw sQLException;
                        }
                        this.aliasing = true;
                        byArray = connId;
                        if (lock == null) break block20;
                        if (throwable == null) break block21;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$0, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$0, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                lock.close();
            }
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$0, this, byArray2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$0, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$0, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void passwordChange(String string, @Blind String string2, @Blind String string3) throws SQLException, IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$1, this, string, "*****", "*****");
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void newPassword;
                        void oldPassword;
                        void user;
                        this.ociPasswordChange((String)user, (String)oldPassword, (String)newPassword);
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$1, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$1, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$1, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void close() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            block25: {
                Throwable throwable;
                Monitor.CloseableLock lock;
                block26: {
                    block22: {
                        block23: {
                            block24: {
                                if (bl) {
                                    ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this, new Object[0]);
                                }
                                lock = this.acquireCloseableLock();
                                throwable = null;
                                if (this.lifecycle != 2 && this.lifecycle != 4 && !this.aliasing) break block22;
                                if (lock == null) break block23;
                                if (throwable == null) break block24;
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block23;
                            }
                            lock.close();
                        }
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this);
                            ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this, null);
                        }
                        return;
                    }
                    super.close();
                    this.ociConnectionPool.connectionClosed((oracle.jdbc.oci.OracleOCIConnection)this);
                    if (lock == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                lock.close();
                break block25;
                catch (Throwable throwable4) {
                    try {
                        throwable = throwable4;
                        Throwable throwable5 = throwable4;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this, throwable5);
                        }
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (lock != null) {
                            if (throwable != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                lock.close();
                            }
                        }
                        Throwable throwable8 = throwable6;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this, throwable8);
                        }
                        throw throwable8;
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable9 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this, throwable9);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setConnectionPool(OracleOCIConnectionPool oracleOCIConnectionPool) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$3, this, oracleOCIConnectionPool);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void cpool;
                        this.ociConnectionPool = cpool;
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$3, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$3, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$3, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl2) {
                        ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$4, this, n2, bl);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void clearMetaData;
                        void size;
                        super.setStmtCacheSize((int)size, (boolean)clearMetaData);
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$4, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$4, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$4, this, throwable8);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$6 = OracleOCIConnection.class.getDeclaredConstructor(String.class, Properties.class, OracleDriverExtension.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleOCIConnection.class.getDeclaredConstructor(String.class, Properties.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleOCIConnection.class.getDeclaredMethod("setStmtCacheSize", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleOCIConnection.class.getDeclaredMethod("setConnectionPool", OracleOCIConnectionPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleOCIConnection.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleOCIConnection.class.getDeclaredMethod("passwordChange", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleOCIConnection.class.getDeclaredMethod("getConnectionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

