/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Argument {
    public final String presentable;
    private final NodePattern syntaxCondition;

    public Argument(String presentable, NodePattern syntaxCondition) {
        this.presentable = presentable;
        this.syntaxCondition = syntaxCondition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && o.getClass() == this.getClass() && this.presentable.equals(((Argument)o).presentable);
    }

    public int hashCode() {
        return Objects.hash(this.presentable);
    }

    public String toString() {
        return this.presentable;
    }

    public boolean matchesFully(Node node) {
        return this.syntaxCondition.matches(node) && this.matchesLexically(node);
    }

    public boolean isObligatory() {
        return false;
    }

    @Nullable
    public Node findOn(@NotNull Node head) {
        return StreamEx.of(head.allDependents()).findFirst(this::matchesFully).orElse(null);
    }

    public boolean matchesLexically(Node node) {
        return true;
    }

    public StreamEx<Argument> destructure() {
        return StreamEx.of((Object)this);
    }

    public static Composite unite(String presentable, List<Argument> components) {
        return new Composite(presentable, components);
    }

    public static final class Composite
    extends Argument {
        public final List<Argument> components;

        private Composite(String presentable, List<Argument> components) {
            super(presentable, StreamEx.of(components).map(a -> a.syntaxCondition).reduce((cond1, cond2) -> NodePattern.or(cond1, cond2)).orElse(components.get((int)0).syntaxCondition));
            this.components = List.copyOf(components);
        }

        @Override
        @Nullable
        public Node findOn(@NotNull Node head) {
            return StreamEx.of(this.components).map(c -> c.findOn(head)).findFirst(Objects::nonNull).orElse(null);
        }

        @Override
        public boolean isObligatory() {
            return this.components.stream().allMatch(Argument::isObligatory);
        }

        @Override
        public boolean matchesLexically(Node node) {
            return this.components.stream().anyMatch(n -> n.matchesLexically(node));
        }

        @Override
        public StreamEx<Argument> destructure() {
            return (StreamEx)super.destructure().append((Stream)StreamEx.of(this.components).flatMap(Argument::destructure));
        }
    }
}

