/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.MonoSplineKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0011J \u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J \u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/compose/animation/core/MonoSpline;", "", "time", "", "y", "", "periodicBias", "", "<init>", "([F[[FF)V", "timePoints", "values", "[[F", "tangents", "slopeTemp", "makeFloatArray", "a", "", "b", "(II)[[F", "getPos", "t", "j", "", "v", "Landroidx/compose/animation/core/AnimationVector;", "index", "getSlope", "animation-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMonoSpline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonoSpline.kt\nandroidx/compose/animation/core/MonoSpline\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,303:1\n65#2,10:304\n65#2,10:314\n*S KotlinDebug\n*F\n+ 1 MonoSpline.kt\nandroidx/compose/animation/core/MonoSpline\n*L\n176#1:304,10\n244#1:314,10\n*E\n"})
public final class MonoSpline {
    @NotNull
    private final float[] timePoints;
    @NotNull
    private final float[][] values;
    @NotNull
    private final float[][] tangents;
    @NotNull
    private final float[] slopeTemp;
    public static final int $stable = 8;

    public MonoSpline(@NotNull float[] time, @NotNull float[][] y, float periodicBias) {
        int j;
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        int n = time.length;
        int dim = y[0].length;
        this.slopeTemp = new float[dim];
        float[][] slope = this.makeFloatArray(n - 1, dim);
        float[][] tangent = this.makeFloatArray(n, dim);
        for (j = 0; j < dim; ++j) {
            int n2 = n - 1;
            for (int i = 0; i < n2; ++i) {
                float dt = time[i + 1] - time[i];
                slope[i][j] = (y[i + 1][j] - y[i][j]) / dt;
                tangent[i][j] = i == 0 ? slope[i][j] : (slope[i - 1][j] + slope[i][j]) * 0.5f;
            }
            tangent[n - 1][j] = slope[n - 2][j];
        }
        if (!Float.isNaN(periodicBias)) {
            for (j = 0; j < dim; ++j) {
                float adjustedSlope;
                slope[0][j] = adjustedSlope = slope[n - 2][j] * (1.0f - periodicBias) + slope[0][j] * periodicBias;
                slope[n - 2][j] = adjustedSlope;
                tangent[n - 1][j] = adjustedSlope;
                tangent[0][j] = adjustedSlope;
            }
        }
        int n3 = n - 1;
        for (int i = 0; i < n3; ++i) {
            for (int j2 = 0; j2 < dim; ++j2) {
                if (slope[i][j2] == 0.0f) {
                    tangent[i][j2] = 0.0f;
                    tangent[i + 1][j2] = 0.0f;
                    continue;
                }
                float a = tangent[i][j2] / slope[i][j2];
                float b = tangent[i + 1][j2] / slope[i][j2];
                float h = (float)Math.hypot(a, b);
                if (!((double)h > 9.0)) continue;
                float t = 3.0f / h;
                tangent[i][j2] = t * a * slope[i][j2];
                tangent[i + 1][j2] = t * b * slope[i][j2];
            }
        }
        this.timePoints = time;
        this.values = y;
        this.tangents = tangent;
    }

    private final float[][] makeFloatArray(int a, int b) {
        int n = 0;
        float[][] fArrayArray = new float[a][];
        while (n < a) {
            int n2 = n++;
            fArrayArray[n2] = new float[b];
        }
        return fArrayArray;
    }

    public final float getPos(float t, int j) {
        float[][] values = this.values;
        float[][] tangents = this.tangents;
        int n = this.timePoints.length;
        int index2 = t <= this.timePoints[0] ? 0 : (t >= this.timePoints[n - 1] ? n - 1 : -1);
        if (index2 != -1) {
            return values[index2][j] + (t - this.timePoints[index2]) * this.getSlope(this.timePoints[index2], j);
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (t == this.timePoints[i]) {
                return values[i][j];
            }
            if (!(t < this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (t - this.timePoints[i]) / h;
            float y1 = values[i][j];
            float y2 = values[i + 1][j];
            float t1 = tangents[i][j];
            float t2 = tangents[i + 1][j];
            return MonoSplineKt.hermiteInterpolate(h, x, y1, y2, t1, t2);
        }
        return 0.0f;
    }

    public final void getPos(float time, @NotNull AnimationVector v, int index2) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int n = this.timePoints.length;
        int dim = this.values[0].length;
        int k = time <= this.timePoints[0] ? 0 : (time >= this.timePoints[n - 1] ? n - 1 : -1);
        if (k != -1) {
            this.getSlope(this.timePoints[k], this.slopeTemp);
            for (int j = 0; j < dim; ++j) {
                v.set$animation_core(j, this.values[k][j] + (time - this.timePoints[k]) * this.slopeTemp[j]);
            }
            return;
        }
        int n2 = n - 1;
        for (int i = index2; i < n2; ++i) {
            if (time == this.timePoints[i]) {
                for (int j = 0; j < dim; ++j) {
                    v.set$animation_core(j, this.values[i][j]);
                }
                return;
            }
            if (!(time < this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (time - this.timePoints[i]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = this.values[i][j];
                float y2 = this.values[i + 1][j];
                float t1 = this.tangents[i][j];
                float t2 = this.tangents[i + 1][j];
                v.set$animation_core(j, MonoSplineKt.hermiteInterpolate(h, x, y1, y2, t1, t2));
            }
            return;
        }
    }

    public static /* synthetic */ void getPos$default(MonoSpline monoSpline, float f, AnimationVector animationVector, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        monoSpline.getPos(f, animationVector, n);
    }

    /*
     * WARNING - void declaration
     */
    private final void getSlope(float time, float[] v) {
        void $this$fastCoerceAtMost$iv$iv;
        void $this$fastCoerceAtLeast$iv$iv;
        void minimumValue$iv;
        void $this$fastCoerceIn$iv;
        int dim = this.values[0].length;
        int n = this.timePoints.length;
        float f = time;
        float f2 = this.timePoints[0];
        float maximumValue$iv = this.timePoints[n - 1];
        boolean $i$f$fastCoerceIn = false;
        void var10_12 = $this$fastCoerceIn$iv;
        void minimumValue$iv$iv = minimumValue$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv;
        float maximumValue$iv$iv = maximumValue$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float t = $this$fastCoerceAtMost$iv$iv > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv;
        if (v.length < dim) {
            return;
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(t <= this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (t - this.timePoints[i]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = this.values[i][j];
                float y2 = this.values[i + 1][j];
                float t1 = this.tangents[i][j];
                float t2 = this.tangents[i + 1][j];
                v[j] = MonoSplineKt.hermiteDifferential(h, x, y1, y2, t1, t2) / h;
            }
            break;
        }
    }

    public final void getSlope(float time, @NotNull AnimationVector v, int index2) {
        int tangentIndex;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float[] timePoints = this.timePoints;
        float[][] values = this.values;
        float[][] tangents = this.tangents;
        int n = timePoints.length;
        int dim = values[0].length;
        int n2 = time <= timePoints[0] ? 0 : (tangentIndex = time >= timePoints[n - 1] ? n - 1 : -1);
        if (tangentIndex != -1) {
            float[] tangent = tangents[tangentIndex];
            if (tangent.length < dim) {
                return;
            }
            for (int j = 0; j < dim; ++j) {
                v.set$animation_core(j, tangent[j]);
            }
            return;
        }
        int n3 = n - 1;
        for (int i = index2; i < n3; ++i) {
            if (!(time <= timePoints[i + 1])) continue;
            float h = timePoints[i + 1] - timePoints[i];
            float x = (time - timePoints[i]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = values[i][j];
                float y2 = values[i + 1][j];
                float t1 = tangents[i][j];
                float t2 = tangents[i + 1][j];
                v.set$animation_core(j, MonoSplineKt.hermiteDifferential(h, x, y1, y2, t1, t2) / h);
            }
            break;
        }
    }

    public static /* synthetic */ void getSlope$default(MonoSpline monoSpline, float f, AnimationVector animationVector, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        monoSpline.getSlope(f, animationVector, n);
    }

    /*
     * WARNING - void declaration
     */
    private final float getSlope(float time, int j) {
        void $this$fastCoerceAtMost$iv$iv;
        void $this$fastCoerceAtLeast$iv$iv;
        void minimumValue$iv;
        void $this$fastCoerceIn$iv;
        float[] timePoints = this.timePoints;
        float[][] values = this.values;
        float[][] tangents = this.tangents;
        int n = timePoints.length;
        float f = time;
        float f2 = timePoints[0];
        float maximumValue$iv = timePoints[n - 1];
        boolean $i$f$fastCoerceIn = false;
        void var12_14 = $this$fastCoerceIn$iv;
        void minimumValue$iv$iv = minimumValue$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv;
        float maximumValue$iv$iv = maximumValue$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float t = $this$fastCoerceAtMost$iv$iv > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv;
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(t <= timePoints[i + 1])) continue;
            float y1 = values[i][j];
            float y2 = values[i + 1][j];
            float t1 = tangents[i][j];
            float t2 = tangents[i + 1][j];
            float h = timePoints[i + 1] - timePoints[i];
            float x = (t - timePoints[i]) / h;
            return MonoSplineKt.hermiteDifferential(h, x, y1, y2, t1, t2) / h;
        }
        return 0.0f;
    }
}

