/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.math.BigDecimal;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ImmutableSortJoinTransposeRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

@Value.Enclosing
public class SortJoinTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected SortJoinTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public SortJoinTransposeRule(Class<? extends Sort> sortClass, Class<? extends Join> joinClass) {
        this(Config.DEFAULT.withOperandFor(sortClass, joinClass).as(Config.class));
    }

    @Deprecated
    public SortJoinTransposeRule(Class<? extends Sort> sortClass, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withOperandFor(sortClass, joinClass).withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        Join join = (Join)call.rel(1);
        if (sort.offset instanceof RexDynamicParam || sort.fetch instanceof RexDynamicParam) {
            return false;
        }
        JoinRelType joinType = join.getJoinType();
        boolean isLeft = joinType == JoinRelType.LEFT;
        boolean isRight = joinType == JoinRelType.RIGHT;
        RelCollation collation = sort.getCollation();
        if (!isLeft && !isRight) {
            return false;
        }
        if (collation != RelCollations.EMPTY) {
            int leftFieldCnt = join.getLeft().getRowType().getFieldCount();
            for (RelFieldCollation fc : collation.getFieldCollations()) {
                int idx = fc.getFieldIndex();
                if (isLeft && idx >= leftFieldCnt) {
                    return false;
                }
                if (!isRight || idx >= leftFieldCnt) continue;
                return false;
            }
        } else if (sort.fetch == null) {
            return false;
        }
        return true;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode newRightInput;
        RelNode newLeftInput;
        Sort sort = (Sort)call.rel(0);
        Join join = (Join)call.rel(1);
        RelMetadataQuery mq = call.getMetadataQuery();
        RexNode newFetch = SortJoinTransposeRule.calculateInnerSortFetch(sort, call.builder().getRexBuilder());
        if (join.getJoinType() == JoinRelType.LEFT) {
            if (RelMdUtil.checkInputForCollationAndLimit(mq, join.getLeft(), sort.getCollation(), null, newFetch)) {
                return;
            }
            newLeftInput = sort.copy(sort.getTraitSet(), join.getLeft(), sort.getCollation(), null, newFetch);
            newRightInput = join.getRight();
        } else {
            RelCollation rightCollation = RelCollations.shift(sort.getCollation(), -join.getLeft().getRowType().getFieldCount());
            if (RelMdUtil.checkInputForCollationAndLimit(mq, join.getRight(), rightCollation, null, newFetch)) {
                return;
            }
            newLeftInput = join.getLeft();
            newRightInput = sort.copy(sort.getTraitSet().replace(rightCollation), join.getRight(), rightCollation, null, newFetch);
        }
        Join joinCopy = join.copy(join.getTraitSet(), join.getCondition(), newLeftInput, newRightInput, join.getJoinType(), join.isSemiJoinDone());
        Sort sortCopy = sort.copy(sort.getTraitSet(), joinCopy, sort.getCollation(), sort.offset, sort.fetch);
        call.transformTo(sortCopy);
    }

    private static @Nullable RexNode calculateInnerSortFetch(Sort sort, RexBuilder rexBuilder) {
        if (sort.fetch == null) {
            return null;
        }
        long outerFetch = RexLiteral.longValue(sort.fetch);
        long outerOffset = sort.offset != null ? RexLiteral.longValue(sort.offset) : 0L;
        long totalFetch = outerOffset + outerFetch;
        return rexBuilder.makeExactLiteral(BigDecimal.valueOf(totalFetch));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortJoinTransposeRule.Config.of().withOperandFor(LogicalSort.class, LogicalJoin.class);

        @Override
        default public SortJoinTransposeRule toRule() {
            return new SortJoinTransposeRule(this);
        }

        default public Config withOperandFor(Class<? extends Sort> sortClass, Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(sortClass).oneInput(b1 -> b1.operand(joinClass).anyInputs())).as(Config.class);
        }
    }
}

