/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.AuthenticationRecord;
import com.azure.identity.DeviceCodeCredential;
import com.azure.identity.DeviceCodeInfo;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.identity.implementation.util.IdentityUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class DeviceCodeCredentialBuilder
extends AadCredentialBuilderBase<DeviceCodeCredentialBuilder> {
    private Consumer<DeviceCodeInfo> challengeConsumer = deviceCodeInfo -> System.out.println(deviceCodeInfo.getMessage());
    private boolean automaticAuthentication = true;

    @Override
    public DeviceCodeCredentialBuilder clientId(String clientId) {
        return (DeviceCodeCredentialBuilder)super.clientId(clientId);
    }

    public DeviceCodeCredentialBuilder challengeConsumer(Consumer<DeviceCodeInfo> challengeConsumer) {
        this.challengeConsumer = challengeConsumer;
        return this;
    }

    public DeviceCodeCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    public DeviceCodeCredentialBuilder authenticationRecord(AuthenticationRecord authenticationRecord) {
        this.identityClientOptions.setAuthenticationRecord(authenticationRecord);
        return this;
    }

    public DeviceCodeCredentialBuilder disableAutomaticAuthentication() {
        this.automaticAuthentication = false;
        return this;
    }

    @Override
    public DeviceCodeCredentialBuilder additionallyAllowedTenants(String ... additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(additionallyAllowedTenants)));
        return this;
    }

    @Override
    public DeviceCodeCredentialBuilder additionallyAllowedTenants(List<String> additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(additionallyAllowedTenants));
        return this;
    }

    public DeviceCodeCredential build() {
        String clientId = this.clientId != null ? this.clientId : "04b07795-8ddb-461a-bbee-02f9e1bf7b46";
        return new DeviceCodeCredential(clientId, this.tenantId, this.challengeConsumer, this.automaticAuthentication, this.identityClientOptions);
    }
}

