/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import com.formdev.flatlaf.extras.components.FlatButton;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Taskbar;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mediathek.Main;
import mediathek.config.Config;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.Konstanten;
import mediathek.config.MVColor;
import mediathek.config.StandardLocations;
import mediathek.controller.history.SeenHistoryController;
import mediathek.controller.starter.Start;
import mediathek.daten.DatenDownload;
import mediathek.daten.IndexedFilmList;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.filmlisten.FilmeLaden;
import mediathek.filmlisten.reader.FilmListReader;
import mediathek.gui.MVTray;
import mediathek.gui.actions.CreateNewAboAction;
import mediathek.gui.actions.DeleteBookmarksAction;
import mediathek.gui.actions.DeleteLocalFilmlistAction;
import mediathek.gui.actions.EditBlacklistAction;
import mediathek.gui.actions.LoadFilmListAction;
import mediathek.gui.actions.ManageAboAction;
import mediathek.gui.actions.ManageBookmarkAction;
import mediathek.gui.actions.MemoryMonitorAction;
import mediathek.gui.actions.OptimizeHistoryDbAction;
import mediathek.gui.actions.QuitAction;
import mediathek.gui.actions.ResetFilterDialogPosition;
import mediathek.gui.actions.ResetSettingsAction;
import mediathek.gui.actions.SearchProgramUpdateAction;
import mediathek.gui.actions.SettingsAction;
import mediathek.gui.actions.ShowAboHistoryAction;
import mediathek.gui.actions.ShowAboutAction;
import mediathek.gui.actions.ShowBandwidthUsageAction;
import mediathek.gui.actions.ShowDuplicateStatisticsAction;
import mediathek.gui.actions.ShowFilmInformationAction;
import mediathek.gui.actions.ShowOnlineFaqAction;
import mediathek.gui.actions.ShowOnlineHelpAction;
import mediathek.gui.actions.ShowProgramInfosAction;
import mediathek.gui.actions.ToggleBlacklistAction;
import mediathek.gui.actions.ToggleDarkModeAction;
import mediathek.gui.actions.export.ExportDecompressedFilmlistAction;
import mediathek.gui.actions.export.ExportReadableFilmlistAction;
import mediathek.gui.actions.import_actions.ImportOldAbosAction;
import mediathek.gui.actions.import_actions.ImportOldBlacklistAction;
import mediathek.gui.actions.import_actions.ImportOldReplacementListAction;
import mediathek.gui.dialog.DialogBeenden;
import mediathek.gui.dialog.LoadFilmListDialog;
import mediathek.gui.dialogEinstellungen.DialogEinstellungen;
import mediathek.gui.duplicates.CommonStatsEvaluationTask;
import mediathek.gui.duplicates.FilmDuplicateEvaluationTask;
import mediathek.gui.duplicates.overview.FilmDuplicateOverviewDialog;
import mediathek.gui.filmInformation.FilmInfoDialog;
import mediathek.gui.history.ResetAboHistoryAction;
import mediathek.gui.history.ResetDownloadHistoryAction;
import mediathek.gui.messages.BaseEvent;
import mediathek.gui.messages.DownloadFinishedEvent;
import mediathek.gui.messages.DownloadStartEvent;
import mediathek.gui.messages.FilmListReadStartEvent;
import mediathek.gui.messages.FilmListReadStopEvent;
import mediathek.gui.messages.FilmListWriteStartEvent;
import mediathek.gui.messages.FilmListWriteStopEvent;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.gui.messages.NotificationCenterChangeEvent;
import mediathek.gui.messages.ShowSettingsDialogEvent;
import mediathek.gui.messages.TabVisualSettingsChangedEvent;
import mediathek.gui.messages.TableModelChangeEvent;
import mediathek.gui.messages.UpdateStateChangedEvent;
import mediathek.gui.tabs.tab_downloads.GuiDownloads;
import mediathek.gui.tabs.tab_film.GuiFilme;
import mediathek.gui.tabs.tab_livestreams.LivestreamPanel;
import mediathek.gui.tasks.BlacklistFilterWorker;
import mediathek.gui.tasks.LuceneIndexWorker;
import mediathek.gui.tasks.RefreshAboWorker;
import mediathek.mainwindow.AustrianVlcCheck;
import mediathek.mainwindow.FixedRedrawStatusBar;
import mediathek.mainwindow.FontManager;
import mediathek.mainwindow.ListSelectedItemsProperty;
import mediathek.mainwindow.Log4jShutdownHookThread;
import mediathek.mainwindow.MenuTabSwitchListener;
import mediathek.mainwindow.PositionSavingTabbedPane;
import mediathek.mainwindow.WindowLocationConfigSaverListener;
import mediathek.res.GetIcon;
import mediathek.swing.IconOnlyButton;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FilmListUpdateType;
import mediathek.tool.Filter;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MessageBus;
import mediathek.tool.RuntimeStatistics;
import mediathek.tool.TABS;
import mediathek.tool.UIProgressState;
import mediathek.tool.notification.GenericNotificationCenter;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.NullNotificationCenter;
import mediathek.tool.threads.IndicatorThread;
import mediathek.tool.timer.TimerPool;
import mediathek.update.AutomaticFilmlistUpdate;
import mediathek.update.ProgramUpdateCheck;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import raven.toast.Notifications;

public class MediathekGui
extends JFrame {
    protected static final Logger logger = LogManager.getLogger();
    private static final String ICON_NAME = "MediathekView.png";
    private static final String ICON_PATH = "/mediathek/res/";
    private static final int ICON_WIDTH = 58;
    private static final int ICON_HEIGHT = 58;
    private static final String KEY_F10 = "F10";
    private static final String NONE = "none";
    private static final int MIN_WINDOW_WIDTH = 800;
    private static final int MIN_WINDOW_HEIGHT = 600;
    private static final String ACTION_MAP_KEY_COPY_HQ_URL = "COPY_HQ_URL";
    private static final String ACTION_MAP_KEY_COPY_NORMAL_URL = "COPY_NORMAL_URL";
    private static final String TABBED_PANE_TRAILING_COMPONENT = "JTabbedPane.trailingComponent";
    private static MediathekGui ui;
    public final LoadFilmListAction loadFilmListAction;
    public final EditBlacklistAction editBlacklistAction = new EditBlacklistAction(this);
    public final ToggleBlacklistAction toggleBlacklistAction = new ToggleBlacklistAction();
    public final ShowFilmInformationAction showFilmInformationAction = new ShowFilmInformationAction();
    public final ListSelectedItemsProperty selectedListItemsProperty = new ListSelectedItemsProperty(0L);
    public final JLabel progressLabel = new JLabel();
    public final JProgressBar progressBar = new JProgressBar();
    protected final AtomicInteger numDownloadsStarted = new AtomicInteger(0);
    protected final Daten daten = Daten.getInstance();
    protected final PositionSavingTabbedPane tabbedPane = new PositionSavingTabbedPane();
    protected final JMenu jMenuHilfe = new JMenu();
    protected final SettingsAction settingsAction = new SettingsAction();
    protected final Configuration config = ApplicationConfiguration.getConfiguration();
    protected final JToolBar commonToolBar = new JToolBar();
    protected final ManageBookmarkAction manageBookmarkAction = new ManageBookmarkAction(this);
    protected final ToggleDarkModeAction toggleDarkModeAction = new ToggleDarkModeAction();
    final JMenu fontMenu = new JMenu("Schrift");
    private final JMenu jMenuDatei = new JMenu();
    private final JMenu jMenuFilme = new JMenu();
    private final JMenuBar jMenuBar = new JMenuBar();
    private final JMenu jMenuDownload = new JMenu();
    private final JMenu jMenuAbos = new JMenu();
    private final JMenu jMenuAnsicht = new JMenu();
    private final HashMap<JMenu, MenuTabSwitchListener> menuListeners = new HashMap();
    private final SearchProgramUpdateAction searchProgramUpdateAction;
    private final MemoryMonitorAction showMemoryMonitorAction = new MemoryMonitorAction(this);
    private final FilmInfoDialog filmInfo;
    private final ManageAboAction manageAboAction = new ManageAboAction();
    private final ShowBandwidthUsageAction showBandwidthUsageAction = new ShowBandwidthUsageAction(this);
    private final ShowDuplicateStatisticsAction showDuplicateStatisticsAction = new ShowDuplicateStatisticsAction(this);
    private final LivestreamPanel tabLivestreams = new LivestreamPanel();
    private final ToggleZappLivestreamsTabAction toggleZappLivestreamsTabAction = new ToggleZappLivestreamsTabAction(this, this.tabLivestreams);
    public FixedRedrawStatusBar swingStatusBar;
    public GuiFilme tabFilme;
    public GuiDownloads tabDownloads;
    protected FontManager fontManager;
    private MVTray tray;
    private DialogEinstellungen dialogEinstellungen;
    private ProgramUpdateCheck programUpdateChecker;
    private IndicatorThread progressIndicatorThread;
    private AutomaticFilmlistUpdate automaticFilmlistUpdate;
    private boolean shutdownRequested;

    public MediathekGui() {
        ui = this;
        this.setDefaultCloseOperation(0);
        this.setupScrollBarWidth();
        UIManager.put("TabbedPane.showTabSeparators", true);
        UIManager.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equalsIgnoreCase("lookAndFeel")) {
                SwingUtilities.updateComponentTreeUI(this.progressLabel);
                SwingUtilities.updateComponentTreeUI(this.progressBar);
            }
        });
        this.setupAlternatingRowColors();
        this.loadFilmListAction = new LoadFilmListAction(this);
        this.searchProgramUpdateAction = new SearchProgramUpdateAction();
        Main.splashScreen.ifPresent(s -> s.update(UIProgressState.LOAD_MAINWINDOW));
        this.getContentPane().setLayout(new BorderLayout());
        this.setIconAndWindowImage();
        this.createMenuBar();
        this.remapF10Key();
        Main.splashScreen.ifPresent(s -> s.update(UIProgressState.WAIT_FOR_HISTORY_DATA));
        try {
            this.daten.waitForHistoryDataLoadingToComplete();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("waitForHistoryDataLoadingToComplete()", (Throwable)e);
        }
        Main.splashScreen.ifPresent(s -> s.update(UIProgressState.CREATE_STATUS_BAR));
        this.createStatusBar();
        Main.splashScreen.ifPresent(s -> s.update(UIProgressState.SETUP_FILM_LISTENERS));
        this.setupFilmListListener();
        Main.splashScreen.ifPresent(s -> s.update(UIProgressState.LOAD_TABS));
        this.initTabs();
        Main.splashScreen.ifPresent(s -> s.update(UIProgressState.INIT_MENUS));
        this.initMenus();
        Main.splashScreen.ifPresent(s -> s.update(UIProgressState.LOAD_MEMORY_MONITOR));
        this.createMemoryMonitor();
        this.setupNotificationCenter();
        this.createCommonToolBar();
        this.installToolBar();
        Main.splashScreen.ifPresent(s -> s.update(UIProgressState.FINISHED));
        this.subscribeTableModelChangeEvent();
        SwingUtilities.invokeLater(() -> {
            if (Taskbar.isTaskbarSupported()) {
                this.setupTaskbarMenu();
            }
        });
        this.setupSystemTray();
        SwingUtilities.invokeLater(this::setApplicationWindowSize);
        this.loadFilmlist();
        this.setupUpdateCheck(this.config.getBoolean("application.automatic_update_check", true));
        this.setupShutdownHook();
        this.checkInvalidRegularExpressions();
        this.loadBandwidthMonitor();
        logger.trace("Loading info dialog");
        this.filmInfo = new FilmInfoDialog((Window)this);
        logger.trace("Finished loading info dialog");
        this.mapFilmUrlCopyCommands();
        if (Config.shouldDownloadAndQuit()) {
            ListenableFuture future = Daten.getInstance().getDecoratedPool().submit(() -> {
                try {
                    TimeUnit.SECONDS.sleep(10L);
                    logger.info("Auto DL and Quit: Updating filmlist...");
                    this.daten.getListeFilme().clear();
                    this.daten.getFilmeLaden().loadFilmlist("", false);
                    logger.info("Auto DL and Quit: Filmlist update done.");
                    logger.info("Auto DL and Quit: Loading Abos...");
                    this.daten.getListeAbo().setAboFuerFilm(this.daten.getListeFilme(), false);
                    logger.info("Auto DL and Quit: Loading Abos done.");
                    logger.info("Auto DL and Quit: Applying Blacklist...");
                    this.daten.getListeBlacklist().filterListe();
                    logger.info("Auto DL and Quit: Applying Blacklist...done.");
                    logger.info("Auto DL and Quit: Starting all downloads...");
                    SwingUtilities.invokeAndWait(() -> this.tabDownloads.starten(true));
                    return true;
                }
                catch (Exception e) {
                    logger.error("Auto DL and Quit: error starting downloads", (Throwable)e);
                    return false;
                }
            });
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Boolean>(this){
                final /* synthetic */ MediathekGui this$0;
                {
                    MediathekGui mediathekGui = this$0;
                    Objects.requireNonNull(mediathekGui);
                    this.this$0 = mediathekGui;
                }

                public void onSuccess(Boolean result2) {
                    try {
                        SwingUtilities.invokeAndWait(() -> this.this$0.quitApplication(true));
                    }
                    catch (Exception e) {
                        logger.error("Auto DL and Quit: Error in callback...", (Throwable)e);
                    }
                }

                public void onFailure(@NotNull Throwable t) {
                    logger.error("Auto DL and Quit: Error in callback...", t);
                }
            }, (Executor)Daten.getInstance().getDecoratedPool());
        }
        this.resetTabPlacement();
        Notifications.getInstance().setJFrame(this);
        this.performAustrianVlcCheck();
    }

    public static MediathekGui ui() {
        return ui;
    }

    protected void resetTabPlacement() {
        MessageBus.getMessageBus().publishAsync((Object)new TabVisualSettingsChangedEvent());
    }

    private void performAustrianVlcCheck() {
        if (!Config.shouldDownloadAndQuit()) {
            AustrianVlcCheck vlcCheck = new AustrianVlcCheck(this);
            vlcCheck.perform();
        }
    }

    private void loadBandwidthMonitor() {
        logger.trace("Loading bandwidth monitor");
        if (this.config.getBoolean("application.ui.bandwidth_monitor.visible", false)) {
            this.showBandwidthUsageAction.actionPerformed(null);
        }
        logger.trace("Finished loading bandwidth monitor");
    }

    private void subscribeTableModelChangeEvent() {
        MBassador<BaseEvent> messageBus = MessageBus.getMessageBus();
        messageBus.publishAsync((Object)new TableModelChangeEvent(true, false));
        messageBus.subscribe((Object)this);
    }

    private void mapFilmUrlCopyCommands() {
        InputMap im = this.jMenuBar.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(72, GuiFunktionen.getPlatformControlKey() | 0x40 | 0x200), ACTION_MAP_KEY_COPY_HQ_URL);
        im.put(KeyStroke.getKeyStroke(78, GuiFunktionen.getPlatformControlKey() | 0x40 | 0x200), ACTION_MAP_KEY_COPY_NORMAL_URL);
        ActionMap am = this.jMenuBar.getActionMap();
        am.put(ACTION_MAP_KEY_COPY_HQ_URL, this.tabFilme.copyHqUrlToClipboardAction);
        am.put(ACTION_MAP_KEY_COPY_NORMAL_URL, this.tabFilme.copyNormalUrlToClipboardAction);
    }

    protected void setupScrollBarWidth() {
        UIManager.put("ScrollBar.width", 16);
    }

    protected boolean useAlternateRowColors() {
        return true;
    }

    public void setupAlternatingRowColors() {
        if (this.useAlternateRowColors()) {
            UIManager.put("Table.alternateRowColor", MVColor.getAlternatingRowColor());
        }
    }

    protected void createDarkModeToggleButton() {
        this.commonToolBar.add(Box.createHorizontalGlue());
        this.commonToolBar.add(this.toggleDarkModeAction);
    }

    protected void createDarkModeMenuAction() {
        FlatButton actionButton = new FlatButton();
        actionButton.setButtonType(FlatButton.ButtonType.toolBarButton);
        actionButton.setFocusable(false);
        actionButton.setAction((Action)this.toggleDarkModeAction);
        actionButton.setSquareSize(true);
        this.jMenuBar.add(Box.createGlue());
        this.jMenuBar.add((Component)actionButton);
    }

    protected void setToolBarProperties() {
        this.commonToolBar.setFloatable(true);
        this.commonToolBar.setName("Allgemein");
    }

    protected void installToolBar() {
        this.tabbedPane.putClientProperty(TABBED_PANE_TRAILING_COMPONENT, this.commonToolBar);
        this.tabbedPane.putClientProperty("JTabbedPane.tabRotation", "auto");
    }

    protected void createToggleBlacklistButton() {
        boolean useIconWithText = ApplicationConfiguration.getConfiguration().getBoolean("toolbar.blacklist_icon.text", false);
        if (useIconWithText) {
            this.commonToolBar.add(new JButton(this.toggleBlacklistAction));
        } else {
            this.commonToolBar.add(new IconOnlyButton(this.toggleBlacklistAction));
        }
    }

    protected void createCommonToolBar() {
        this.commonToolBar.add(new IconOnlyButton(this.loadFilmListAction));
        this.commonToolBar.add(new IconOnlyButton(this.showFilmInformationAction));
        this.createToggleBlacklistButton();
        this.commonToolBar.addSeparator();
        this.commonToolBar.add(new IconOnlyButton(this.editBlacklistAction));
        this.commonToolBar.add(new IconOnlyButton(this.manageAboAction));
        this.commonToolBar.addSeparator();
        this.commonToolBar.add(new IconOnlyButton(this.settingsAction));
        this.createDarkModeToggleButton();
        this.setToolBarProperties();
    }

    private void checkInvalidRegularExpressions() {
        if (Filter.regExpErrorsOccured()) {
            String regexStr = Filter.regExpErrorList.stream().reduce("", (p, e) -> p + "\n" + e);
            Filter.regExpErrorList.clear();
            String message = String.format("<html>W\u00e4hrend des Starts wurden ung\u00fcltige regul\u00e4re Ausdr\u00fccke (RegExp) in Ihrer Blacklist und/oder Abos entdeckt.<br/><b>Sie m\u00fcssen diese korrigieren, ansonsten funktioniert das Programm nicht fehlerfrei!</b><br/><br/>Nachfolgende Ausdr\u00fccke sind fehlerbehaftet: <br/>%s</html>", regexStr);
            TimerPool.getTimerPool().schedule(() -> SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, message, "MediathekView", 0)), 15L, TimeUnit.SECONDS);
        }
    }

    private void setupNotificationCenter() {
        INotificationCenter notificationCenter = this.daten.notificationCenter();
        boolean showNotifications = this.config.getBoolean("application.notifications.show", true);
        if (notificationCenter != null) {
            try {
                notificationCenter.close();
            }
            catch (IOException e) {
                logger.error("Failed to close old notification center", (Throwable)e);
            }
        }
        if (!showNotifications) {
            this.daten.setNotificationCenter(new NullNotificationCenter());
        } else {
            this.daten.setNotificationCenter(this.getNotificationCenter());
        }
    }

    protected INotificationCenter getNotificationCenter() {
        return new GenericNotificationCenter();
    }

    @Handler
    protected void handleNotificationCenterChangeEvent(NotificationCenterChangeEvent e) {
        this.setupNotificationCenter();
    }

    protected void closeNotificationCenter() {
        try {
            INotificationCenter center = this.daten.notificationCenter();
            if (center != null) {
                center.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Log4jShutdownHookThread());
    }

    private void setupSystemTray() {
        SwingUtilities.invokeLater(() -> {
            this.initializeSystemTray();
            this.initWindowListenerForTray();
        });
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private void setupTaskbarMenu() {
        Taskbar taskbar = Taskbar.getTaskbar();
        if (taskbar.isSupported(Taskbar.Feature.MENU)) {
            PopupMenu popupMenu = taskbar.getMenu();
            if (popupMenu == null) {
                popupMenu = new PopupMenu();
            }
            popupMenu.addSeparator();
            popupMenu.add(new NoIconAwtMenuItem(this.loadFilmListAction));
            taskbar.setMenu(popupMenu);
        }
    }

    private void setIconAndWindowImage() {
        this.setWindowTitle();
        this.setIconImage(GetIcon.getIcon(ICON_NAME, ICON_PATH, 58, 58).getImage());
    }

    private void remapF10Key() {
        InputMap im = this.jMenuBar.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(KEY_F10), NONE);
    }

    protected void createMenuBar() {
        this.jMenuDatei.setMnemonic('d');
        this.jMenuDatei.setText("Datei");
        this.jMenuBar.add(this.jMenuDatei);
        this.jMenuFilme.setMnemonic('F');
        this.jMenuFilme.setText("Filme");
        this.jMenuBar.add(this.jMenuFilme);
        this.jMenuDownload.setMnemonic('O');
        this.jMenuDownload.setText("Downloads");
        this.jMenuBar.add(this.jMenuDownload);
        this.jMenuAbos.setMnemonic('b');
        this.jMenuAbos.setText("Abos");
        this.jMenuBar.add(this.jMenuAbos);
        this.addFontMenu();
        this.jMenuAnsicht.setMnemonic('a');
        this.jMenuAnsicht.setText("Ansicht");
        this.jMenuBar.add(this.jMenuAnsicht);
        this.jMenuHilfe.setMnemonic('h');
        this.jMenuHilfe.setText("Hilfe");
        this.jMenuBar.add(this.jMenuHilfe);
        this.setJMenuBar(this.jMenuBar);
    }

    protected void addFontMenu() {
        this.jMenuBar.add(this.fontMenu);
    }

    private void createMemoryMonitor() {
        boolean visible = ApplicationConfiguration.getConfiguration().getBoolean("memory_monitor.visible", false);
        if (visible && !SystemUtils.IS_OS_MAC_OSX) {
            this.showMemoryMonitorAction.showMemoryMonitor();
        }
    }

    private void loadFilmlist() {
        boolean writeCondition = GuiFunktionen.getFilmListUpdateType() != FilmListUpdateType.AUTOMATIC || !this.daten.getListeFilme().needsUpdate();
        Daten.dontWriteFilmlistOnStartup.set(writeCondition);
        this.swingStatusBar.add(this.progressLabel);
        this.swingStatusBar.add(this.progressBar);
        boolean evaluateDuplicates = ApplicationConfiguration.getConfiguration().getBoolean("film.evaluate_duplicates", true);
        CompletionStage worker = CompletableFuture.runAsync(() -> {
            logger.trace("Reading local filmlist");
            MessageBus.getMessageBus().publishAsync((Object)new FilmListReadStartEvent());
            try (FilmListReader reader = new FilmListReader();){
                int num_days = ApplicationConfiguration.getConfiguration().getInt("filmlist.load.days", 0);
                reader.readFilmListe(StandardLocations.getFilmlistFilePathString(), this.daten.getListeFilme(), num_days);
            }
            MessageBus.getMessageBus().publishAsync((Object)new FilmListReadStopEvent());
        }).thenRun(() -> {
            logger.trace("Check for filmlist updates");
            if (GuiFunktionen.getFilmListUpdateType() == FilmListUpdateType.AUTOMATIC && this.daten.getListeFilme().needsUpdate()) {
                this.daten.getFilmeLaden().loadFilmlist("", true);
            }
        });
        if (evaluateDuplicates) {
            worker = ((CompletableFuture)worker).thenRun(new FilmDuplicateEvaluationTask());
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)worker).thenRun(new CommonStatsEvaluationTask())).thenRun(new RefreshAboWorker(this.progressLabel, this.progressBar))).thenRun(new BlacklistFilterWorker(this.progressLabel, this.progressBar));
        if (this.daten.getListeFilmeNachBlackList() instanceof IndexedFilmList) {
            worker = ((CompletableFuture)worker).thenRun(new LuceneIndexWorker(this.progressLabel, this.progressBar));
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)worker).thenRun(() -> SwingUtilities.invokeLater(() -> Daten.getInstance().getFilmeLaden().notifyFertig(new ListenerFilmeLadenEvent("", "", 100, 100, false))))).thenRun(() -> Daten.dontWriteFilmlistOnStartup.set(false))).thenRun(() -> SwingUtilities.invokeLater(() -> {
            this.swingStatusBar.remove(this.progressBar);
            this.swingStatusBar.remove(this.progressLabel);
        }));
    }

    private void createStatusBar() {
        this.swingStatusBar = new FixedRedrawStatusBar(this);
        this.getContentPane().add((Component)((Object)this.swingStatusBar), "South");
        this.createFilmlistDownloadProgress();
    }

    private void createFilmlistDownloadProgress() {
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(this){
            final /* synthetic */ MediathekGui this$0;
            {
                MediathekGui mediathekGui = this$0;
                Objects.requireNonNull(mediathekGui);
                this.this$0 = mediathekGui;
            }

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                this.this$0.swingStatusBar.add(this.this$0.progressLabel);
                this.this$0.swingStatusBar.add(this.this$0.progressBar);
            }

            @Override
            public void progress(ListenerFilmeLadenEvent event) {
                if (event.max == 0 || event.progress == event.max) {
                    this.this$0.progressBar.setIndeterminate(true);
                } else {
                    this.this$0.progressBar.setIndeterminate(false);
                    this.this$0.progressBar.setMinimum(0);
                    this.this$0.progressBar.setMaximum(event.max);
                    this.this$0.progressBar.setValue(event.progress);
                }
                this.this$0.progressLabel.setText(event.text);
            }
        });
    }

    public FilmInfoDialog getFilmInfoDialog() {
        return this.filmInfo;
    }

    @Handler
    private void handleTabVisualSettingsChangedEvent(TabVisualSettingsChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.configureTabPlacement();
            this.configureTabIcons();
        });
    }

    private void setWindowTitle() {
        this.setTitle("MediathekView " + String.valueOf(Konstanten.MVVERSION));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSizeFromConfig() {
        try {
            this.config.lock(LockMode.READ);
            int width = this.config.getInt("application.ui.mainwindow.width", 800);
            int height = this.config.getInt("application.ui.mainwindow.height", 600);
            int x = this.config.getInt("application.ui.mainwindow.location.x");
            int y = this.config.getInt("application.ui.mainwindow.location.y");
            if (width < 800) {
                width = 800;
            }
            if (height < 600) {
                height = 600;
            }
            this.setBounds(x, y, width, height);
        }
        catch (NoSuchElementException e) {
            this.setExtendedState(6);
        }
        finally {
            this.config.unlock(LockMode.READ);
        }
    }

    private void setApplicationWindowSize() {
        if (Config.isStartMaximized() || ApplicationConfiguration.getConfiguration().getBoolean("application.ui.mainwindow.maximized", true)) {
            this.setExtendedState(6);
        } else {
            this.restoreSizeFromConfig();
        }
        SwingUtilities.invokeLater(() -> this.addComponentListener(new WindowLocationConfigSaverListener()));
    }

    private void setupFilmListListener() {
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(this){
            final /* synthetic */ MediathekGui this$0;
            {
                MediathekGui mediathekGui = this$0;
                Objects.requireNonNull(mediathekGui);
                this.this$0 = mediathekGui;
            }

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                this.this$0.loadFilmListAction.setEnabled(false);
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                this.this$0.loadFilmListAction.setEnabled(true);
                this.this$0.daten.allesSpeichern();
            }

            @Override
            public void fertigOnlyOne(ListenerFilmeLadenEvent event) {
                this.this$0.setupAutomaticFilmlistReload();
            }
        });
    }

    private void setupAutomaticFilmlistReload() {
        AutomaticFilmlistUpdate.IUpdateAction performUpdate = () -> {
            if (GuiFunktionen.getFilmListUpdateType() == FilmListUpdateType.AUTOMATIC) {
                this.loadFilmListAction.setEnabled(false);
                if (this.daten.getListeDownloads().unfinishedDownloads() == 0L) {
                    this.performFilmListLoadOperation(false);
                }
                this.loadFilmListAction.setEnabled(true);
            }
        };
        this.automaticFilmlistUpdate = new AutomaticFilmlistUpdate(performUpdate);
        this.automaticFilmlistUpdate.start();
    }

    protected void initWindowListenerForTray() {
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ MediathekGui this$0;
            {
                MediathekGui mediathekGui = this$0;
                Objects.requireNonNull(mediathekGui);
                this.this$0 = mediathekGui;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                if (this.this$0.tray != null && this.this$0.config.getBoolean("application.ui.tray.use", false)) {
                    this.this$0.setVisible(false);
                } else {
                    this.this$0.quitApplication();
                }
            }
        });
    }

    @Handler
    private void handleUpdateStateChanged(UpdateStateChangedEvent e) {
        SwingUtilities.invokeLater(() -> this.setupUpdateCheck(e.isActive()));
    }

    private void setupUpdateCheck(boolean newState) {
        if (newState) {
            this.programUpdateChecker = new ProgramUpdateCheck();
            this.programUpdateChecker.start();
        } else {
            this.endProgramUpdateChecker();
        }
    }

    private void endProgramUpdateChecker() {
        if (this.programUpdateChecker != null) {
            this.programUpdateChecker.close();
            this.programUpdateChecker = null;
        }
    }

    public void initializeSystemTray() {
        boolean useTray = this.config.getBoolean("application.ui.tray.use", false);
        if (this.tray == null && useTray) {
            this.tray = new MVTray().systemTray();
        } else if (this.tray != null && !useTray) {
            this.tray.beenden();
            this.tray = null;
        }
    }

    protected JPanel createTabFilme(@NotNull Daten daten) {
        return new GuiFilme(daten, this);
    }

    protected JPanel createTabDownloads(@NotNull Daten daten) {
        return new GuiDownloads(daten, this);
    }

    private void initTabs() {
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.tabbedPane, "Center");
        Main.splashScreen.ifPresent(s -> s.update(UIProgressState.LOAD_DOWNLOAD_TAB));
        this.tabDownloads = (GuiDownloads)this.createTabDownloads(this.daten);
        Main.splashScreen.ifPresent(s -> s.update(UIProgressState.LOAD_FILM_TAB));
        this.tabFilme = (GuiFilme)this.createTabFilme(this.daten);
        Main.splashScreen.ifPresent(s -> s.update(UIProgressState.ADD_TABS_TO_UI));
        this.tabbedPane.addTab("Filme", this.tabFilme);
        this.tabbedPane.addTab("Downloads", this.tabDownloads);
        this.installLivestreamsTab();
        if (ApplicationConfiguration.getConfiguration().getBoolean("application.ui.restore_selected_tab", false)) {
            this.tabbedPane.restoreSavedTabPosition();
        }
        this.tabbedPane.installChangeListener();
        Main.splashScreen.ifPresent(s -> s.update(UIProgressState.CONFIGURE_TABS));
        this.configureTabPlacement();
        this.configureTabIcons();
    }

    protected void installLivestreamsTab() {
        boolean show = ApplicationConfiguration.getConfiguration().getBoolean("application.ui.zapp.show", true);
        this.tabLivestreams.putClientProperty("JTabbedPane.tabClosable", true);
        this.tabLivestreams.putClientProperty("JTabbedPane.tabCloseCallback", n -> this.toggleZappLivestreamsTabAction.actionPerformed(null));
        if (show) {
            this.tabbedPane.addTab("zapp Livestreams", this.tabLivestreams);
        }
    }

    public void enableUpdateMenuItem(boolean enable) {
        this.searchProgramUpdateAction.setEnabled(enable);
    }

    protected void configureTabPlacement() {
        boolean topPosition = this.config.getBoolean("application.ui.tab_position.top", true);
        if (topPosition) {
            this.tabbedPane.setTabPlacement(1);
            this.getContentPane().remove(this.commonToolBar);
            this.tabbedPane.putClientProperty(TABBED_PANE_TRAILING_COMPONENT, this.commonToolBar);
        } else {
            this.tabbedPane.setTabPlacement(2);
            this.tabbedPane.putClientProperty(TABBED_PANE_TRAILING_COMPONENT, null);
            this.getContentPane().add((Component)this.commonToolBar, "First");
        }
    }

    private void configureTabIcons() {
        boolean icon = this.config.getBoolean("application.ui.mainwindow.tab_icons", false);
        if (!icon) {
            this.setTabIcon(this.tabFilme, null);
            this.setTabIcon(this.tabDownloads, null);
        } else {
            this.setTabIcon(this.tabFilme, Icons.ICON_TAB_FILM);
            this.setTabIcon(this.tabDownloads, Icons.ICON_TAB_DOWNLOAD);
        }
    }

    private void setTabIcon(Component tab, Icon icon) {
        int index = this.tabbedPane.indexOfComponent(tab);
        this.tabbedPane.setIconAt(index, icon);
    }

    protected IndicatorThread createProgressIndicatorThread() throws Exception {
        throw new Exception("Unsupported Platform");
    }

    @Handler
    protected void handleDownloadStart(DownloadStartEvent msg) {
        this.numDownloadsStarted.incrementAndGet();
        if (this.progressIndicatorThread == null) {
            try {
                this.progressIndicatorThread = this.createProgressIndicatorThread();
                this.progressIndicatorThread.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Handler
    protected void handleDownloadFinishedEvent(DownloadFinishedEvent msg) {
        int numDL = this.numDownloadsStarted.decrementAndGet();
        if (numDL == 0 && this.progressIndicatorThread != null) {
            this.progressIndicatorThread.interrupt();
            this.progressIndicatorThread = null;
        }
    }

    @Handler
    private void handleShowSettingsDialogEvent(ShowSettingsDialogEvent evt) {
        SwingUtilities.invokeLater(() -> {
            this.getSettingsDialog().setVisible(true);
            if (!SystemUtils.IS_OS_LINUX) {
                this.getSettingsDialog().toFront();
            }
        });
    }

    protected void installMenuTabSwitchListener() {
        this.menuListeners.put(this.jMenuFilme, new MenuTabSwitchListener(this, TABS.TAB_FILME));
        this.menuListeners.put(this.jMenuDownload, new MenuTabSwitchListener(this, TABS.TAB_DOWNLOADS));
        if (this.config.getBoolean("application.ui.install_tab_listeners", true)) {
            this.jMenuFilme.addMenuListener(this.menuListeners.get(this.jMenuFilme));
            this.jMenuDownload.addMenuListener(this.menuListeners.get(this.jMenuDownload));
        }
    }

    @Handler
    protected void handleInstallTabSwitchListenerEvent(InstallTabSwitchListenerEvent msg) {
        switch (msg.event) {
            case INSTALL: {
                SwingUtilities.invokeLater(() -> {
                    this.jMenuFilme.addMenuListener(this.menuListeners.get(this.jMenuFilme));
                    this.jMenuDownload.addMenuListener(this.menuListeners.get(this.jMenuDownload));
                });
                break;
            }
            case REMOVE: {
                SwingUtilities.invokeLater(() -> {
                    this.jMenuFilme.removeMenuListener(this.menuListeners.get(this.jMenuFilme));
                    this.jMenuDownload.removeMenuListener(this.menuListeners.get(this.jMenuDownload));
                });
            }
        }
    }

    private void createFileMenu() {
        this.jMenuDatei.add(this.loadFilmListAction);
        this.jMenuDatei.addSeparator();
        JMenu exportMenu = new JMenu("Export");
        exportMenu.add(new ExportReadableFilmlistAction());
        exportMenu.add(new ExportDecompressedFilmlistAction());
        JMenu importMenu = new JMenu("Import");
        importMenu.add(new ImportOldAbosAction());
        importMenu.add(new ImportOldBlacklistAction());
        importMenu.add(new ImportOldReplacementListAction());
        this.jMenuDatei.add(exportMenu);
        this.jMenuDatei.add(importMenu);
        this.addSettingsMenuItem();
        this.addQuitMenuItem();
    }

    protected void addSettingsMenuItem() {
        this.jMenuDatei.addSeparator();
        this.jMenuDatei.add(this.settingsAction);
    }

    protected void addQuitMenuItem() {
        this.jMenuDatei.addSeparator();
        this.jMenuDatei.add(new QuitAction(this));
    }

    private void createViewMenu() {
        this.tabFilme.installViewMenuEntry(this.jMenuAnsicht);
        this.jMenuAnsicht.add(this.toggleZappLivestreamsTabAction);
        this.jMenuAnsicht.addSeparator();
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.jMenuAnsicht.add(this.showMemoryMonitorAction);
        } else if (Config.isDebugModeEnabled()) {
            this.jMenuAnsicht.add(this.showMemoryMonitorAction);
        }
        this.jMenuAnsicht.add(this.showBandwidthUsageAction);
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(this.showDuplicateStatisticsAction);
        JMenuItem mi = new JMenuItem("\u00dcbersicht aller Duplikate anzeigen...");
        mi.addActionListener(actionEvent -> {
            FilmDuplicateOverviewDialog dlg = new FilmDuplicateOverviewDialog((Window)this);
            dlg.setVisible(true);
        });
        this.jMenuAnsicht.add(mi);
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(this.tabFilme.toggleFilterDialogVisibilityAction);
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(this.showFilmInformationAction);
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(this.manageBookmarkAction);
    }

    protected void createFontMenu() {
        this.fontManager = new FontManager(this.fontMenu);
        this.fontManager.restoreConfigData();
    }

    @Handler
    private void handleFilmlistWriteStartEvent(FilmListWriteStartEvent e) {
        SwingUtilities.invokeLater(() -> this.loadFilmListAction.setEnabled(false));
    }

    @Handler
    private void handleFilmlistWriteStopEvent(FilmListWriteStopEvent e) {
        SwingUtilities.invokeLater(() -> this.loadFilmListAction.setEnabled(true));
    }

    private void createHelperToolsEntries() {
        JMenu menu = new JMenu("Hilfsmittel");
        menu.add(new OptimizeHistoryDbAction(this));
        this.jMenuHilfe.add(menu);
    }

    private void createHelpMenu() {
        this.jMenuHilfe.add(new ShowOnlineHelpAction());
        this.jMenuHilfe.add(new ShowOnlineFaqAction(this));
        this.jMenuHilfe.addSeparator();
        this.jMenuHilfe.add(new ResetSettingsAction(this, this.daten));
        this.jMenuHilfe.add(new ResetDownloadHistoryAction(this));
        this.jMenuHilfe.add(new ResetAboHistoryAction(this));
        this.jMenuHilfe.addSeparator();
        this.jMenuHilfe.add(new DeleteLocalFilmlistAction(this));
        this.jMenuHilfe.add(new DeleteBookmarksAction(this));
        this.jMenuHilfe.addSeparator();
        this.jMenuHilfe.add(new ResetFilterDialogPosition(this));
        this.jMenuHilfe.addSeparator();
        this.createHelperToolsEntries();
        this.jMenuHilfe.addSeparator();
        if (GuiFunktionen.isNotUsingExternalUpdater()) {
            this.jMenuHilfe.add(this.searchProgramUpdateAction);
        }
        this.jMenuHilfe.add(new ShowProgramInfosAction());
        this.installAdditionalHelpEntries();
    }

    protected void installAdditionalHelpEntries() {
        this.jMenuHilfe.addSeparator();
        this.jMenuHilfe.add(new ShowAboutAction());
    }

    protected void initMenus() {
        this.installMenuTabSwitchListener();
        this.createFileMenu();
        this.tabFilme.installMenuEntries(this.jMenuFilme);
        this.tabDownloads.installMenuEntries(this.jMenuDownload);
        this.createFontMenu();
        this.createViewMenu();
        this.createAboMenu();
        if (Config.isDebugModeEnabled()) {
            this.createDeveloperMenu();
        }
        this.createHelpMenu();
    }

    private void createDeveloperMenu() {
        JMenu devMenu = new JMenu("Entwickler");
        JMenuItem miGc = new JMenuItem("GC ausf\u00fchren");
        miGc.addActionListener(actionEvent -> System.gc());
        devMenu.add(miGc);
        int idx = this.jMenuBar.getComponentIndex(this.jMenuAnsicht);
        this.jMenuBar.add((Component)devMenu, ++idx);
    }

    private void createAboMenu() {
        this.jMenuAbos.add(new CreateNewAboAction(this.daten.getListeAbo()));
        this.jMenuAbos.add(new ShowAboHistoryAction(MediathekGui.ui()));
        this.jMenuAbos.addSeparator();
        this.jMenuAbos.add(this.manageAboAction);
    }

    public void performFilmListLoadOperation(boolean manualMode) {
        if (manualMode || GuiFunktionen.getFilmListUpdateType() == FilmListUpdateType.MANUAL) {
            LoadFilmListDialog dlg = new LoadFilmListDialog(this);
            dlg.setVisible(true);
        } else {
            FilmeLaden filmeLaden = new FilmeLaden(this.daten);
            filmeLaden.loadFilmlist("", false);
        }
    }

    public DialogEinstellungen getSettingsDialog() {
        if (this.dialogEinstellungen == null) {
            this.dialogEinstellungen = new DialogEinstellungen();
        }
        return this.dialogEinstellungen;
    }

    public boolean isShutdownRequested() {
        return this.shutdownRequested;
    }

    public void setShutdownRequested(boolean shutdownRequested) {
        this.shutdownRequested = shutdownRequested;
    }

    public boolean quitApplication() {
        return this.quitApplication(false);
    }

    public boolean quitApplication(boolean shouldDownloadAndQuit) {
        if (this.daten.getListeDownloads().unfinishedDownloads() > 0L) {
            DialogBeenden dialogBeenden = new DialogBeenden(this, shouldDownloadAndQuit);
            dialogBeenden.setVisible(true);
            if (!dialogBeenden.getApplicationCanTerminate()) {
                return false;
            }
            this.setShutdownRequested(dialogBeenden.isShutdownRequested());
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.automaticFilmlistUpdate != null) {
            this.automaticFilmlistUpdate.close();
        }
        this.endProgramUpdateChecker();
        this.showMemoryMonitorAction.closeMemoryMonitor();
        this.showBandwidthUsageAction.getDialogOptional().ifPresent(dlg -> {
            dlg.dispose();
            this.config.setProperty("application.ui.bandwidth_monitor.visible", (Object)true);
        });
        this.manageAboAction.closeDialog();
        logger.trace("Perform history maintenance.");
        try (SeenHistoryController history = new SeenHistoryController();){
            history.performMaintenance();
        }
        logger.trace("Save bookmark list.");
        this.daten.getListeBookmarkList().saveToFile();
        logger.trace("Stop Starter Thread.");
        this.daten.getStarterClass().getStarterThread().interrupt();
        logger.trace("Close Notification center.");
        this.closeNotificationCenter();
        logger.trace("Save Tab Filme data.");
        this.tabFilme.tabelleSpeichern();
        this.tabFilme.swingFilterDialog.dispose();
        logger.trace("Save Tab Download data.");
        this.tabDownloads.tabelleSpeichern();
        logger.trace("Stop all downloads.");
        this.stopDownloads();
        logger.trace("Save app data.");
        this.daten.allesSpeichern();
        logger.trace("Shutdown pools.");
        this.shutdownTimerPool();
        this.waitForCommonPoolToComplete();
        logger.trace("Close main window.");
        this.dispose();
        logger.trace("Write bookmarks");
        this.daten.getListeBookmarkList().saveToFile();
        logger.trace("Write app config.");
        ApplicationConfiguration.getInstance().writeConfiguration();
        RuntimeStatistics.printRuntimeStatistics();
        if (Config.isEnhancedLoggingEnabled()) {
            RuntimeStatistics.printDataUsageStatistics();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.isShutdownRequested()) {
            logger.info("Requesting computer shutdown.");
            this.shutdownComputer();
        }
        System.exit(0);
        return true;
    }

    private void shutdownTimerPool() {
        logger.trace("Entering shutdownTimerPool()");
        ScheduledExecutorService timerPool = TimerPool.getTimerPool();
        try {
            TimerPool.getRepeatingTimerFuture().cancel(true);
            timerPool.shutdown();
            if (!timerPool.awaitTermination(500L, TimeUnit.MILLISECONDS) && Config.isDebugModeEnabled()) {
                logger.warn("Time out occured before pool final termination");
            }
        }
        catch (InterruptedException e) {
            logger.error("timerPool shutdown exception", (Throwable)e);
        }
        List<Runnable> taskList = timerPool.shutdownNow();
        if (Config.isDebugModeEnabled() && !taskList.isEmpty()) {
            logger.trace("timerPool taskList was not empty: {}", (Object)taskList.toString());
        }
        logger.trace("Leaving shutdownTimerPool()");
    }

    private void stopDownloads() {
        if (this.daten.getListeDownloads() != null) {
            for (DatenDownload download : this.daten.getListeDownloads()) {
                Start s = download.start;
                if (s == null) continue;
                s.stoppen = true;
            }
        }
    }

    private void waitForCommonPoolToComplete() {
        logger.trace("Entering waitForCommonPoolToComplete()");
        ForkJoinPool pool = ForkJoinPool.commonPool();
        boolean isQuiescent = pool.isQuiescent();
        while (pool.hasQueuedSubmissions() && !isQuiescent) {
            logger.trace("POOL SUBMISSIONS: {}", (Object)pool.getQueuedSubmissionCount());
            isQuiescent = pool.awaitQuiescence(500L, TimeUnit.MILLISECONDS);
        }
        logger.trace("Leaving waitForCommonPoolToComplete()");
    }

    protected void shutdownComputer() {
    }

    public class ToggleZappLivestreamsTabAction
    extends AbstractAction {
        private final LivestreamPanel livestreamPanel;
        private static final String TAB_TITLE = "Zapp Livestream Tab ein-/ausblenden";
        final /* synthetic */ MediathekGui this$0;

        public ToggleZappLivestreamsTabAction(MediathekGui this$0, LivestreamPanel livestreamPanel) {
            MediathekGui mediathekGui = this$0;
            Objects.requireNonNull(mediathekGui);
            this.this$0 = mediathekGui;
            this.livestreamPanel = livestreamPanel;
            this.putValue("Name", TAB_TITLE);
        }

        private void toggleTab() {
            int tabIndex = this.this$0.tabbedPane.indexOfComponent(this.livestreamPanel);
            if (tabIndex == -1) {
                this.this$0.tabbedPane.add("Zapp Livestreams", this.livestreamPanel);
                ApplicationConfiguration.getConfiguration().setProperty("application.ui.zapp.show", (Object)true);
            } else {
                this.this$0.tabbedPane.remove(tabIndex);
                ApplicationConfiguration.getConfiguration().setProperty("application.ui.zapp.show", (Object)false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.toggleTab();
        }
    }

    static class NoIconAwtMenuItem
    extends MenuItem {
        public NoIconAwtMenuItem(@NotNull Action action) {
            super((String)action.getValue("Name"));
            this.addActionListener(action);
        }
    }
}

