/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import jakarta.transaction.Synchronization;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.infinispan.quarkus.hibernate.cache.InternalCache;
import org.infinispan.quarkus.hibernate.cache.InternalDataAccess;
import org.infinispan.quarkus.hibernate.cache.InternalRegion;
import org.infinispan.quarkus.hibernate.cache.PutFromLoadValidator;
import org.jboss.logging.Logger;

final class StrictDataAccess
implements InternalDataAccess {
    private static final Logger log = Logger.getLogger(StrictDataAccess.class);
    private static final boolean trace = log.isTraceEnabled();
    private final InternalCache cache;
    private final PutFromLoadValidator putValidator;
    private final InternalRegion internalRegion;

    StrictDataAccess(InternalCache cache, PutFromLoadValidator putValidator, InternalRegion internalRegion) {
        this.cache = cache;
        this.putValidator = putValidator;
        this.internalRegion = internalRegion;
    }

    @Override
    public Object get(Object session, Object key, long txTimestamp) {
        if (!this.internalRegion.checkValid()) {
            if (trace) {
                log.tracef("Region %s not valid", (Object)this.internalRegion.getName());
            }
            return null;
        }
        Object val = this.cache.getOrNull(key);
        if (val == null && session != null) {
            this.putValidator.registerPendingPut(session, key, txTimestamp);
        }
        return val;
    }

    @Override
    public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version) {
        return this.putFromLoad(session, key, value, txTimestamp, version, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        if (!this.internalRegion.checkValid()) {
            if (trace) {
                log.tracef("Region %s not valid", (Object)this.internalRegion.getName());
            }
            return false;
        }
        if (minimalPutOverride && this.cache.getOrNull(key) != null) {
            return false;
        }
        PutFromLoadValidator.Lock lock = this.putValidator.acquirePutFromLoadLock(session, key, txTimestamp);
        if (lock == null) {
            if (trace) {
                log.tracef("Put from load lock not acquired for key %s", key);
            }
            return false;
        }
        try {
            this.cache.putIfAbsent(key, value);
        }
        finally {
            this.putValidator.releasePutFromLoadLock(key, lock);
        }
        return true;
    }

    @Override
    public boolean insert(Object session, Object key, Object value, Object version) {
        if (!this.internalRegion.checkValid()) {
            return false;
        }
        this.write(session, key, value);
        return true;
    }

    @Override
    public boolean update(Object session, Object key, Object value, Object currentVersion, Object previousVersion) {
        this.write(session, key, value);
        return true;
    }

    @Override
    public void remove(Object session, Object key) {
        this.write(session, key, null);
    }

    @Override
    public void removeAll() {
        try {
            if (!this.putValidator.beginInvalidatingRegion()) {
                log.error((Object)("Failed to invalidate pending putFromLoad calls for region " + this.internalRegion.getName()));
            }
            this.cache.invalidateAll();
        }
        finally {
            this.putValidator.endInvalidatingRegion();
        }
    }

    @Override
    public void evict(Object key) {
        this.cache.invalidate(key);
    }

    @Override
    public void evictAll() {
        try {
            if (!this.putValidator.beginInvalidatingRegion()) {
                log.error((Object)("Failed to invalidate pending putFromLoad calls for region " + this.internalRegion.getName()));
            }
            this.internalRegion.clear();
        }
        finally {
            this.putValidator.endInvalidatingRegion();
        }
    }

    @Override
    public boolean afterInsert(Object session, Object key, Object value, Object version) {
        return false;
    }

    @Override
    public boolean afterUpdate(Object session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        return false;
    }

    private void write(Object session, Object key, Object value) {
        Object lockOwner = new Object();
        this.registerLocalInvalidation(session, lockOwner, key);
        if (!this.putValidator.beginInvalidatingWithPFER(lockOwner, key, value)) {
            throw new CacheException(String.format("Failed to invalidate pending putFromLoad calls for key %s from region %s", key, this.internalRegion.getName()));
        }
        this.cache.invalidate(key);
    }

    private void registerLocalInvalidation(Object session, Object lockOwner, Object key) {
        TransactionCoordinator transactionCoordinator = ((SharedSessionContractImplementor)session).getTransactionCoordinator();
        if (transactionCoordinator == null) {
            return;
        }
        if (trace) {
            log.tracef("Registering synchronization on transaction in %s, cache %s: %s", lockOwner, (Object)this.internalRegion.getName(), key);
        }
        transactionCoordinator.getLocalSynchronizations().registerSynchronization((Synchronization)new LocalInvalidationSynchronization(this.putValidator, key, lockOwner));
    }

    private static final class LocalInvalidationSynchronization
    implements Synchronization {
        private static final Logger log = Logger.getLogger(LocalInvalidationSynchronization.class);
        private static final boolean trace = log.isTraceEnabled();
        private final Object lockOwner;
        private final PutFromLoadValidator validator;
        private final Object key;

        public LocalInvalidationSynchronization(PutFromLoadValidator validator, Object key, Object lockOwner) {
            assert (lockOwner != null);
            this.validator = validator;
            this.key = key;
            this.lockOwner = lockOwner;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (trace) {
                log.tracef("After completion callback with status %d", status);
            }
            this.validator.endInvalidatingKey(this.lockOwner, this.key, status == 3 || status == 8);
        }
    }
}

