/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.JoinColumn;
import java.util.List;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMapping;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDiscriminatorMapping;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.AnyAnnotation;
import org.hibernate.boot.models.annotations.internal.AnyDiscriminatorAnnotation;
import org.hibernate.boot.models.annotations.internal.AnyDiscriminatorValueAnnotation;
import org.hibernate.boot.models.annotations.internal.AnyDiscriminatorValuesAnnotation;
import org.hibernate.boot.models.annotations.internal.AnyKeTypeAnnotation;
import org.hibernate.boot.models.annotations.internal.AnyKeyJavaClassAnnotation;
import org.hibernate.boot.models.annotations.internal.ColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.JoinColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.JoinColumnsJpaAnnotation;
import org.hibernate.boot.models.xml.internal.SimpleTypeInterpretation;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class AnyMappingAttributeProcessing {
    public static MutableMemberDetails processAnyMappingAttribute(JaxbAnyMappingImpl jaxbHbmAnyMapping, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbHbmAnyMapping.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbHbmAnyMapping.getName(), accessType, declarer);
        AnyAnnotation anyAnn = (AnyAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.ANY, xmlDocumentContext.getModelBuildingContext());
        CommonAttributeProcessing.applyAccess(accessType, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeAccessor(jaxbHbmAnyMapping, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyFetching(jaxbHbmAnyMapping, memberDetails, anyAnn, xmlDocumentContext);
        CommonAttributeProcessing.applyOptionality(jaxbHbmAnyMapping, anyAnn, xmlDocumentContext);
        CommonAttributeProcessing.applyOptimisticLock(jaxbHbmAnyMapping, memberDetails, xmlDocumentContext);
        AnyMappingAttributeProcessing.applyDiscriminator(memberDetails, jaxbHbmAnyMapping, xmlDocumentContext);
        AnyMappingAttributeProcessing.applyKey(memberDetails, jaxbHbmAnyMapping, xmlDocumentContext);
        XmlAnnotationHelper.applyCascading(jaxbHbmAnyMapping.getCascade(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }

    static void applyDiscriminator(MutableMemberDetails memberDetails, JaxbAnyMapping jaxbHbmAnyMapping, XmlDocumentContext xmlDocumentContext) {
        List<? extends JaxbDiscriminatorMapping> jaxbValueMappings;
        JaxbAnyMapping.Discriminator jaxbDiscriminator = jaxbHbmAnyMapping.getDiscriminator();
        AnyDiscriminatorAnnotation anyDiscriminatorAnn = (AnyDiscriminatorAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.ANY_DISCRIMINATOR, xmlDocumentContext.getModelBuildingContext());
        if (jaxbDiscriminator == null) {
            return;
        }
        DiscriminatorType discriminatorType = jaxbDiscriminator.getType();
        if (discriminatorType != null) {
            anyDiscriminatorAnn.value(discriminatorType);
        }
        JaxbColumnImpl jaxbColumn = jaxbDiscriminator.getColumn();
        ColumnJpaAnnotation columnAnn = (ColumnJpaAnnotation)memberDetails.applyAnnotationUsage(JpaAnnotations.COLUMN, xmlDocumentContext.getModelBuildingContext());
        if (jaxbColumn != null) {
            columnAnn.apply(jaxbColumn, xmlDocumentContext);
        }
        if (CollectionHelper.isNotEmpty(jaxbValueMappings = jaxbDiscriminator.getValueMappings())) {
            AnyDiscriminatorValuesAnnotation discriminatorValuesUsage = (AnyDiscriminatorValuesAnnotation)memberDetails.replaceAnnotationUsage(HibernateAnnotations.ANY_DISCRIMINATOR_VALUE, HibernateAnnotations.ANY_DISCRIMINATOR_VALUES, xmlDocumentContext.getModelBuildingContext());
            discriminatorValuesUsage.value(AnyMappingAttributeProcessing.collectDiscriminatorValues(jaxbValueMappings, xmlDocumentContext));
        }
    }

    private static AnyDiscriminatorValue[] collectDiscriminatorValues(List<? extends JaxbDiscriminatorMapping> jaxbValueMappings, XmlDocumentContext xmlDocumentContext) {
        AnyDiscriminatorValue[] values = new AnyDiscriminatorValue[jaxbValueMappings.size()];
        for (int i = 0; i < jaxbValueMappings.size(); ++i) {
            AnyDiscriminatorValueAnnotation valueAnn = (AnyDiscriminatorValueAnnotation)HibernateAnnotations.ANY_DISCRIMINATOR_VALUE.createUsage(xmlDocumentContext.getModelBuildingContext());
            values[i] = valueAnn;
            JaxbDiscriminatorMapping jaxbValue = jaxbValueMappings.get(i);
            valueAnn.discriminator(jaxbValue.getDiscriminatorValue());
            String name = StringHelper.qualifyConditionally(xmlDocumentContext.getXmlDocument().getDefaults().getPackage(), jaxbValue.getCorrespondingEntityName());
            ClassDetails entityClassDetails = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(name);
            valueAnn.entity(entityClassDetails.toJavaClass());
        }
        return values;
    }

    static void applyKey(MutableMemberDetails memberDetails, JaxbAnyMapping jaxbHbmAnyMapping, XmlDocumentContext xmlDocumentContext) {
        JaxbAnyMapping.Key jaxbKey = jaxbHbmAnyMapping.getKey();
        if (StringHelper.isNotEmpty(jaxbKey.getType())) {
            AnyKeTypeAnnotation keyTypeUsage = (AnyKeTypeAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.ANY_KEY_TYPE, xmlDocumentContext.getModelBuildingContext());
            keyTypeUsage.value(jaxbKey.getType());
        } else if (StringHelper.isNotEmpty(jaxbKey.getJavaClass())) {
            AnyKeyJavaClassAnnotation keyJavaType = (AnyKeyJavaClassAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.ANY_KEY_JAVA_CLASS, xmlDocumentContext.getModelBuildingContext());
            keyJavaType.value(AnyMappingAttributeProcessing.resolveKeyType(jaxbKey.getJavaClass(), xmlDocumentContext));
        }
        if (jaxbKey.getColumns().isEmpty()) {
            memberDetails.applyAnnotationUsage(JpaAnnotations.JOIN_COLUMN, xmlDocumentContext.getModelBuildingContext());
        } else {
            JoinColumnsJpaAnnotation joinColumnsUsage = (JoinColumnsJpaAnnotation)memberDetails.replaceAnnotationUsage(JpaAnnotations.JOIN_COLUMN, JpaAnnotations.JOIN_COLUMNS, xmlDocumentContext.getModelBuildingContext());
            JoinColumn[] joinColumns = new JoinColumn[jaxbKey.getColumns().size()];
            joinColumnsUsage.value(joinColumns);
            for (int i = 0; i < jaxbKey.getColumns().size(); ++i) {
                JoinColumnJpaAnnotation joinColumn = (JoinColumnJpaAnnotation)((Object)JpaAnnotations.JOIN_COLUMN.createUsage(xmlDocumentContext.getModelBuildingContext()));
                joinColumns[i] = joinColumn;
                JaxbColumnImpl jaxbJoinColumn = jaxbKey.getColumns().get(i);
                joinColumn.apply(jaxbJoinColumn, xmlDocumentContext);
            }
        }
    }

    private static Class<?> resolveKeyType(String name, XmlDocumentContext xmlDocumentContext) {
        SimpleTypeInterpretation simpleTypeInterpretation = SimpleTypeInterpretation.interpret(name);
        if (simpleTypeInterpretation != null) {
            return simpleTypeInterpretation.getJavaType();
        }
        return xmlDocumentContext.getBootstrapContext().getModelsContext().getClassLoading().classForName(xmlDocumentContext.resolveClassName(name));
    }
}

