/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.NAMED_CACHE)
public interface StateTransferLock {
    public void acquireExclusiveTopologyLock();

    public void releaseExclusiveTopologyLock();

    public void acquireSharedTopologyLock();

    public void releaseSharedTopologyLock();

    public void notifyTransactionDataReceived(int var1);

    public CompletionStage<Void> transactionDataFuture(int var1);

    public boolean transactionDataReceived(int var1);

    public void notifyTopologyInstalled(int var1);

    public CompletionStage<Void> topologyFuture(int var1);

    @Deprecated(forRemoval=true, since="9.0")
    default public void waitForTopology(int expectedTopologyId, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            CompletionStage<Void> topologyFuture = this.topologyFuture(expectedTopologyId);
            topologyFuture.toCompletableFuture().get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new CacheException(e.getCause());
        }
    }

    public boolean topologyReceived(int var1);
}

