/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Objects;
import java.util.Set;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheInvalidationEvent;

@ProtoTypeId(value=65591)
public class UserFederationLinkRemovedEvent
extends InvalidationEvent
implements UserCacheInvalidationEvent {
    final String realmId;
    final String identityProviderId;
    final String socialUserId;

    private UserFederationLinkRemovedEvent(String id, String realmId, String identityProviderId, String socialUserId) {
        super(id);
        this.realmId = Objects.requireNonNull(realmId);
        this.identityProviderId = identityProviderId;
        this.socialUserId = socialUserId;
    }

    public static UserFederationLinkRemovedEvent create(String userId, String realmId, FederatedIdentityModel socialLink) {
        String identityProviderId = socialLink == null ? null : socialLink.getIdentityProvider();
        String socialUserId = socialLink == null ? null : socialLink.getUserId();
        return new UserFederationLinkRemovedEvent(userId, realmId, identityProviderId, socialUserId);
    }

    @ProtoFactory
    static UserFederationLinkRemovedEvent protoFactory(String id, String realmId, String identityProviderId, String socialUserId) {
        return new UserFederationLinkRemovedEvent(id, realmId, identityProviderId, socialUserId);
    }

    @ProtoField(value=2)
    public String getRealmId() {
        return this.realmId;
    }

    @ProtoField(value=3)
    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    @ProtoField(value=4)
    public String getSocialUserId() {
        return this.socialUserId;
    }

    public String toString() {
        return String.format("UserFederationLinkRemovedEvent [ userId=%s, identityProviderId=%s, socialUserId=%s ]", this.getId(), this.identityProviderId, this.socialUserId);
    }

    @Override
    public void addInvalidations(UserCacheManager userCache, Set<String> invalidations) {
        userCache.federatedIdentityLinkRemovedInvalidation(this.getId(), this.realmId, this.identityProviderId, this.socialUserId, invalidations);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserFederationLinkRemovedEvent that = (UserFederationLinkRemovedEvent)o;
        return Objects.equals(this.realmId, that.realmId) && Objects.equals(this.identityProviderId, that.identityProviderId) && Objects.equals(this.socialUserId, that.socialUserId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.realmId, this.identityProviderId, this.socialUserId);
    }
}

