/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.CacheType;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class ClusteringConfiguration
extends ConfigurationElement<ClusteringConfiguration> {
    public static final AttributeDefinition<CacheType> CACHE_TYPE = AttributeDefinition.builder((Enum)Attribute.TYPE, (Object)((Object)CacheType.LOCAL)).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Boolean> CACHE_SYNC = AttributeDefinition.builder((Enum)Attribute.MODE, (Object)true, Boolean.class).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Long> REMOTE_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.REMOTE_TIMEOUT, (Object)TimeUnit.SECONDS.toMillis(15L)).build();
    private final CacheMode cacheMode;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> remoteTimeout;
    private final HashConfiguration hashConfiguration;
    private final L1Configuration l1Configuration;
    private final StateTransferConfiguration stateTransferConfiguration;
    private final PartitionHandlingConfiguration partitionHandlingConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ClusteringConfiguration.class, new AttributeDefinition[]{CACHE_TYPE, CACHE_SYNC, REMOTE_TIMEOUT});
    }

    ClusteringConfiguration(AttributeSet attributes, HashConfiguration hashConfiguration, L1Configuration l1Configuration, StateTransferConfiguration stateTransferConfiguration, PartitionHandlingConfiguration partitionHandlingStrategy) {
        super((Enum)Element.CLUSTERING, attributes, new ConfigurationElement[]{hashConfiguration, l1Configuration, stateTransferConfiguration, partitionHandlingStrategy});
        this.cacheMode = CacheMode.of((CacheType)((Object)attributes.attribute(CACHE_TYPE).get()), (Boolean)attributes.attribute(CACHE_SYNC).get());
        this.remoteTimeout = attributes.attribute(REMOTE_TIMEOUT);
        this.hashConfiguration = hashConfiguration;
        this.l1Configuration = l1Configuration;
        this.stateTransferConfiguration = stateTransferConfiguration;
        this.partitionHandlingConfiguration = partitionHandlingStrategy;
    }

    public CacheMode cacheMode() {
        return this.cacheMode;
    }

    public long remoteTimeout() {
        return (Long)this.remoteTimeout.get();
    }

    public void remoteTimeout(long timeoutMillis) {
        this.remoteTimeout.set((Object)timeoutMillis);
    }

    public PartitionHandlingConfiguration partitionHandling() {
        return this.partitionHandlingConfiguration;
    }

    public String cacheModeString() {
        return this.cacheMode() == null ? "none" : this.cacheMode().toString();
    }

    public HashConfiguration hash() {
        return this.hashConfiguration;
    }

    public L1Configuration l1() {
        return this.l1Configuration;
    }

    public StateTransferConfiguration stateTransfer() {
        return this.stateTransferConfiguration;
    }
}

