/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteStorageThreadPool
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteStorageThreadPool.class);
    @Deprecated(since="4.2")
    private final KafkaMetricsGroup deprecatedLogMetricsGroup = new KafkaMetricsGroup("org.apache.kafka.storage.internals.log", "RemoteStorageThreadPool");
    private final KafkaMetricsGroup logRemoteMetricsGroup = new KafkaMetricsGroup("kafka.log.remote", "RemoteStorageThreadPool");

    public RemoteStorageThreadPool(String threadNamePattern, int numThreads, int maxPendingTasks) {
        super(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxPendingTasks), ThreadUtils.createThreadFactory((String)threadNamePattern, (boolean)false, (t, e) -> LOGGER.error("Uncaught exception in thread '{}':", (Object)t.getName(), (Object)e)));
        this.deprecatedLogMetricsGroup.newGauge(RemoteStorageMetrics.DEPRECATE_REMOTE_LOG_READER_TASK_QUEUE_SIZE_METRIC.getName(), () -> this.getQueue().size());
        this.deprecatedLogMetricsGroup.newGauge(RemoteStorageMetrics.DEPRECATE_REMOTE_LOG_READER_AVG_IDLE_PERCENT_METRIC.getName(), () -> 1.0 - (double)this.getActiveCount() / (double)this.getCorePoolSize());
        this.logRemoteMetricsGroup.newGauge(RemoteStorageMetrics.REMOTE_LOG_READER_TASK_QUEUE_SIZE_METRIC.getName(), () -> this.getQueue().size());
        this.logRemoteMetricsGroup.newGauge(RemoteStorageMetrics.REMOTE_LOG_READER_AVG_IDLE_PERCENT_METRIC.getName(), () -> 1.0 - (double)this.getActiveCount() / (double)this.getCorePoolSize());
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable th) {
        if (th != null && !this.isShutdown()) {
            LOGGER.error("Error occurred while executing task: {}", (Object)runnable, (Object)th);
        }
    }

    public void removeMetrics() {
        RemoteStorageMetrics.REMOTE_STORAGE_THREAD_POOL_METRICS.forEach(arg_0 -> ((KafkaMetricsGroup)this.deprecatedLogMetricsGroup).removeMetric(arg_0));
        RemoteStorageMetrics.REMOTE_STORAGE_THREAD_POOL_METRICS.forEach(arg_0 -> ((KafkaMetricsGroup)this.logRemoteMetricsGroup).removeMetric(arg_0));
    }
}

