/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;

public class ConfigHelperUtils {
    public static <V> DescribeConfigsResponseData.DescribeConfigsResult createResponseConfig(DescribeConfigsRequestData.DescribeConfigsResource resource, Map<String, V> config, BiFunction<String, Object, DescribeConfigsResponseData.DescribeConfigsResourceResult> createConfigEntry) {
        return ConfigHelperUtils.toDescribeConfigsResult(config.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), entry.getValue())), resource, createConfigEntry);
    }

    public static DescribeConfigsResponseData.DescribeConfigsResult createResponseConfig(DescribeConfigsRequestData.DescribeConfigsResource resource, AbstractConfig config, BiFunction<String, Object, DescribeConfigsResponseData.DescribeConfigsResourceResult> createConfigEntry) {
        Map nonInternalValues = config.nonInternalValues();
        Stream<Map.Entry<String, Object>> allEntries = Stream.concat(config.originals().entrySet().stream().filter(entry -> entry.getValue() != null && !nonInternalValues.containsKey(entry.getKey())).map(entry -> Map.entry((String)entry.getKey(), entry.getValue())), nonInternalValues.entrySet().stream());
        return ConfigHelperUtils.toDescribeConfigsResult(allEntries, resource, createConfigEntry);
    }

    private static DescribeConfigsResponseData.DescribeConfigsResult toDescribeConfigsResult(Stream<Map.Entry<String, Object>> configStream, DescribeConfigsRequestData.DescribeConfigsResource resource, BiFunction<String, Object, DescribeConfigsResponseData.DescribeConfigsResourceResult> createConfigEntry) {
        List configKeys = resource.configurationKeys();
        List<DescribeConfigsResponseData.DescribeConfigsResourceResult> configEntries = configStream.filter(entry -> configKeys == null || configKeys.isEmpty() || configKeys.contains(entry.getKey())).map(entry -> (DescribeConfigsResponseData.DescribeConfigsResourceResult)createConfigEntry.apply((String)entry.getKey(), entry.getValue())).toList();
        return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(configEntries);
    }
}

