/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;

public record PluginSource(Path location, Type type, ClassLoader loader, URL[] urls) {
    public boolean isolated() {
        return this.location != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginSource that = (PluginSource)o;
        return Objects.equals(this.location, that.location) && this.loader.equals(that.loader) && Arrays.equals(this.urls, that.urls);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.location, this.loader);
        result = 31 * result + Arrays.hashCode(this.urls);
        return result;
    }

    @Override
    public String toString() {
        return this.location == null ? "classpath" : this.location.toString();
    }

    public static enum Type {
        CLASSPATH,
        MULTI_JAR,
        SINGLE_JAR,
        CLASS_HIERARCHY;

    }
}

