/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class CloseOptions {
    protected GroupMembershipOperation operation = GroupMembershipOperation.REMAIN_IN_GROUP;
    protected Optional<Duration> timeout = Optional.of(Duration.ofMillis(Long.MAX_VALUE));

    private CloseOptions() {
    }

    protected CloseOptions(CloseOptions closeOptions) {
        this.operation = closeOptions.operation;
        this.timeout = closeOptions.timeout;
    }

    public static CloseOptions timeout(Duration timeout) {
        return new CloseOptions().withTimeout(timeout);
    }

    public static CloseOptions groupMembershipOperation(GroupMembershipOperation operation) {
        return new CloseOptions().withGroupMembershipOperation(operation);
    }

    public CloseOptions withTimeout(Duration timeout) {
        this.timeout = Optional.ofNullable(timeout);
        return this;
    }

    public CloseOptions withGroupMembershipOperation(GroupMembershipOperation operation) {
        this.operation = Objects.requireNonNull(operation, "operation should not be null");
        return this;
    }

    public static enum GroupMembershipOperation {
        LEAVE_GROUP,
        REMAIN_IN_GROUP;

    }
}

