/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.clients.admin.AbstractOptions;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListGroupsOptions;
import org.apache.kafka.clients.admin.ListGroupsResult;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.OffsetsUtils;
import org.apache.kafka.tools.consumer.group.ConsumerGroupCommandOptions;
import org.apache.kafka.tools.consumer.group.CsvUtils;
import org.apache.kafka.tools.consumer.group.GroupInformation;
import org.apache.kafka.tools.consumer.group.MemberAssignmentState;
import org.apache.kafka.tools.consumer.group.PartitionAssignmentState;

public class ConsumerGroupCommand {
    static final String MISSING_COLUMN_VALUE = "-";

    public static void main(String[] args) {
        ConsumerGroupCommandOptions opts = ConsumerGroupCommandOptions.fromArgs(args);
        try {
            List<OptionSpec<String>> actions = List.of(opts.listOpt, opts.describeOpt, opts.deleteOpt, opts.resetOffsetsOpt, opts.deleteOffsetsOpt, opts.validateRegexOpt);
            if (actions.stream().filter(arg_0 -> ((OptionSet)opts.options).has(arg_0)).count() != 1L) {
                CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)String.format("Command must include exactly one action: %s", actions.stream().map(opt -> "--" + (String)opt.options().get(0)).collect(Collectors.joining(", "))));
            }
            ConsumerGroupCommand.run(opts);
        }
        catch (OptionException e) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)e.getMessage());
        }
    }

    static void run(ConsumerGroupCommandOptions opts) {
        if (opts.options.has(opts.validateRegexOpt)) {
            ConsumerGroupCommand.validateRegex((String)opts.options.valueOf(opts.validateRegexOpt));
            return;
        }
        try (ConsumerGroupService consumerGroupService = new ConsumerGroupService(opts, Map.of());){
            if (opts.options.has(opts.listOpt)) {
                consumerGroupService.listGroups();
            } else if (opts.options.has(opts.describeOpt)) {
                consumerGroupService.describeGroups();
            } else if (opts.options.has(opts.deleteOpt)) {
                consumerGroupService.deleteGroups();
            } else if (opts.options.has(opts.resetOffsetsOpt)) {
                Map<String, Map<TopicPartition, OffsetAndMetadata>> offsetsToReset = consumerGroupService.resetOffsets();
                if (opts.options.has(opts.exportOpt)) {
                    String exported = consumerGroupService.exportOffsetsToCsv(offsetsToReset);
                    System.out.println(exported);
                } else {
                    OffsetsUtils.printOffsetsToReset(offsetsToReset);
                }
            } else if (opts.options.has(opts.deleteOffsetsOpt)) {
                consumerGroupService.deleteOffsets();
            }
        }
        catch (IllegalArgumentException e) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)e.getMessage());
        }
        catch (Throwable e) {
            ConsumerGroupCommand.printError("Executing consumer group command failed due to " + e.getMessage(), Optional.of(e));
        }
    }

    static void validateRegex(String regex) {
        try {
            Pattern.compile((String)regex);
            System.out.printf("The regular expression `%s` is valid.%n", regex);
        }
        catch (PatternSyntaxException ex) {
            System.out.printf("The regular expression `%s` is invalid: %s.%n", regex, ex.getDescription());
        }
    }

    static Set<GroupState> groupStatesFromString(String input) {
        Set<GroupState> parsedStates = Arrays.stream(input.split(",")).map(s -> GroupState.parse((String)s.trim())).collect(Collectors.toSet());
        Set validStates = GroupState.groupStatesForType((GroupType)GroupType.CONSUMER);
        if (!validStates.containsAll(parsedStates)) {
            throw new IllegalArgumentException("Invalid state list '" + input + "'. Valid states are: " + validStates.stream().map(GroupState::toString).collect(Collectors.joining(", ")));
        }
        return parsedStates;
    }

    static Set<GroupType> consumerGroupTypesFromString(String input) {
        Set<GroupType> parsedTypes;
        Set<GroupType> validTypes = Set.of(GroupType.CLASSIC, GroupType.CONSUMER);
        if (!validTypes.containsAll(parsedTypes = Stream.of(input.toLowerCase().split(",")).map(s -> GroupType.parse((String)s.trim())).collect(Collectors.toSet()))) {
            throw new IllegalArgumentException("Invalid types list '" + input + "'. Valid types are: " + String.join((CharSequence)", ", validTypes.stream().map(GroupType::toString).collect(Collectors.toSet())));
        }
        return parsedTypes;
    }

    static void printError(String msg, Optional<Throwable> e) {
        System.out.println("\nError: " + msg);
        e.ifPresent(Throwable::printStackTrace);
    }

    static class ConsumerGroupService
    implements AutoCloseable {
        final ConsumerGroupCommandOptions opts;
        final Map<String, String> configOverrides;
        private final Admin adminClient;
        private final OffsetsUtils offsetsUtils;

        ConsumerGroupService(ConsumerGroupCommandOptions opts, Map<String, String> configOverrides) {
            this.opts = opts;
            this.configOverrides = configOverrides;
            try {
                this.adminClient = this.createAdminClient(configOverrides);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.offsetsUtils = new OffsetsUtils(this.adminClient, opts.parser, this.getOffsetsUtilsOptions(opts));
        }

        private OffsetsUtils.OffsetsUtilsOptions getOffsetsUtilsOptions(ConsumerGroupCommandOptions opts) {
            return new OffsetsUtils.OffsetsUtilsOptions(opts.options.valuesOf(opts.groupOpt), opts.options.valuesOf(opts.resetToOffsetOpt), opts.options.valuesOf(opts.resetFromFileOpt), opts.options.valuesOf(opts.resetToDatetimeOpt), (String)opts.options.valueOf(opts.resetByDurationOpt), (Long)opts.options.valueOf(opts.resetShiftByOpt), (Long)opts.options.valueOf(opts.timeoutMsOpt));
        }

        void listGroups() throws ExecutionException, InterruptedException {
            boolean includeType = this.opts.options.has(this.opts.typeOpt);
            boolean includeState = this.opts.options.has(this.opts.stateOpt);
            if (includeType || includeState) {
                Set<GroupType> types = this.typeValues();
                Set<GroupState> states = this.stateValues();
                List<GroupListing> listings = this.listConsumerGroupsWithFilters(types, states);
                this.printGroupInfo(listings, includeType, includeState);
            } else {
                this.listConsumerGroups().forEach(System.out::println);
            }
        }

        private Set<GroupState> stateValues() {
            String stateValue = (String)this.opts.options.valueOf(this.opts.stateOpt);
            return stateValue == null || stateValue.isEmpty() ? Set.of() : ConsumerGroupCommand.groupStatesFromString(stateValue);
        }

        private Set<GroupType> typeValues() {
            String typeValue = (String)this.opts.options.valueOf(this.opts.typeOpt);
            return typeValue == null || typeValue.isEmpty() ? Set.of() : ConsumerGroupCommand.consumerGroupTypesFromString(typeValue);
        }

        private void printGroupInfo(List<GroupListing> groups, boolean includeType, boolean includeState) {
            Function<GroupListing, String> groupId = GroupListing::groupId;
            Function<GroupListing, String> groupType = groupListing -> groupListing.type().orElse(GroupType.UNKNOWN).toString();
            Function<GroupListing, String> groupState = groupListing -> groupListing.groupState().orElse(GroupState.UNKNOWN).toString();
            OptionalInt maybeMax = groups.stream().mapToInt(groupListing -> Math.max(15, ((String)groupId.apply((GroupListing)groupListing)).length())).max();
            int maxGroupLen = maybeMax.orElse(15) + 10;
            String format = "%-" + maxGroupLen + "s";
            ArrayList<String> header = new ArrayList<String>();
            header.add("GROUP");
            ArrayList<Function<GroupListing, String>> extractors = new ArrayList<Function<GroupListing, String>>();
            extractors.add(groupId);
            if (includeType) {
                header.add("TYPE");
                extractors.add(groupType);
                format = format + " %-20s";
            }
            if (includeState) {
                header.add("STATE");
                extractors.add(groupState);
                format = format + " %-20s";
            }
            System.out.printf(format + "%n", header.toArray(new Object[0]));
            for (GroupListing groupListing2 : groups) {
                Object[] info = extractors.stream().map(extractor -> (String)extractor.apply(groupListing2)).toArray(Object[]::new);
                System.out.printf(format + "%n", info);
            }
        }

        List<String> listConsumerGroups() {
            try {
                ListGroupsResult result = this.adminClient.listGroups(this.withTimeoutMs(ListGroupsOptions.forConsumerGroups()));
                Collection listings = (Collection)result.all().get();
                return listings.stream().map(GroupListing::groupId).collect(Collectors.toList());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        List<GroupListing> listConsumerGroupsWithFilters(Set<GroupType> types, Set<GroupState> states) throws ExecutionException, InterruptedException {
            ListGroupsOptions listGroupsOptions = this.withTimeoutMs(ListGroupsOptions.forConsumerGroups());
            listGroupsOptions.inGroupStates(states).withTypes(types);
            ListGroupsResult result = this.adminClient.listGroups(listGroupsOptions);
            return new ArrayList<GroupListing>((Collection)result.all().get());
        }

        private boolean shouldPrintMemberState(String group, Optional<GroupState> state, Optional<Integer> numRows) {
            if (numRows.isEmpty()) {
                ConsumerGroupCommand.printError("The consumer group '" + group + "' does not exist.", Optional.empty());
                return false;
            }
            int num = numRows.get();
            GroupState state0 = state.orElse(GroupState.UNKNOWN);
            switch (state0) {
                case DEAD: {
                    ConsumerGroupCommand.printError("Consumer group '" + group + "' does not exist.", Optional.empty());
                    break;
                }
                case EMPTY: {
                    System.err.println("\nConsumer group '" + group + "' has no active members.");
                    break;
                }
                case PREPARING_REBALANCE: 
                case COMPLETING_REBALANCE: 
                case ASSIGNING: 
                case RECONCILING: {
                    System.err.println("\nWarning: Consumer group '" + group + "' is rebalancing.");
                    break;
                }
                case STABLE: {
                    break;
                }
                default: {
                    throw new KafkaException("Expected a valid consumer group state, but found '" + String.valueOf(state0) + "'.");
                }
            }
            return !state0.equals((Object)GroupState.DEAD) && num > 0;
        }

        private Optional<Integer> size(Optional<? extends Collection<?>> colOpt) {
            return colOpt.map(Collection::size);
        }

        private void printOffsets(Map<String, Map.Entry<Optional<GroupState>, Optional<Collection<PartitionAssignmentState>>>> offsets, boolean verbose) {
            offsets.forEach((groupId, tuple) -> {
                Optional assignments;
                Optional state = (Optional)tuple.getKey();
                if (this.shouldPrintMemberState((String)groupId, state, this.size(assignments = (Optional)tuple.getValue()))) {
                    String format = ConsumerGroupService.printOffsetFormat(assignments, verbose);
                    if (verbose) {
                        System.out.printf(format, "GROUP", "TOPIC", "PARTITION", "LEADER-EPOCH", "CURRENT-OFFSET", "LOG-END-OFFSET", "LAG", "CONSUMER-ID", "HOST", "CLIENT-ID");
                    } else {
                        System.out.printf(format, "GROUP", "TOPIC", "PARTITION", "CURRENT-OFFSET", "LOG-END-OFFSET", "LAG", "CONSUMER-ID", "HOST", "CLIENT-ID");
                    }
                    if (assignments.isPresent()) {
                        Collection consumerAssignments = (Collection)assignments.get();
                        for (PartitionAssignmentState consumerAssignment : consumerAssignments) {
                            if (verbose) {
                                System.out.printf(format, consumerAssignment.group(), consumerAssignment.topic().orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.partition().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.leaderEpoch().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.offset().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.logEndOffset().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.lag().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.consumerId().orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.host().orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.clientId().orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE));
                                continue;
                            }
                            System.out.printf(format, consumerAssignment.group(), consumerAssignment.topic().orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.partition().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.offset().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.logEndOffset().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.lag().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.consumerId().orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.host().orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.clientId().orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE));
                        }
                        System.out.println();
                    }
                }
            });
        }

        private static String printOffsetFormat(Optional<Collection<PartitionAssignmentState>> assignments, boolean verbose) {
            int maxGroupLen = 15;
            int maxTopicLen = 15;
            int maxConsumerIdLen = 15;
            int maxHostLen = 15;
            if (assignments.isPresent()) {
                Collection<PartitionAssignmentState> consumerAssignments = assignments.get();
                for (PartitionAssignmentState consumerAssignment : consumerAssignments) {
                    maxGroupLen = Math.max(maxGroupLen, consumerAssignment.group().length());
                    maxTopicLen = Math.max(maxTopicLen, consumerAssignment.topic().orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE).length());
                    maxConsumerIdLen = Math.max(maxConsumerIdLen, consumerAssignment.consumerId().orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE).length());
                    maxHostLen = Math.max(maxHostLen, consumerAssignment.host().orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE).length());
                }
            }
            if (verbose) {
                return "\n%" + -maxGroupLen + "s %" + -maxTopicLen + "s %-10s %-15s %-15s %-15s %-15s %" + -maxConsumerIdLen + "s %" + -maxHostLen + "s %s";
            }
            return "\n%" + -maxGroupLen + "s %" + -maxTopicLen + "s %-10s %-15s %-15s %-15s %" + -maxConsumerIdLen + "s %" + -maxHostLen + "s %s";
        }

        private void printMembers(Map<String, Map.Entry<Optional<GroupState>, Optional<Collection<MemberAssignmentState>>>> members, boolean verbose) {
            members.forEach((groupId, tuple) -> {
                boolean hasMigrationMember;
                Optional groupState = (Optional)tuple.getKey();
                Optional assignments = (Optional)tuple.getValue();
                int maxGroupLen = 15;
                int maxConsumerIdLen = 15;
                int maxGroupInstanceIdLen = 17;
                int maxHostLen = 15;
                int maxClientIdLen = 15;
                int maxCurrentAssignment = 20;
                int maxTargetAssignment = 20;
                boolean includeGroupInstanceId = false;
                boolean hasClassicMember = false;
                boolean hasConsumerMember = false;
                if (this.shouldPrintMemberState((String)groupId, groupState, this.size(assignments)) && assignments.isPresent()) {
                    for (MemberAssignmentState memberAssignment : (Collection)assignments.get()) {
                        maxGroupLen = Math.max(maxGroupLen, memberAssignment.group().length());
                        maxConsumerIdLen = Math.max(maxConsumerIdLen, memberAssignment.consumerId().length());
                        maxGroupInstanceIdLen = Math.max(maxGroupInstanceIdLen, memberAssignment.groupInstanceId().length());
                        maxHostLen = Math.max(maxHostLen, memberAssignment.host().length());
                        maxClientIdLen = Math.max(maxClientIdLen, memberAssignment.clientId().length());
                        includeGroupInstanceId = includeGroupInstanceId || !memberAssignment.groupInstanceId().isEmpty();
                        String currentAssignment = memberAssignment.assignment().isEmpty() ? ConsumerGroupCommand.MISSING_COLUMN_VALUE : this.getAssignmentString(memberAssignment.assignment());
                        String targetAssignment = memberAssignment.targetAssignment().isEmpty() ? ConsumerGroupCommand.MISSING_COLUMN_VALUE : this.getAssignmentString(memberAssignment.targetAssignment());
                        maxCurrentAssignment = Math.max(maxCurrentAssignment, currentAssignment.length());
                        maxTargetAssignment = Math.max(maxTargetAssignment, targetAssignment.length());
                        hasClassicMember = hasClassicMember || memberAssignment.upgraded().isPresent() && memberAssignment.upgraded().get() == false;
                        hasConsumerMember = hasConsumerMember || memberAssignment.upgraded().isPresent() && memberAssignment.upgraded().get() != false;
                    }
                }
                String formatWithGroupInstanceId = "%" + -maxGroupLen + "s %" + -maxConsumerIdLen + "s %" + -maxGroupInstanceIdLen + "s %" + -maxHostLen + "s %" + -maxClientIdLen + "s %-15s ";
                String formatWithoutGroupInstanceId = "%" + -maxGroupLen + "s %" + -maxConsumerIdLen + "s %" + -maxHostLen + "s %" + -maxClientIdLen + "s %-15s ";
                if (includeGroupInstanceId) {
                    System.out.printf("\n" + formatWithGroupInstanceId, "GROUP", "CONSUMER-ID", "GROUP-INSTANCE-ID", "HOST", "CLIENT-ID", "#PARTITIONS");
                } else {
                    System.out.printf("\n" + formatWithoutGroupInstanceId, "GROUP", "CONSUMER-ID", "HOST", "CLIENT-ID", "#PARTITIONS");
                }
                String formatWithUpgrade = "%-15s %" + -maxCurrentAssignment + "s %-15s %" + -maxTargetAssignment + "s %s";
                String formatWithoutUpgrade = "%-15s %" + -maxCurrentAssignment + "s %-15s %" + -maxTargetAssignment + "s";
                boolean bl = hasMigrationMember = hasClassicMember && hasConsumerMember;
                if (verbose) {
                    if (hasMigrationMember) {
                        System.out.printf(formatWithUpgrade, "CURRENT-EPOCH", "CURRENT-ASSIGNMENT", "TARGET-EPOCH", "TARGET-ASSIGNMENT", "UPGRADED");
                    } else {
                        System.out.printf(formatWithoutUpgrade, "CURRENT-EPOCH", "CURRENT-ASSIGNMENT", "TARGET-EPOCH", "TARGET-ASSIGNMENT");
                    }
                }
                System.out.println();
                if (assignments.isPresent()) {
                    this.printMembersHelper((Collection)assignments.get(), verbose, includeGroupInstanceId, hasMigrationMember, formatWithGroupInstanceId, formatWithoutGroupInstanceId, formatWithUpgrade, formatWithoutUpgrade);
                }
            });
        }

        private void printMembersHelper(Collection<MemberAssignmentState> memberAssignments, boolean verbose, boolean includeGroupInstanceId, boolean hasMigrationMember, String formatWithGroupInstanceId, String formatWithoutGroupInstanceId, String formatWithUpgrade, String formatWithoutUpgrade) {
            for (MemberAssignmentState memberAssignment : memberAssignments) {
                if (includeGroupInstanceId) {
                    System.out.printf(formatWithGroupInstanceId, memberAssignment.group(), memberAssignment.consumerId(), memberAssignment.groupInstanceId(), memberAssignment.host(), memberAssignment.clientId(), memberAssignment.numPartitions());
                } else {
                    System.out.printf(formatWithoutGroupInstanceId, memberAssignment.group(), memberAssignment.consumerId(), memberAssignment.host(), memberAssignment.clientId(), memberAssignment.numPartitions());
                }
                if (verbose) {
                    String targetAssignment;
                    String currentEpoch = memberAssignment.currentEpoch().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE);
                    String currentAssignment = memberAssignment.assignment().isEmpty() ? ConsumerGroupCommand.MISSING_COLUMN_VALUE : this.getAssignmentString(memberAssignment.assignment());
                    String targetEpoch = memberAssignment.targetEpoch().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE);
                    String string = targetAssignment = memberAssignment.targetAssignment().isEmpty() ? ConsumerGroupCommand.MISSING_COLUMN_VALUE : this.getAssignmentString(memberAssignment.targetAssignment());
                    if (hasMigrationMember) {
                        System.out.printf(formatWithUpgrade, currentEpoch, currentAssignment, targetEpoch, targetAssignment, memberAssignment.upgraded().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE));
                    } else {
                        System.out.printf(formatWithoutUpgrade, currentEpoch, currentAssignment, targetEpoch, targetAssignment);
                    }
                }
                System.out.println();
            }
        }

        private String getAssignmentString(List<TopicPartition> assignment) {
            HashMap grouped = new HashMap();
            assignment.forEach(tp -> grouped.computeIfAbsent(tp.topic(), key -> new ArrayList()).add(tp));
            return grouped.entrySet().stream().map(entry -> {
                String topicName = (String)entry.getKey();
                List topicPartitions = (List)entry.getValue();
                return topicPartitions.stream().map(TopicPartition::partition).sorted().map(Object::toString).collect(Collectors.joining(",", topicName + ":", ""));
            }).sorted().collect(Collectors.joining(";"));
        }

        private void printStates(Map<String, GroupInformation> states, boolean verbose) {
            states.forEach((groupId, state) -> {
                if (this.shouldPrintMemberState((String)groupId, Optional.of(state.groupState()), Optional.of(1))) {
                    String assignmentStrategy;
                    String coordinator = state.coordinator().host() + ":" + state.coordinator().port() + "  (" + state.coordinator().idString() + ")";
                    int coordinatorColLen = Math.max(25, coordinator.length());
                    int groupColLen = Math.max(15, state.group().length());
                    String string = assignmentStrategy = state.assignmentStrategy().isEmpty() ? ConsumerGroupCommand.MISSING_COLUMN_VALUE : state.assignmentStrategy();
                    if (verbose) {
                        String format = "\n%" + -groupColLen + "s %" + -coordinatorColLen + "s %-20s %-20s %-15s %-25s %s";
                        System.out.printf(format, "GROUP", "COORDINATOR (ID)", "ASSIGNMENT-STRATEGY", "STATE", "GROUP-EPOCH", "TARGET-ASSIGNMENT-EPOCH", "#MEMBERS");
                        System.out.printf(format, state.group(), coordinator, assignmentStrategy, state.groupState(), state.groupEpoch().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), state.targetAssignmentEpoch().map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), state.numMembers());
                    } else {
                        String format = "\n%" + -groupColLen + "s %" + -coordinatorColLen + "s %-20s %-20s %s";
                        System.out.printf(format, "GROUP", "COORDINATOR (ID)", "ASSIGNMENT-STRATEGY", "STATE", "#MEMBERS");
                        System.out.printf(format, state.group(), coordinator, assignmentStrategy, state.groupState(), state.numMembers());
                    }
                    System.out.println();
                }
            });
        }

        void describeGroups() throws Exception {
            List groupIds = this.opts.options.has(this.opts.allGroupsOpt) ? this.listConsumerGroups() : this.opts.options.valuesOf(this.opts.groupOpt);
            boolean membersOptPresent = this.opts.options.has(this.opts.membersOpt);
            boolean stateOptPresent = this.opts.options.has(this.opts.stateOpt);
            boolean offsetsOptPresent = this.opts.options.has(this.opts.offsetsOpt);
            long subActions = Stream.of(membersOptPresent, offsetsOptPresent, stateOptPresent).filter(x -> x).count();
            if (subActions == 0L || offsetsOptPresent) {
                TreeMap<String, Map.Entry<Optional<GroupState>, Optional<Collection<PartitionAssignmentState>>>> offsets = this.collectGroupsOffsets(groupIds);
                this.printOffsets(offsets, this.opts.options.has(this.opts.verboseOpt));
            } else if (membersOptPresent) {
                TreeMap<String, Map.Entry<Optional<GroupState>, Optional<Collection<MemberAssignmentState>>>> members = this.collectGroupsMembers(groupIds);
                this.printMembers(members, this.opts.options.has(this.opts.verboseOpt));
            } else {
                TreeMap<String, GroupInformation> states = this.collectGroupsState(groupIds);
                this.printStates(states, this.opts.options.has(this.opts.verboseOpt));
            }
        }

        private Collection<PartitionAssignmentState> collectConsumerAssignment(String group, Optional<Node> coordinator, Collection<TopicPartition> topicPartitions, Map<TopicPartition, OffsetAndMetadata> committedOffsets, Optional<String> consumerIdOpt, Optional<String> hostOpt, Optional<String> clientIdOpt) {
            if (topicPartitions.isEmpty()) {
                return Set.of(new PartitionAssignmentState(group, coordinator, Optional.empty(), Optional.empty(), Optional.empty(), this.getLag(Optional.empty(), Optional.empty()), consumerIdOpt, hostOpt, clientIdOpt, Optional.empty(), Optional.empty()));
            }
            return this.describePartitions(group, coordinator, topicPartitions, committedOffsets, consumerIdOpt, hostOpt, clientIdOpt);
        }

        private Optional<Long> getLag(Optional<Long> offset, Optional<Long> logEndOffset) {
            return offset.filter(o -> o != -1L).flatMap(offset0 -> logEndOffset.map(end -> end - offset0));
        }

        private Collection<PartitionAssignmentState> describePartitions(String group, Optional<Node> coordinator, Collection<TopicPartition> topicPartitions, Map<TopicPartition, OffsetAndMetadata> committedOffsets, Optional<String> consumerIdOpt, Optional<String> hostOpt, Optional<String> clientIdOpt) {
            BiFunction<TopicPartition, Optional, PartitionAssignmentState> getDescribePartitionResult = (topicPartition, logEndOffsetOpt) -> {
                Optional<Long> offset = Optional.ofNullable((OffsetAndMetadata)committedOffsets.get(topicPartition)).map(OffsetAndMetadata::offset);
                Optional<Integer> leaderEpoch = Optional.ofNullable((OffsetAndMetadata)committedOffsets.get(topicPartition)).flatMap(OffsetAndMetadata::leaderEpoch);
                return new PartitionAssignmentState(group, coordinator, Optional.of(topicPartition.topic()), Optional.of(topicPartition.partition()), offset, this.getLag(offset, (Optional<Long>)logEndOffsetOpt), consumerIdOpt, hostOpt, clientIdOpt, (Optional<Long>)logEndOffsetOpt, leaderEpoch);
            };
            List<TopicPartition> topicPartitionsWithoutLeader = this.offsetsUtils.filterNoneLeaderPartitions(topicPartitions);
            List<TopicPartition> topicPartitionsWithLeader = topicPartitions.stream().filter(tp -> !topicPartitionsWithoutLeader.contains(tp)).toList();
            List<PartitionAssignmentState> existLeaderAssignments = this.offsetsUtils.getLogEndOffsets(topicPartitionsWithLeader).entrySet().stream().map(logEndOffsetResult -> {
                if (logEndOffsetResult.getValue() instanceof OffsetsUtils.LogOffset) {
                    return (PartitionAssignmentState)getDescribePartitionResult.apply((TopicPartition)logEndOffsetResult.getKey(), Optional.of(((OffsetsUtils.LogOffset)logEndOffsetResult.getValue()).value()));
                }
                if (logEndOffsetResult.getValue() instanceof OffsetsUtils.Unknown) {
                    return (PartitionAssignmentState)getDescribePartitionResult.apply((TopicPartition)logEndOffsetResult.getKey(), Optional.empty());
                }
                if (logEndOffsetResult.getValue() instanceof OffsetsUtils.Ignore) {
                    return null;
                }
                throw new IllegalStateException("Unknown LogOffset subclass: " + String.valueOf(logEndOffsetResult.getValue()));
            }).toList();
            List<PartitionAssignmentState> noneLeaderAssignments = topicPartitionsWithoutLeader.stream().map(tp -> (PartitionAssignmentState)getDescribePartitionResult.apply((TopicPartition)tp, Optional.empty())).toList();
            return Stream.concat(existLeaderAssignments.stream(), noneLeaderAssignments.stream()).sorted(Comparator.comparing(state -> state.topic().orElse(""), String::compareTo).thenComparingInt(state -> state.partition().orElse(-1))).collect(Collectors.toList());
        }

        Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsets() {
            List groupIds = this.opts.options.has(this.opts.allGroupsOpt) ? this.listConsumerGroups() : this.opts.options.valuesOf(this.opts.groupOpt);
            Map consumerGroups = this.adminClient.describeConsumerGroups((Collection)groupIds, this.withTimeoutMs(new DescribeConsumerGroupsOptions())).describedGroups();
            HashMap<String, Map<TopicPartition, OffsetAndMetadata>> result = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
            consumerGroups.forEach((groupId, groupDescription) -> {
                try {
                    String state;
                    switch (state = ((ConsumerGroupDescription)groupDescription.get()).groupState().toString()) {
                        case "Empty": 
                        case "Dead": {
                            result.put((String)groupId, this.resetOffsetsForInactiveGroup((String)groupId));
                            break;
                        }
                        default: {
                            ConsumerGroupCommand.printError("Assignments can only be reset if the group '" + groupId + "' is inactive, but the current state is " + state + ".", Optional.empty());
                            result.put((String)groupId, Map.of());
                            break;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                catch (ExecutionException ee) {
                    if (ee.getCause() instanceof GroupIdNotFoundException) {
                        result.put((String)groupId, this.resetOffsetsForInactiveGroup((String)groupId));
                    }
                    throw new RuntimeException(ee);
                }
            });
            return result;
        }

        private Map<TopicPartition, OffsetAndMetadata> resetOffsetsForInactiveGroup(String groupId) {
            try {
                boolean dryRun;
                Collection<TopicPartition> partitionsToReset = this.getPartitionsToReset(groupId);
                Map<TopicPartition, OffsetAndMetadata> preparedOffsets = this.prepareOffsetsToReset(groupId, partitionsToReset);
                boolean bl = dryRun = this.opts.options.has(this.opts.dryRunOpt) || !this.opts.options.has(this.opts.executeOpt);
                if (!dryRun) {
                    this.adminClient.alterConsumerGroupOffsets(groupId, preparedOffsets, this.withTimeoutMs(new AlterConsumerGroupOffsetsOptions())).all().get();
                }
                return preparedOffsets;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                if (cause instanceof KafkaException) {
                    throw (KafkaException)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        Map.Entry<Errors, Map<TopicPartition, Throwable>> deleteOffsets(String groupId, List<String> topics) {
            HashMap partitionLevelResult = new HashMap();
            HashSet<String> topicWithPartitions = new HashSet<String>();
            HashSet<String> topicWithoutPartitions = new HashSet<String>();
            for (String topic : topics) {
                if (topic.contains(":")) {
                    topicWithPartitions.add(topic);
                    continue;
                }
                topicWithoutPartitions.add(topic);
            }
            List knownPartitions = topicWithPartitions.stream().flatMap(this.offsetsUtils::parseTopicsWithPartitions).toList();
            DescribeTopicsResult describeTopicsResult = this.adminClient.describeTopics(topicWithoutPartitions, this.withTimeoutMs(new DescribeTopicsOptions()));
            Iterator unknownPartitions = describeTopicsResult.topicNameValues().entrySet().stream().flatMap(e -> {
                String topic = (String)e.getKey();
                try {
                    return ((TopicDescription)((KafkaFuture)e.getValue()).get()).partitions().stream().map(partition -> new TopicPartition(topic, partition.partition()));
                }
                catch (InterruptedException | ExecutionException err) {
                    partitionLevelResult.put(new TopicPartition(topic, -1), err);
                    return Stream.empty();
                }
            }).iterator();
            HashSet partitions = new HashSet(knownPartitions);
            unknownPartitions.forEachRemaining(partitions::add);
            DeleteConsumerGroupOffsetsResult deleteResult = this.adminClient.deleteConsumerGroupOffsets(groupId, partitions, this.withTimeoutMs(new DeleteConsumerGroupOffsetsOptions()));
            Errors topLevelException = Errors.NONE;
            try {
                deleteResult.all().get();
            }
            catch (InterruptedException | ExecutionException e2) {
                topLevelException = Errors.forException((Throwable)e2.getCause());
            }
            partitions.forEach(partition -> {
                try {
                    deleteResult.partitionResult(partition).get();
                    partitionLevelResult.put(partition, null);
                }
                catch (InterruptedException | ExecutionException e) {
                    partitionLevelResult.put(partition, e);
                }
            });
            return new AbstractMap.SimpleImmutableEntry<Errors, Map<TopicPartition, Throwable>>(topLevelException, partitionLevelResult);
        }

        void deleteOffsets() {
            String groupId = (String)this.opts.options.valueOf(this.opts.groupOpt);
            List topics = this.opts.options.valuesOf(this.opts.topicOpt);
            Map.Entry<Errors, Map<TopicPartition, Throwable>> res = this.deleteOffsets(groupId, topics);
            Errors topLevelResult = res.getKey();
            Map<TopicPartition, Throwable> partitionLevelResult = res.getValue();
            switch (topLevelResult) {
                case NONE: {
                    System.out.println("Request succeeded for deleting offsets from group " + groupId + ".");
                    break;
                }
                case INVALID_GROUP_ID: 
                case GROUP_ID_NOT_FOUND: 
                case GROUP_AUTHORIZATION_FAILED: 
                case NON_EMPTY_GROUP: {
                    ConsumerGroupCommand.printError(topLevelResult.message(), Optional.empty());
                    break;
                }
                case GROUP_SUBSCRIBED_TO_TOPIC: 
                case TOPIC_AUTHORIZATION_FAILED: 
                case UNKNOWN_TOPIC_OR_PARTITION: {
                    ConsumerGroupCommand.printError("Encountered some partition-level error, see the follow-up details.", Optional.empty());
                    break;
                }
                default: {
                    ConsumerGroupCommand.printError("Encountered some unknown error: " + String.valueOf(topLevelResult), Optional.empty());
                }
            }
            int maxTopicLen = 15;
            for (TopicPartition tp : partitionLevelResult.keySet()) {
                maxTopicLen = Math.max(maxTopicLen, tp.topic().length());
            }
            String format = "%n%" + -maxTopicLen + "s %-10s %-15s";
            System.out.printf(format, "TOPIC", "PARTITION", "STATUS");
            partitionLevelResult.entrySet().stream().sorted(Comparator.comparing(e -> ((TopicPartition)e.getKey()).topic() + ((TopicPartition)e.getKey()).partition())).forEach(e -> {
                TopicPartition tp = (TopicPartition)e.getKey();
                Throwable error = (Throwable)e.getValue();
                System.out.printf(format, tp.topic(), tp.partition() >= 0 ? Integer.valueOf(tp.partition()) : ConsumerGroupCommand.MISSING_COLUMN_VALUE, error != null ? "Error: " + error.getMessage() : "Successful");
            });
            System.out.println();
        }

        Map<String, ConsumerGroupDescription> describeConsumerGroups(Collection<String> groupIds) throws Exception {
            HashMap<String, ConsumerGroupDescription> res = new HashMap<String, ConsumerGroupDescription>();
            Map stringKafkaFutureMap = this.adminClient.describeConsumerGroups(groupIds, this.withTimeoutMs(new DescribeConsumerGroupsOptions())).describedGroups();
            for (Map.Entry e : stringKafkaFutureMap.entrySet()) {
                res.put((String)e.getKey(), (ConsumerGroupDescription)((KafkaFuture)e.getValue()).get());
            }
            return res;
        }

        Map.Entry<Optional<GroupState>, Optional<Collection<PartitionAssignmentState>>> collectGroupOffsets(String groupId) throws Exception {
            return this.collectGroupsOffsets(List.of(groupId)).getOrDefault(groupId, new AbstractMap.SimpleImmutableEntry(Optional.empty(), Optional.empty()));
        }

        TreeMap<String, Map.Entry<Optional<GroupState>, Optional<Collection<PartitionAssignmentState>>>> collectGroupsOffsets(Collection<String> groupIds) throws Exception {
            Map<String, ConsumerGroupDescription> consumerGroups = this.describeConsumerGroups(groupIds);
            TreeMap<String, Map.Entry<Optional<GroupState>, Optional<Collection<PartitionAssignmentState>>>> groupOffsets = new TreeMap<String, Map.Entry<Optional<GroupState>, Optional<Collection<PartitionAssignmentState>>>>();
            consumerGroups.forEach((groupId, consumerGroup) -> {
                GroupState state = consumerGroup.groupState();
                Map<TopicPartition, OffsetAndMetadata> committedOffsets = this.getCommittedOffsets((String)groupId);
                ArrayList assignedTopicPartitions = new ArrayList();
                Comparator<MemberDescription> comparator = Comparator.comparingInt(m -> m.assignment().topicPartitions().size()).reversed();
                ArrayList rowsWithConsumer = new ArrayList();
                consumerGroup.members().stream().filter(m -> !m.assignment().topicPartitions().isEmpty()).sorted(comparator).forEach(consumerSummary -> {
                    Set topicPartitions = consumerSummary.assignment().topicPartitions();
                    assignedTopicPartitions.addAll(topicPartitions);
                    rowsWithConsumer.addAll(this.collectConsumerAssignment((String)groupId, Optional.of(consumerGroup.coordinator()), topicPartitions, committedOffsets, Optional.of(consumerSummary.consumerId()), Optional.of(consumerSummary.host()), Optional.of(consumerSummary.clientId())));
                });
                HashMap unassignedPartitions = new HashMap();
                committedOffsets.entrySet().stream().filter(e -> !assignedTopicPartitions.contains(e.getKey())).forEach(e -> unassignedPartitions.put((TopicPartition)e.getKey(), (OffsetAndMetadata)e.getValue()));
                List rowsWithoutConsumer = !unassignedPartitions.isEmpty() ? this.collectConsumerAssignment((String)groupId, Optional.of(consumerGroup.coordinator()), (Collection<TopicPartition>)unassignedPartitions.keySet(), committedOffsets, Optional.of(ConsumerGroupCommand.MISSING_COLUMN_VALUE), Optional.of(ConsumerGroupCommand.MISSING_COLUMN_VALUE), Optional.of(ConsumerGroupCommand.MISSING_COLUMN_VALUE)) : List.of();
                rowsWithConsumer.addAll(rowsWithoutConsumer);
                groupOffsets.put((String)groupId, new AbstractMap.SimpleImmutableEntry(Optional.of(state), Optional.of(rowsWithConsumer)));
            });
            return groupOffsets;
        }

        Map.Entry<Optional<GroupState>, Optional<Collection<MemberAssignmentState>>> collectGroupMembers(String groupId) throws Exception {
            return this.collectGroupsMembers(Set.of(groupId)).get(groupId);
        }

        TreeMap<String, Map.Entry<Optional<GroupState>, Optional<Collection<MemberAssignmentState>>>> collectGroupsMembers(Collection<String> groupIds) throws Exception {
            Map<String, ConsumerGroupDescription> consumerGroups = this.describeConsumerGroups(groupIds);
            TreeMap<String, Map.Entry<Optional<GroupState>, Optional<Collection<MemberAssignmentState>>>> res = new TreeMap<String, Map.Entry<Optional<GroupState>, Optional<Collection<MemberAssignmentState>>>>();
            consumerGroups.forEach((groupId, consumerGroup) -> {
                GroupState state = consumerGroup.groupState();
                List memberAssignmentStates = consumerGroup.members().stream().map(consumer -> new MemberAssignmentState((String)groupId, consumer.consumerId(), consumer.host(), consumer.clientId(), consumer.groupInstanceId().orElse(""), consumer.assignment().topicPartitions().size(), consumer.assignment().topicPartitions().stream().toList(), consumer.targetAssignment().map(a -> a.topicPartitions().stream().toList()).orElse(List.of()), consumer.memberEpoch(), consumerGroup.targetAssignmentEpoch(), consumer.upgraded())).collect(Collectors.toList());
                res.put((String)groupId, new AbstractMap.SimpleImmutableEntry(Optional.of(state), Optional.of(memberAssignmentStates)));
            });
            return res;
        }

        GroupInformation collectGroupState(String groupId) throws Exception {
            return this.collectGroupsState(Set.of(groupId)).get(groupId);
        }

        TreeMap<String, GroupInformation> collectGroupsState(Collection<String> groupIds) throws Exception {
            Map<String, ConsumerGroupDescription> consumerGroups = this.describeConsumerGroups(groupIds);
            TreeMap<String, GroupInformation> res = new TreeMap<String, GroupInformation>();
            consumerGroups.forEach((groupId, groupDescription) -> res.put((String)groupId, new GroupInformation((String)groupId, groupDescription.coordinator(), groupDescription.partitionAssignor(), groupDescription.groupState(), groupDescription.members().size(), groupDescription.groupEpoch(), groupDescription.targetAssignmentEpoch())));
            return res;
        }

        @Override
        public void close() {
            this.adminClient.close();
        }

        protected Admin createAdminClient(Map<String, String> configOverrides) throws IOException {
            Properties props = this.opts.options.has(this.opts.commandConfigOpt) ? Utils.loadProps((String)((String)this.opts.options.valueOf(this.opts.commandConfigOpt))) : new Properties();
            props.put("bootstrap.servers", this.opts.options.valueOf(this.opts.bootstrapServerOpt));
            props.putAll(configOverrides);
            return Admin.create((Properties)props);
        }

        private <T extends AbstractOptions<T>> T withTimeoutMs(T options) {
            int t = ((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue();
            return (T)options.timeoutMs(Integer.valueOf(t));
        }

        private Collection<TopicPartition> getPartitionsToReset(String groupId) throws ExecutionException, InterruptedException {
            if (this.opts.options.has(this.opts.allTopicsOpt)) {
                return this.getCommittedOffsets(groupId).keySet();
            }
            if (this.opts.options.has(this.opts.topicOpt)) {
                List topics = this.opts.options.valuesOf(this.opts.topicOpt);
                return this.offsetsUtils.parseTopicPartitionsToReset(topics);
            }
            if (!this.opts.options.has(this.opts.resetFromFileOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.opts.parser, (String)"One of the reset scopes should be defined: --all-topics, --topic.");
            }
            return List.of();
        }

        private Map<TopicPartition, OffsetAndMetadata> getCommittedOffsets(String groupId) {
            try {
                return (Map)this.adminClient.listConsumerGroupOffsets(Map.of(groupId, new ListConsumerGroupOffsetsSpec()), this.withTimeoutMs(new ListConsumerGroupOffsetsOptions())).partitionsToOffsetAndMetadata(groupId).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private Map<TopicPartition, OffsetAndMetadata> prepareOffsetsToReset(String groupId, Collection<TopicPartition> partitionsToReset) {
            this.offsetsUtils.checkAllTopicPartitionsValid(partitionsToReset);
            if (this.opts.options.has(this.opts.resetToOffsetOpt)) {
                return this.offsetsUtils.resetToOffset(partitionsToReset);
            }
            if (this.opts.options.has(this.opts.resetToEarliestOpt)) {
                return this.offsetsUtils.resetToEarliest(partitionsToReset);
            }
            if (this.opts.options.has(this.opts.resetToLatestOpt)) {
                return this.offsetsUtils.resetToLatest(partitionsToReset);
            }
            if (this.opts.options.has(this.opts.resetShiftByOpt)) {
                Map<TopicPartition, OffsetAndMetadata> currentCommittedOffsets = this.getCommittedOffsets(groupId);
                return this.offsetsUtils.resetByShiftBy(partitionsToReset, currentCommittedOffsets);
            }
            if (this.opts.options.has(this.opts.resetToDatetimeOpt)) {
                return this.offsetsUtils.resetToDateTime(partitionsToReset);
            }
            if (this.opts.options.has(this.opts.resetByDurationOpt)) {
                return this.offsetsUtils.resetByDuration(partitionsToReset);
            }
            if (this.offsetsUtils.resetPlanFromFile().isPresent()) {
                return this.offsetsUtils.resetFromFile(groupId);
            }
            if (this.opts.options.has(this.opts.resetToCurrentOpt)) {
                Map<TopicPartition, OffsetAndMetadata> currentCommittedOffsets = this.getCommittedOffsets(groupId);
                return this.offsetsUtils.resetToCurrent(partitionsToReset, currentCommittedOffsets);
            }
            CommandLineUtils.printUsageAndExit((OptionParser)this.opts.parser, (String)String.format("Option '%s' requires one of the following scenarios: %s", this.opts.resetOffsetsOpt, this.opts.allResetOffsetScenarioOpts));
            return null;
        }

        String exportOffsetsToCsv(Map<String, Map<TopicPartition, OffsetAndMetadata>> assignments) {
            boolean isSingleGroupQuery = this.opts.options.valuesOf(this.opts.groupOpt).size() == 1;
            ObjectWriter csvWriter = isSingleGroupQuery ? CsvUtils.writerFor(CsvUtils.CsvRecordNoGroup.class) : CsvUtils.writerFor(CsvUtils.CsvRecordWithGroup.class);
            return assignments.entrySet().stream().flatMap(e -> {
                String groupId = (String)e.getKey();
                Map partitionInfo = (Map)e.getValue();
                return partitionInfo.entrySet().stream().map(e1 -> {
                    TopicPartition k = (TopicPartition)e1.getKey();
                    OffsetAndMetadata v = (OffsetAndMetadata)e1.getValue();
                    Object csvRecord = isSingleGroupQuery ? new CsvUtils.CsvRecordNoGroup(k.topic(), k.partition(), v.offset()) : new CsvUtils.CsvRecordWithGroup(groupId, k.topic(), k.partition(), v.offset());
                    try {
                        return csvWriter.writeValueAsString(csvRecord);
                    }
                    catch (JsonProcessingException err) {
                        throw new RuntimeException(err);
                    }
                });
            }).collect(Collectors.joining());
        }

        Map<String, Throwable> deleteGroups() {
            List groupIds = this.opts.options.has(this.opts.allGroupsOpt) ? this.listConsumerGroups() : this.opts.options.valuesOf(this.opts.groupOpt);
            Map groupsToDelete = this.adminClient.deleteConsumerGroups((Collection)groupIds, this.withTimeoutMs(new DeleteConsumerGroupsOptions())).deletedGroups();
            HashMap success = new HashMap();
            HashMap<String, Throwable> failed = new HashMap<String, Throwable>();
            groupsToDelete.forEach((g, f) -> {
                try {
                    f.get();
                    success.put(g, null);
                }
                catch (InterruptedException ie) {
                    failed.put((String)g, ie);
                }
                catch (ExecutionException e) {
                    failed.put((String)g, e.getCause());
                }
            });
            if (failed.isEmpty()) {
                System.out.println("Deletion of requested consumer groups (" + success.keySet().stream().map(group -> "'" + group + "'").collect(Collectors.joining(", ")) + ") was successful.");
            } else {
                ConsumerGroupCommand.printError("Deletion of some consumer groups failed:", Optional.empty());
                failed.forEach((group, error) -> System.out.println("* Group '" + group + "' could not be deleted due to: " + String.valueOf(error)));
                if (!success.isEmpty()) {
                    System.out.println("\nThese consumer groups were deleted successfully: " + success.keySet().stream().map(group -> "'" + group + "'").collect(Collectors.joining(", ")));
                }
            }
            failed.putAll(success);
            return failed;
        }
    }
}

