/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.util.TreeMap;
import javajs.api.GenericColor;
import javajs.util.CU;
import javajs.util.SB;
import jspecview.common.ColorParameters;
import jspecview.common.ScriptToken;
import jspecview.java.AwtParameters;
import jspecview.source.XMLParser;

public class DisplaySchemesProcessor {
    private final String newLine = System.getProperty("line.separator");
    private String fileName = "displaySchemes.xml";
    private TreeMap<String, ColorParameters> displaySchemes = new TreeMap();
    private XMLParser parser;

    public ColorParameters loadDefault() {
        AwtParameters awtParameters = (AwtParameters)new AwtParameters().setName("Default");
        awtParameters.displayFontName = "default";
        awtParameters.setColor(ScriptToken.TITLECOLOR, ColorParameters.BLACK);
        awtParameters.setColor(ScriptToken.UNITSCOLOR, ColorParameters.BLACK);
        awtParameters.setColor(ScriptToken.SCALECOLOR, ColorParameters.BLACK);
        awtParameters.setColor(ScriptToken.COORDINATESCOLOR, ColorParameters.BLACK);
        awtParameters.setColor(ScriptToken.PEAKTABCOLOR, ColorParameters.RED);
        awtParameters.setColor(ScriptToken.HIGHLIGHTCOLOR, ColorParameters.DARK_GRAY);
        awtParameters.setColor(ScriptToken.GRIDCOLOR, ColorParameters.BLACK);
        awtParameters.setColor(ScriptToken.PLOTCOLOR, ColorParameters.BLACK);
        awtParameters.setColor(ScriptToken.PLOTAREACOLOR, ColorParameters.WHITE);
        awtParameters.setColor(ScriptToken.BACKGROUNDCOLOR, ColorParameters.WHITE);
        awtParameters.setColor(ScriptToken.INTEGRALPLOTCOLOR, ColorParameters.RED);
        this.displaySchemes.put("Default", awtParameters);
        return awtParameters;
    }

    public ColorParameters getDefaultScheme() {
        ColorParameters colorParameters = this.displaySchemes.get("Default");
        if (colorParameters == null) {
            colorParameters = this.loadDefault();
        }
        return colorParameters;
    }

    public void store() throws Exception {
        this.serializeDisplaySchemes(new BufferedWriter(new FileWriter(this.fileName)));
    }

    public TreeMap<String, ColorParameters> getDisplaySchemes() {
        return this.displaySchemes;
    }

    public boolean load(String string) {
        boolean bl;
        this.fileName = string;
        InputStream inputStream = null;
        try {
            File file = new File(this.fileName);
            if (file.exists()) {
                inputStream = new FileInputStream(file);
                System.out.println("DisplaySchemeProcessor reading from " + file.getAbsolutePath());
            } else {
                System.out.println("DisplaySchemeProcessor could not find " + file.getAbsolutePath());
                URL uRL = this.getClass().getResource("resources/" + string);
                if (uRL != null) {
                    System.out.println("reading defaults from JAR resource " + uRL);
                } else {
                    System.out.println("DisplaySchemeProcessor reading from JAR!/jspecview/application/resources/" + this.fileName);
                }
                inputStream = this.getClass().getResourceAsStream("resources/" + string);
                if (inputStream == null) {
                    System.out.println("DisplaySchemeProcessor could not find resource");
                    return false;
                }
            }
            bl = this.load(new BufferedReader(new InputStreamReader(inputStream)));
        }
        catch (Exception exception) {
            System.out.println("DisplaySchemeProcessor ignored: " + exception.getMessage());
            return false;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    public boolean load(BufferedReader bufferedReader) throws Exception {
        this.parser = new XMLParser(bufferedReader);
        String string = "Default";
        ColorParameters colorParameters = null;
        String string2 = null;
        try {
            while (this.parser.hasNext()) {
                ScriptToken scriptToken;
                if (this.parser.nextEvent() != 1) continue;
                String string3 = this.parser.getTagName();
                if (string3.equals("displayschemes")) {
                    string = this.parser.getAttrValue("default");
                }
                if (string3.equals("displayscheme")) {
                    string2 = this.parser.getAttrValue("name");
                    System.out.print("\nDisplayScheme " + (String.valueOf(string2) + "              ").substring(0, 17));
                    colorParameters = (ColorParameters)new AwtParameters().setName(string2);
                    if (string2.equals(string)) {
                        colorParameters.isDefault = true;
                    }
                    this.displaySchemes.put(string2, colorParameters);
                }
                if (colorParameters == null) continue;
                if (string3.equals("font")) {
                    String string4 = this.parser.getAttrValue("face");
                    if (string4.length() > 0) {
                        colorParameters.displayFontName = string4;
                    }
                    System.out.print((String.valueOf(string4) + "                         ").substring(0, 23));
                    continue;
                }
                if (string3.equals("coordinateColor")) {
                    string3 = "coordinatesColor";
                }
                if ((scriptToken = ScriptToken.getScriptToken(string3)) == ScriptToken.UNKNOWN) continue;
                GenericColor genericColor = this.getColor(colorParameters);
                if (genericColor == null) {
                    String string5;
                    switch (scriptToken) {
                        default: {
                            string5 = null;
                            break;
                        }
                        case TITLECOLOR: {
                            string5 = "#0000ff";
                            break;
                        }
                        case COORDINATESCOLOR: {
                            string5 = "#ff0000";
                            break;
                        }
                        case PEAKTABCOLOR: {
                            string5 = "#ff0000";
                            break;
                        }
                        case HIGHLIGHTCOLOR: {
                            string5 = "#808080";
                            break;
                        }
                        case SCALECOLOR: {
                            string5 = "#660000";
                            break;
                        }
                        case UNITSCOLOR: {
                            string5 = "#ff0000";
                            break;
                        }
                        case GRIDCOLOR: {
                            string5 = "#4e4c4c";
                            break;
                        }
                        case PLOTCOLOR: {
                            string5 = "#ff9900";
                            break;
                        }
                        case PLOTAREACOLOR: {
                            string5 = "#333333";
                            break;
                        }
                        case BACKGROUNDCOLOR: {
                            string5 = "#c0c0c0";
                        }
                    }
                    if (string5 != null) {
                        genericColor = colorParameters.getColorFromString(string5);
                    }
                }
                if (genericColor == null) continue;
                colorParameters.setColor(scriptToken, genericColor);
                System.out.print(" " + (Object)((Object)scriptToken) + " " + genericColor);
            }
            System.out.println("");
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private GenericColor getColor(ColorParameters colorParameters) {
        String string = this.parser.getAttrValueLC("hex");
        return string.length() == 0 || string.equals("default") ? null : colorParameters.getColorFromString(string);
    }

    public void serializeDisplaySchemes(Writer writer) throws Exception {
        if (this.displaySchemes.size() == 0) {
            return;
        }
        SB sB = new SB();
        String string = "";
        for (ColorParameters object2 : this.displaySchemes.values()) {
            if (object2.isDefault) {
                string = object2.name;
            }
            sB.append("\t<displayScheme name=\"" + object2.name + "\">").append(this.newLine);
            sB.append("\t\t<font face=\"" + object2.displayFontName + "\"/>").append(this.newLine);
            this.writeColor(sB, object2, "titleColor", ScriptToken.TITLECOLOR);
            this.writeColor(sB, object2, "scaleColor", ScriptToken.SCALECOLOR);
            this.writeColor(sB, object2, "unitsColor", ScriptToken.UNITSCOLOR);
            this.writeColor(sB, object2, "coordinatesColor", ScriptToken.COORDINATESCOLOR);
            this.writeColor(sB, object2, "highlightColor", ScriptToken.HIGHLIGHTCOLOR);
            this.writeColor(sB, object2, "peakTabColor", ScriptToken.PEAKTABCOLOR);
            this.writeColor(sB, object2, "gridColor", ScriptToken.GRIDCOLOR);
            this.writeColor(sB, object2, "plotColor", ScriptToken.PLOTCOLOR);
            this.writeColor(sB, object2, "plotAreaColor", ScriptToken.PLOTAREACOLOR);
            this.writeColor(sB, object2, "backgroundColor", ScriptToken.BACKGROUNDCOLOR);
            sB.append("\t</displayScheme>").append(this.newLine);
        }
        sB.append("</displaySchemes>");
        SB sB2 = new SB();
        sB2.append("<?xml version=\"1.0\"?>" + this.newLine);
        sB2.append("<displaySchemes default=\"" + string + "\">" + this.newLine);
        sB2.append(sB.toString());
        writer.write(sB2.toString());
        writer.flush();
        writer.close();
    }

    private void writeColor(SB sB, ColorParameters colorParameters, String string, ScriptToken scriptToken) {
        sB.append("\t\t<" + string + " hex=\"" + CU.toRGBHexString(colorParameters.getElementColor(scriptToken)) + "\"/>").append(this.newLine);
    }

    public boolean loadDefaultXML() {
        return this.load("displaySchemes.xml");
    }
}

