/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import shadow.bundletool.com.android.io.IAbstractFile;
import shadow.bundletool.com.android.io.StreamException;

public class FileWrapper
extends File
implements IAbstractFile {
    private static final long serialVersionUID = 1L;

    public FileWrapper(File file2) {
        super(file2.getAbsolutePath());
    }

    public FileWrapper(File parent, String child) {
        super(parent, child);
    }

    @Override
    public InputStream getContents() throws StreamException {
        try {
            return new FileInputStream(this);
        }
        catch (FileNotFoundException e15) {
            throw new StreamException(e15, this, StreamException.Error.FILENOTFOUND);
        }
    }

    @Override
    public void setContents(InputStream source) throws StreamException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this);
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = source.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
        }
        catch (IOException e15) {
            throw new StreamException(e15, this);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e16) {
                    throw new StreamException(e16, this);
                }
            }
        }
    }

    @Override
    public OutputStream getOutputStream() throws StreamException {
        try {
            return new FileOutputStream(this);
        }
        catch (FileNotFoundException e15) {
            throw new StreamException(e15, this);
        }
    }

    @Override
    public String getOsLocation() {
        return this.getAbsolutePath();
    }

    @Override
    public boolean exists() {
        return this.isFile();
    }
}

