/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.bundletool.com.android.ddmlib.MultiLineReceiver;
import shadow.bundletool.com.android.ddmlib.ServiceInfo;

public class ServiceReceiver
extends MultiLineReceiver {
    private static final String LOG_TAG = "ServiceReceiver";
    private static final Pattern serviceLinePattern = Pattern.compile("[\\d+]\\s+(\\S+):\\s+\\[(.*?)]");
    private final LinkedHashMap<String, ServiceInfo> runningServices = new LinkedHashMap();

    public Map<String, ServiceInfo> getRunningServices() {
        return this.runningServices;
    }

    @Override
    public void processNewLines(String[] lines) {
        for (int n15 = 1; n15 <= lines.length - 1; ++n15) {
            String line = lines[n15];
            Matcher matcher = serviceLinePattern.matcher(line);
            if (!matcher.find()) {
                throw new RuntimeException("Unable to parse service information from: " + line);
            }
            String serviceName = matcher.group(1);
            String servicePackage = matcher.group(2);
            ServiceInfo serviceInfo = new ServiceInfo(serviceName, servicePackage);
            this.runningServices.put(serviceName, serviceInfo);
        }
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public void clear() {
        this.runningServices.clear();
    }
}

