/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

@ParametersAreNonnullByDefault
public class CodeAreaUI
extends TextUI
implements ViewFactory {
    private static final Position.Bias[] discardBias = new Position.Bias[1];
    transient JTextComponent editor;
    transient RootView rootView = new RootView();
    private static final EditorKit defaultKit = new DefaultEditorKit();

    @Nonnull
    public static ComponentUI createUI(JComponent c15) {
        return new CodeAreaUI();
    }

    @Override
    public void installUI(JComponent c15) {
        if (c15 instanceof JTextComponent) {
            this.editor = (JTextComponent)c15;
        }
    }

    @Override
    public void uninstallUI(JComponent c15) {
    }

    @Override
    @Nullable
    public View create(Element elem) {
        return null;
    }

    @Override
    @Deprecated
    public Rectangle modelToView(JTextComponent tc5, int pos) throws BadLocationException {
        return this.modelToView(tc5, pos, Position.Bias.Forward);
    }

    @Override
    @Deprecated
    public Rectangle modelToView(JTextComponent tc5, int pos, Position.Bias bias) throws BadLocationException {
        return (Rectangle)this.modelToView(tc5, pos, bias, false);
    }

    @Override
    public Rectangle2D modelToView2D(JTextComponent tc5, int pos, Position.Bias bias) throws BadLocationException {
        return this.modelToView(tc5, pos, bias, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Rectangle2D modelToView(JTextComponent tc5, int pos, Position.Bias bias, boolean useFPAPI) throws BadLocationException {
        Document doc = this.editor.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            Rectangle alloc = this.getVisibleEditorRect();
            if (alloc != null) {
                this.rootView.setSize(alloc.width, alloc.height);
                Shape s15 = this.rootView.modelToView(pos, alloc, bias);
                if (s15 != null) {
                    Rectangle2D rectangle2D = useFPAPI ? s15.getBounds2D() : s15.getBounds();
                    return rectangle2D;
                }
            }
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        return null;
    }

    @Override
    public int viewToModel(JTextComponent tc5, Point pt4) {
        return this.viewToModel(tc5, pt4, discardBias);
    }

    @Override
    @Deprecated
    public int viewToModel(JTextComponent tc5, Point pt4, Position.Bias[] biasReturn) {
        return this.viewToModel(tc5, pt4.x, pt4.y, biasReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int viewToModel(JTextComponent tc5, float x15, float y15, Position.Bias[] biasReturn) {
        int offs = -1;
        Document doc = this.editor.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            Rectangle alloc = this.getVisibleEditorRect();
            if (alloc != null) {
                this.rootView.setSize(alloc.width, alloc.height);
                offs = this.rootView.viewToModel(x15, y15, alloc, biasReturn);
            }
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        return offs;
    }

    protected Rectangle getVisibleEditorRect() {
        Rectangle alloc = this.editor.getBounds();
        if (alloc.width > 0 && alloc.height > 0) {
            alloc.y = 0;
            alloc.x = 0;
            Insets insets = this.editor.getInsets();
            alloc.x += insets.left;
            alloc.y += insets.top;
            alloc.width -= insets.left + insets.right;
            alloc.height -= insets.top + insets.bottom;
            return alloc;
        }
        return null;
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent tc5, int pos, Position.Bias b15, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return -1;
    }

    @Override
    public void damageRange(JTextComponent tc5, int p05, int p15) {
        this.damageRange(tc5, p05, p15, Position.Bias.Forward, Position.Bias.Backward);
    }

    @Override
    public void damageRange(JTextComponent t15, int p05, int p15, Position.Bias firstBias, Position.Bias secondBias) {
    }

    @Override
    public EditorKit getEditorKit(JTextComponent t15) {
        return defaultKit;
    }

    @Override
    public View getRootView(JTextComponent t15) {
        return this.rootView;
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            super(null);
        }

        void setView(View v15) {
            View oldView = this.view;
            this.view = null;
            if (oldView != null) {
                oldView.setParent(null);
            }
            if (v15 != null) {
                v15.setParent(this);
            }
            this.view = v15;
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (this.view != null) {
                return this.view.getPreferredSpan(axis);
            }
            return 10.0f;
        }

        @Override
        public float getMinimumSpan(int axis) {
            if (this.view != null) {
                return this.view.getMinimumSpan(axis);
            }
            return 10.0f;
        }

        @Override
        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        @Override
        public void preferenceChanged(View child, boolean width, boolean height) {
            CodeAreaUI.this.editor.revalidate();
        }

        @Override
        public float getAlignment(int axis) {
            if (this.view != null) {
                return this.view.getAlignment(axis);
            }
            return 0.0f;
        }

        @Override
        public void paint(Graphics g15, Shape allocation) {
            if (this.view != null) {
                Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
                this.setSize(alloc.width, alloc.height);
                this.view.paint(g15, allocation);
            }
        }

        @Override
        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n15) {
            return this.view;
        }

        @Override
        public int getViewIndex(int pos, Position.Bias b15) {
            return 0;
        }

        @Override
        public Shape getChildAllocation(int index, Shape a15) {
            return a15;
        }

        @Override
        public Shape modelToView(int pos, Shape a15, Position.Bias b15) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(pos, a15, b15);
            }
            return null;
        }

        @Override
        public Shape modelToView(int p05, Position.Bias b05, int p15, Position.Bias b15, Shape a15) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(p05, b05, p15, b15, a15);
            }
            return null;
        }

        @Override
        public int viewToModel(float x15, float y15, Shape a15, Position.Bias[] bias) {
            if (this.view != null) {
                int retValue = this.view.viewToModel(x15, y15, a15, bias);
                return retValue;
            }
            return -1;
        }

        @Override
        public int getNextVisualPositionFrom(int pos, Position.Bias b15, Shape a15, int direction, Position.Bias[] biasRet) throws BadLocationException {
            if (pos < -1 || pos > this.getDocument().getLength()) {
                throw new BadLocationException("invalid position", pos);
            }
            if (this.view != null) {
                int nextPos = this.view.getNextVisualPositionFrom(pos, b15, a15, direction, biasRet);
                if (nextPos != -1) {
                    pos = nextPos;
                } else {
                    biasRet[0] = b15;
                }
            }
            return pos;
        }

        @Override
        public void insertUpdate(DocumentEvent e15, Shape a15, ViewFactory f15) {
            if (this.view != null) {
                this.view.insertUpdate(e15, a15, f15);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e15, Shape a15, ViewFactory f15) {
            if (this.view != null) {
                this.view.removeUpdate(e15, a15, f15);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e15, Shape a15, ViewFactory f15) {
            if (this.view != null) {
                this.view.changedUpdate(e15, a15, f15);
            }
        }

        @Override
        public Document getDocument() {
            return CodeAreaUI.this.editor.getDocument();
        }

        @Override
        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        @Override
        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return CodeAreaUI.this.editor.getDocument().getDefaultRootElement();
        }

        public View breakView(int axis, float len, Shape a15) {
            throw new Error("Can't break root view");
        }

        @Override
        public int getResizeWeight(int axis) {
            if (this.view != null) {
                return this.view.getResizeWeight(axis);
            }
            return 0;
        }

        @Override
        public void setSize(float width, float height) {
            if (this.view != null) {
                this.view.setSize(width, height);
            }
        }

        @Override
        public Container getContainer() {
            return CodeAreaUI.this.editor;
        }

        @Override
        public ViewFactory getViewFactory() {
            EditorKit kit = CodeAreaUI.this.getEditorKit(CodeAreaUI.this.editor);
            ViewFactory f15 = kit.getViewFactory();
            if (f15 != null) {
                return f15;
            }
            return CodeAreaUI.this;
        }
    }
}

