/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class UnicodeUnescaper
extends CharSequenceTranslator {
    @Override
    public int translate(CharSequence input, int index, Writer writer) throws IOException {
        if (input.charAt(index) == '\\' && index + 1 < input.length() && input.charAt(index + 1) == 'u') {
            int i15 = 2;
            while (index + i15 < input.length() && input.charAt(index + i15) == 'u') {
                ++i15;
            }
            if (index + i15 < input.length() && input.charAt(index + i15) == '+') {
                ++i15;
            }
            if (index + i15 + 4 <= input.length()) {
                CharSequence unicode = input.subSequence(index + i15, index + i15 + 4);
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    writer.write((char)value);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Unable to parse unicode value: " + unicode, nfe);
                }
                return i15 + 4;
            }
            throw new IllegalArgumentException("Less than 4 hex digits in unicode value: '" + input.subSequence(index, input.length()) + "' due to end of CharSequence");
        }
        return 0;
    }
}

