/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplateWriter;

public class AutoIndentWriter
implements StringTemplateWriter {
    protected List indents = new ArrayList();
    protected int[] anchors = new int[10];
    protected int anchors_sp = -1;
    protected String newline;
    protected Writer out = null;
    protected boolean atStartOfLine = true;
    protected int charPosition = 0;
    protected int lineWidth = -1;
    protected int charPositionOfStartOfExpr = 0;

    public AutoIndentWriter(Writer out, String newline) {
        this.out = out;
        this.indents.add(null);
        this.newline = newline;
    }

    public AutoIndentWriter(Writer out) {
        this(out, System.getProperty("line.separator"));
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void pushIndentation(String indent) {
        int lastAnchor = 0;
        int indentWidth = this.getIndentationWidth();
        if (this.anchors_sp >= 0 && this.anchors[this.anchors_sp] > indentWidth) {
            lastAnchor = this.anchors[this.anchors_sp];
            StringBuffer buf = this.getIndentString(lastAnchor - indentWidth);
            if (indent != null) {
                buf.append(indent);
            }
            this.indents.add(buf.toString());
            return;
        }
        this.indents.add(indent);
    }

    public String popIndentation() {
        return (String)this.indents.remove(this.indents.size() - 1);
    }

    public void pushAnchorPoint() {
        if (this.anchors_sp + 1 >= this.anchors.length) {
            int[] a15 = new int[this.anchors.length * 2];
            System.arraycopy(this.anchors, 0, a15, 0, this.anchors.length - 1);
            this.anchors = a15;
        }
        ++this.anchors_sp;
        this.anchors[this.anchors_sp] = this.charPosition;
    }

    public void popAnchorPoint() {
        --this.anchors_sp;
    }

    public int getIndentationWidth() {
        int n15 = 0;
        for (int i15 = 0; i15 < this.indents.size(); ++i15) {
            String ind = (String)this.indents.get(i15);
            if (ind == null) continue;
            n15 += ind.length();
        }
        return n15;
    }

    public int write(String str) throws IOException {
        int n15 = 0;
        for (int i15 = 0; i15 < str.length(); ++i15) {
            char c15 = str.charAt(i15);
            if (c15 == '\r' || c15 == '\n') {
                this.atStartOfLine = true;
                this.charPosition = -1;
                this.out.write(this.newline);
                this.charPosition += (n15 += this.newline.length());
                if (c15 != '\r' || i15 + 1 >= str.length() || str.charAt(i15 + 1) != '\n') continue;
                ++i15;
                continue;
            }
            if (this.atStartOfLine) {
                n15 += this.indent();
                this.atStartOfLine = false;
            }
            ++n15;
            this.out.write(c15);
            ++this.charPosition;
        }
        return n15;
    }

    public int writeSeparator(String str) throws IOException {
        return this.write(str);
    }

    public int write(String str, String wrap) throws IOException {
        int n15 = this.writeWrapSeparator(wrap);
        return n15 + this.write(str);
    }

    public int writeWrapSeparator(String wrap) throws IOException {
        int n15 = 0;
        if (this.lineWidth != -1 && wrap != null && !this.atStartOfLine && this.charPosition >= this.lineWidth) {
            for (int i15 = 0; i15 < wrap.length(); ++i15) {
                char c15 = wrap.charAt(i15);
                if (c15 == '\n') {
                    ++n15;
                    this.out.write(c15);
                    this.charPosition = 0;
                    n15 += this.indent();
                    continue;
                }
                ++n15;
                this.out.write(c15);
                ++this.charPosition;
            }
        }
        return n15;
    }

    public int indent() throws IOException {
        int n15 = 0;
        for (int i15 = 0; i15 < this.indents.size(); ++i15) {
            String ind = (String)this.indents.get(i15);
            if (ind == null) continue;
            n15 += ind.length();
            this.out.write(ind);
        }
        this.charPosition += n15;
        return n15;
    }

    public int indent(int spaces) throws IOException {
        for (int i15 = 1; i15 <= spaces; ++i15) {
            this.out.write(32);
        }
        this.charPosition += spaces;
        return spaces;
    }

    protected StringBuffer getIndentString(int spaces) {
        StringBuffer buf = new StringBuffer();
        for (int i15 = 1; i15 <= spaces; ++i15) {
            buf.append(' ');
        }
        return buf;
    }
}

