/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

public class Interval {
    public static final int INTERVAL_POOL_MAX_VALUE = 1000;
    static Interval[] cache = new Interval[1001];
    public int a;
    public int b;
    public static int creates = 0;
    public static int misses = 0;
    public static int hits = 0;
    public static int outOfRange = 0;

    public Interval(int a15, int b15) {
        this.a = a15;
        this.b = b15;
    }

    public static Interval create(int a15, int b15) {
        if (a15 != b15 || a15 < 0 || a15 > 1000) {
            return new Interval(a15, b15);
        }
        if (cache[a15] == null) {
            Interval.cache[a15] = new Interval(a15, a15);
        }
        return cache[a15];
    }

    public boolean equals(Object o15) {
        if (o15 == null) {
            return false;
        }
        Interval other = (Interval)o15;
        return this.a == other.a && this.b == other.b;
    }

    public boolean startsBeforeDisjoint(Interval other) {
        return this.a < other.a && this.b < other.a;
    }

    public boolean startsBeforeNonDisjoint(Interval other) {
        return this.a <= other.a && this.b >= other.a;
    }

    public boolean startsAfter(Interval other) {
        return this.a > other.a;
    }

    public boolean startsAfterDisjoint(Interval other) {
        return this.a > other.b;
    }

    public boolean startsAfterNonDisjoint(Interval other) {
        return this.a > other.a && this.a <= other.b;
    }

    public boolean disjoint(Interval other) {
        return this.startsBeforeDisjoint(other) || this.startsAfterDisjoint(other);
    }

    public boolean adjacent(Interval other) {
        return this.a == other.b + 1 || this.b == other.a - 1;
    }

    public boolean properlyContains(Interval other) {
        return other.a >= this.a && other.b <= this.b;
    }

    public Interval union(Interval other) {
        return Interval.create(Math.min(this.a, other.a), Math.max(this.b, other.b));
    }

    public Interval intersection(Interval other) {
        return Interval.create(Math.max(this.a, other.a), Math.min(this.b, other.b));
    }

    public Interval differenceNotProperlyContained(Interval other) {
        Interval diff = null;
        if (other.startsBeforeNonDisjoint(this)) {
            diff = Interval.create(Math.max(this.a, other.b + 1), this.b);
        } else if (other.startsAfterNonDisjoint(this)) {
            diff = Interval.create(this.a, other.a - 1);
        }
        return diff;
    }

    public String toString() {
        return this.a + ".." + this.b;
    }
}

