/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides$$Lambda$3;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtil;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorEquivalenceForOverrides {
    @NotNull
    public static final DescriptorEquivalenceForOverrides INSTANCE = new DescriptorEquivalenceForOverrides();

    private DescriptorEquivalenceForOverrides() {
    }

    public final boolean areEquivalent(@Nullable DeclarationDescriptor a15, @Nullable DeclarationDescriptor b15, boolean allowCopiesFromTheSameDeclaration, boolean distinguishExpectsAndNonExpects) {
        return a15 instanceof ClassDescriptor && b15 instanceof ClassDescriptor ? this.areClassesEquivalent((ClassDescriptor)a15, (ClassDescriptor)b15) : (a15 instanceof TypeParameterDescriptor && b15 instanceof TypeParameterDescriptor ? DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, (TypeParameterDescriptor)a15, (TypeParameterDescriptor)b15, allowCopiesFromTheSameDeclaration, null, 8, null) : (a15 instanceof CallableDescriptor && b15 instanceof CallableDescriptor ? DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$default(this, (CallableDescriptor)a15, (CallableDescriptor)b15, allowCopiesFromTheSameDeclaration, distinguishExpectsAndNonExpects, false, KotlinTypeRefiner.Default.INSTANCE, 16, null) : (a15 instanceof PackageFragmentDescriptor && b15 instanceof PackageFragmentDescriptor ? Intrinsics.areEqual(((PackageFragmentDescriptor)a15).getFqName(), ((PackageFragmentDescriptor)b15).getFqName()) : Intrinsics.areEqual(a15, b15))));
    }

    public static /* synthetic */ boolean areEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, boolean bl4, boolean bl5, int n15, Object object) {
        if ((n15 & 8) != 0) {
            bl5 = true;
        }
        return descriptorEquivalenceForOverrides.areEquivalent(declarationDescriptor, declarationDescriptor2, bl4, bl5);
    }

    private final boolean areClassesEquivalent(ClassDescriptor a15, ClassDescriptor b15) {
        return Intrinsics.areEqual(a15.getTypeConstructor(), b15.getTypeConstructor());
    }

    @JvmOverloads
    public final boolean areTypeParametersEquivalent(@NotNull TypeParameterDescriptor a15, @NotNull TypeParameterDescriptor b15, boolean allowCopiesFromTheSameDeclaration, @NotNull Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables) {
        Intrinsics.checkNotNullParameter(a15, "a");
        Intrinsics.checkNotNullParameter(b15, "b");
        Intrinsics.checkNotNullParameter(equivalentCallables, "equivalentCallables");
        if (Intrinsics.areEqual(a15, b15)) {
            return true;
        }
        if (Intrinsics.areEqual(a15.getContainingDeclaration(), b15.getContainingDeclaration())) {
            return false;
        }
        if (!this.ownersEquivalent(a15, b15, equivalentCallables, allowCopiesFromTheSameDeclaration)) {
            return false;
        }
        return a15.getIndex() == b15.getIndex();
    }

    public static /* synthetic */ boolean areTypeParametersEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, boolean bl4, Function2 function2, int n15, Object object) {
        if ((n15 & 8) != 0) {
            function2 = DescriptorEquivalenceForOverrides$$Lambda$0.INSTANCE;
        }
        return descriptorEquivalenceForOverrides.areTypeParametersEquivalent(typeParameterDescriptor, typeParameterDescriptor2, bl4, function2);
    }

    private final SourceElement singleSource(CallableDescriptor $this$singleSource) {
        DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides = this;
        while (true) {
            if (!($this$singleSource instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)$this$singleSource).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                return $this$singleSource.getSource();
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)$this$singleSource).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (callableMemberDescriptor == null) break;
            DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides2 = descriptorEquivalenceForOverrides;
            CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
            descriptorEquivalenceForOverrides = descriptorEquivalenceForOverrides2;
            $this$singleSource = callableMemberDescriptor2;
        }
        return null;
    }

    public final boolean areCallableDescriptorsEquivalent(@NotNull CallableDescriptor a15, @NotNull CallableDescriptor b15, boolean allowCopiesFromTheSameDeclaration, boolean distinguishExpectsAndNonExpects, boolean ignoreReturnType, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(a15, "a");
        Intrinsics.checkNotNullParameter(b15, "b");
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        if (Intrinsics.areEqual(a15, b15)) {
            return true;
        }
        if (!Intrinsics.areEqual(a15.getName(), b15.getName())) {
            return false;
        }
        if (distinguishExpectsAndNonExpects && a15 instanceof MemberDescriptor && b15 instanceof MemberDescriptor && ((MemberDescriptor)((Object)a15)).isExpect() != ((MemberDescriptor)((Object)b15)).isExpect()) {
            return false;
        }
        if (Intrinsics.areEqual(a15.getContainingDeclaration(), b15.getContainingDeclaration())) {
            if (!allowCopiesFromTheSameDeclaration) {
                return false;
            }
            if (!Intrinsics.areEqual(this.singleSource(a15), this.singleSource(b15))) {
                return false;
            }
        }
        if (DescriptorUtils.isLocal(a15) || DescriptorUtils.isLocal(b15)) {
            return false;
        }
        if (!this.ownersEquivalent(a15, b15, DescriptorEquivalenceForOverrides$$Lambda$1.INSTANCE, allowCopiesFromTheSameDeclaration)) {
            return false;
        }
        CallableDescriptor callableDescriptor = b15;
        CallableDescriptor callableDescriptor2 = a15;
        boolean bl4 = allowCopiesFromTheSameDeclaration;
        OverridingUtil overridingUtil = OverridingUtil.create(kotlinTypeRefiner, new DescriptorEquivalenceForOverrides$$Lambda$2(bl4, callableDescriptor2, callableDescriptor));
        Intrinsics.checkNotNullExpressionValue(overridingUtil, "create(...)");
        OverridingUtil overridingUtil2 = overridingUtil;
        return overridingUtil2.isOverridableBy(a15, b15, null, !ignoreReturnType).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE && overridingUtil2.isOverridableBy(b15, a15, null, !ignoreReturnType).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
    }

    public static /* synthetic */ boolean areCallableDescriptorsEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, boolean bl4, boolean bl5, boolean bl6, KotlinTypeRefiner kotlinTypeRefiner, int n15, Object object) {
        if ((n15 & 8) != 0) {
            bl5 = true;
        }
        if ((n15 & 0x10) != 0) {
            bl6 = false;
        }
        return descriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent(callableDescriptor, callableDescriptor2, bl4, bl5, bl6, kotlinTypeRefiner);
    }

    private final boolean ownersEquivalent(DeclarationDescriptor a15, DeclarationDescriptor b15, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables, boolean allowCopiesFromTheSameDeclaration) {
        DeclarationDescriptor aOwner = a15.getContainingDeclaration();
        DeclarationDescriptor bOwner = b15.getContainingDeclaration();
        return aOwner instanceof CallableMemberDescriptor || bOwner instanceof CallableMemberDescriptor ? equivalentCallables.invoke(aOwner, bOwner) : DescriptorEquivalenceForOverrides.areEquivalent$default(this, aOwner, bOwner, allowCopiesFromTheSameDeclaration, false, 8, null);
    }

    @JvmOverloads
    public final boolean areTypeParametersEquivalent(@NotNull TypeParameterDescriptor a15, @NotNull TypeParameterDescriptor b15, boolean allowCopiesFromTheSameDeclaration) {
        Intrinsics.checkNotNullParameter(a15, "a");
        Intrinsics.checkNotNullParameter(b15, "b");
        return DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, a15, b15, allowCopiesFromTheSameDeclaration, null, 8, null);
    }

    private static final boolean areTypeParametersEquivalent$lambda$0(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return false;
    }

    private static final boolean areCallableDescriptorsEquivalent$lambda$1$0(CallableDescriptor $a, CallableDescriptor $b, DeclarationDescriptor x15, DeclarationDescriptor y15) {
        return Intrinsics.areEqual(x15, $a) && Intrinsics.areEqual(y15, $b);
    }

    private static final boolean areCallableDescriptorsEquivalent$lambda$0(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return false;
    }

    private static final boolean areCallableDescriptorsEquivalent$lambda$1(boolean $allowCopiesFromTheSameDeclaration, CallableDescriptor $a, CallableDescriptor $b, TypeConstructor c15, TypeConstructor c25) {
        Intrinsics.checkNotNullParameter(c15, "c1");
        Intrinsics.checkNotNullParameter(c25, "c2");
        if (Intrinsics.areEqual(c15, c25)) {
            return true;
        }
        ClassifierDescriptor d15 = c15.getDeclarationDescriptor();
        ClassifierDescriptor d25 = c25.getDeclarationDescriptor();
        if (!(d15 instanceof TypeParameterDescriptor) || !(d25 instanceof TypeParameterDescriptor)) {
            return false;
        }
        CallableDescriptor callableDescriptor = $b;
        CallableDescriptor callableDescriptor2 = $a;
        return INSTANCE.areTypeParametersEquivalent((TypeParameterDescriptor)d15, (TypeParameterDescriptor)d25, $allowCopiesFromTheSameDeclaration, new DescriptorEquivalenceForOverrides$$Lambda$3(callableDescriptor2, callableDescriptor));
    }

    static /* synthetic */ boolean accessor$DescriptorEquivalenceForOverrides$lambda0(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$lambda$0(declarationDescriptor, declarationDescriptor2);
    }

    static /* synthetic */ boolean accessor$DescriptorEquivalenceForOverrides$lambda1(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$lambda$0(declarationDescriptor, declarationDescriptor2);
    }

    static /* synthetic */ boolean accessor$DescriptorEquivalenceForOverrides$lambda2(boolean bl4, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, TypeConstructor typeConstructor2, TypeConstructor typeConstructor3) {
        return DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$lambda$1(bl4, callableDescriptor, callableDescriptor2, typeConstructor2, typeConstructor3);
    }

    static /* synthetic */ boolean accessor$DescriptorEquivalenceForOverrides$lambda3(CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$lambda$1$0(callableDescriptor, callableDescriptor2, declarationDescriptor, declarationDescriptor2);
    }
}

