/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.apkm;

import jadx.api.JadxDecompiler;
import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.JadxPluginContext;
import jadx.api.plugins.JadxPluginInfo;
import jadx.plugins.input.apkm.ApkmCustomCodeInput;
import jadx.plugins.input.apkm.ApkmCustomResourcesLoader;
import jadx.plugins.input.dex.DexInputPlugin;
import jadx.zip.ZipReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Ljadx/plugins/input/apkm/ApkmInputPlugin;", "Ljadx/api/plugins/JadxPlugin;", "<init>", "()V", "getPluginInfo", "Ljadx/api/plugins/JadxPluginInfo;", "init", "", "context", "Ljadx/api/plugins/JadxPluginContext;", "jadx-apkm-input"})
public final class ApkmInputPlugin
implements JadxPlugin {
    @Override
    @NotNull
    public JadxPluginInfo getPluginInfo() {
        return new JadxPluginInfo("apkm-input", "APKM Input", "Load .apkm files");
    }

    @Override
    public void init(@NotNull JadxPluginContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        DexInputPlugin dexInputPlugin = context.plugins().getInstance(DexInputPlugin.class);
        Intrinsics.checkNotNull(dexInputPlugin);
        ZipReader zipReader = context.getZipReader();
        Intrinsics.checkNotNullExpressionValue(zipReader, "getZipReader(...)");
        context.addCodeInput(new ApkmCustomCodeInput(dexInputPlugin, zipReader));
        JadxDecompiler jadxDecompiler = context.getDecompiler();
        ZipReader zipReader2 = context.getZipReader();
        Intrinsics.checkNotNullExpressionValue(zipReader2, "getZipReader(...)");
        jadxDecompiler.addCustomResourcesLoader(new ApkmCustomResourcesLoader(zipReader2));
    }
}

