/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab;

import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.jobs.SilentTask;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.codearea.EditorViewState;
import jadx.gui.ui.codearea.SmaliArea;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.panel.FontPanel;
import jadx.gui.ui.panel.HtmlPanel;
import jadx.gui.ui.panel.IViewStateSupport;
import jadx.gui.ui.panel.ImagePanel;
import jadx.gui.ui.tab.ITabStatesListener;
import jadx.gui.ui.tab.TabBlueprint;
import jadx.gui.ui.tab.TabComponent;
import jadx.gui.ui.tab.TabsController;
import jadx.gui.ui.tab.dnd.TabDndController;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.UiUtils;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabbedPane
extends JTabbedPane
implements ITabStatesListener {
    private static final long serialVersionUID = -8833600618794570904L;
    private static final Logger LOG = LoggerFactory.getLogger(TabbedPane.class);
    private final transient MainWindow mainWindow;
    private final transient TabsController controller;
    private final transient Map<JNode, ContentPanel> tabsMap = new HashMap<JNode, ContentPanel>();
    private transient ContentPanel curTab;
    private transient ContentPanel lastTab;
    private transient TabDndController dnd;

    public TabbedPane(MainWindow window, TabsController controller) {
        this.mainWindow = window;
        this.controller = controller;
        controller.addListener(this);
        this.setTabLayoutPolicy(1);
        MouseAdapter clickAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e15) {
                int tabIndex = TabbedPane.this.indexAtLocation(e15.getX(), e15.getY());
                if (tabIndex == -1 || tabIndex > TabbedPane.this.getTabCount()) {
                    return;
                }
                TabComponent tab = (TabComponent)TabbedPane.this.getTabComponentAt(tabIndex);
                tab.dispatchEvent(e15);
            }
        };
        this.addMouseListener(clickAdapter);
        this.addMouseWheelListener(event -> {
            if (this.dnd != null && this.dnd.isDragging()) {
                return;
            }
            int direction = event.getWheelRotation();
            if (this.getTabCount() == 0 || direction == 0) {
                return;
            }
            direction = direction < 0 ? -1 : 1;
            int index = this.getSelectedIndex();
            int maxIndex = this.getTabCount() - 1;
            index += direction;
            index = Math.max(0, Math.min(maxIndex, index));
            try {
                this.setSelectedIndex(index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        });
        this.interceptTabKey();
        this.interceptCloseKey();
        this.enableSwitchingTabs();
    }

    private void interceptTabKey() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){
            private static final int ctrlDown = 128;
            private long ctrlInterval = 0L;

            @Override
            public boolean dispatchKeyEvent(KeyEvent e15) {
                boolean isReleased;
                long cur = System.currentTimeMillis();
                if (!FocusManager.isActive()) {
                    return false;
                }
                int code = e15.getKeyCode();
                boolean consume = code == 9;
                boolean bl4 = isReleased = e15.getID() == 402;
                if (isReleased) {
                    if (code == 17) {
                        this.ctrlInterval = cur;
                    } else if (code == 9) {
                        boolean doSwitch = false;
                        if ((e15.getModifiersEx() & 0x80) != 0) {
                            doSwitch = TabbedPane.this.lastTab != null && TabbedPane.this.getTabCount() > 1;
                        } else {
                            this.ctrlInterval = cur - this.ctrlInterval;
                            if (this.ctrlInterval <= 90L) {
                                boolean bl5 = doSwitch = TabbedPane.this.lastTab != null && TabbedPane.this.getTabCount() > 1;
                            }
                        }
                        if (doSwitch) {
                            TabbedPane.this.selectTab(TabbedPane.this.lastTab);
                        }
                    }
                } else if (consume && (e15.getModifiersEx() & 0x80) == 0 && TabbedPane.this.curTab instanceof ClassCodeContentPanel) {
                    ((ClassCodeContentPanel)TabbedPane.this.curTab).switchPanel();
                }
                return consume;
            }
        });
    }

    private void interceptCloseKey() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){
            private static final int closeKey = 87;
            private boolean canClose = true;

            @Override
            public boolean dispatchKeyEvent(KeyEvent e15) {
                if (!FocusManager.isActive()) {
                    return false;
                }
                if (e15.getKeyCode() != 87) {
                    return false;
                }
                if (e15.getID() == 402) {
                    this.canClose = true;
                    return false;
                }
                if (e15.isControlDown() && this.canClose) {
                    TabbedPane.this.closeCodePanel(TabbedPane.this.curTab);
                    this.canClose = false;
                    return true;
                }
                return false;
            }
        });
    }

    private void enableSwitchingTabs() {
        this.addChangeListener(e15 -> {
            ContentPanel tab = this.getSelectedContentPanel();
            if (tab == null) {
                this.curTab = null;
                this.lastTab = null;
                return;
            }
            FocusManager.focusOnCodePanel(tab);
            if (tab == this.curTab) {
                if (this.lastTab != null && this.indexOfComponent(this.lastTab) == -1) {
                    this.setLastTabAdjacentToCurTab();
                }
                return;
            }
            if (tab == this.lastTab && this.indexOfComponent(this.curTab) == -1) {
                this.curTab = this.lastTab;
                this.setLastTabAdjacentToCurTab();
                return;
            }
            this.lastTab = this.curTab;
            this.curTab = tab;
        });
    }

    private void setLastTabAdjacentToCurTab() {
        if (this.getTabCount() < 2) {
            this.lastTab = null;
            return;
        }
        int idx = this.indexOfComponent(this.curTab);
        this.lastTab = idx == 0 ? (ContentPanel)this.getComponentAt(idx + 1) : (ContentPanel)this.getComponentAt(idx - 1);
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public TabsController getTabsController() {
        return this.controller;
    }

    @Nullable
    private ContentPanel showCode(JumpPosition jumpPos) {
        JNode jumpNode = jumpPos.getNode();
        ContentPanel contentPanel = this.getTabByNode(jumpNode);
        if (contentPanel == null) {
            return null;
        }
        this.selectTab(contentPanel);
        int pos = jumpPos.getPos();
        if (pos <= 0) {
            LOG.warn("Invalid jump: {}", (Object)jumpPos, (Object)new JadxRuntimeException());
            pos = Math.max(0, jumpNode.getPos());
        }
        contentPanel.scrollToPos(pos);
        return contentPanel;
    }

    public void selectTab(ContentPanel contentPanel) {
        this.controller.selectTab(contentPanel.getNode());
    }

    private void smaliJump(JClass cls, int pos, boolean debugMode) {
        ContentPanel panel = this.getTabByNode(cls);
        if (panel == null) {
            panel = this.showCode(new JumpPosition(cls, 1));
            if (panel == null) {
                throw new JadxRuntimeException("Failed to open panel for JClass: " + String.valueOf(cls));
            }
        } else {
            this.selectTab(panel);
        }
        ClassCodeContentPanel codePane = (ClassCodeContentPanel)panel;
        codePane.showSmaliPane();
        SmaliArea smaliArea = (SmaliArea)codePane.getSmaliCodeArea();
        if (debugMode) {
            smaliArea.scrollToDebugPos(pos);
        }
        smaliArea.scrollToPos(pos);
        smaliArea.requestFocus();
    }

    @Nullable
    public JumpPosition getCurrentPosition() {
        AbstractCodeArea codeArea;
        ContentPanel selectedCodePanel = this.getSelectedContentPanel();
        if (selectedCodePanel instanceof AbstractCodeContentPanel && (codeArea = ((AbstractCodeContentPanel)selectedCodePanel).getCodeArea()) != null) {
            return codeArea.getCurrentPosition();
        }
        return null;
    }

    private void addContentPanel(ContentPanel contentPanel) {
        this.tabsMap.put(contentPanel.getNode(), contentPanel);
        int tabCount = this.getTabCount();
        this.add((Component)contentPanel, tabCount);
        this.setTabComponentAt(tabCount, this.makeTabComponent(contentPanel));
    }

    public void closeCodePanel(ContentPanel contentPanel) {
        this.closeCodePanel(contentPanel, false);
    }

    public void closeCodePanel(ContentPanel contentPanel, boolean considerPins) {
        this.controller.closeTab(contentPanel.getNode(), considerPins);
    }

    public List<ContentPanel> getTabs() {
        ArrayList<ContentPanel> list2 = new ArrayList<ContentPanel>(this.getTabCount());
        for (int i15 = 0; i15 < this.getTabCount(); ++i15) {
            list2.add((ContentPanel)this.getComponentAt(i15));
        }
        return list2;
    }

    @Nullable
    public ContentPanel getTabByNode(JNode node) {
        return this.tabsMap.get(node);
    }

    @Nullable
    public TabComponent getTabComponentByNode(JNode node) {
        ContentPanel contentPanel = this.getTabByNode(node);
        if (contentPanel == null) {
            return null;
        }
        int index = this.indexOfComponent(contentPanel);
        if (index == -1) {
            return null;
        }
        Component component = this.getTabComponentAt(index);
        if (!(component instanceof TabComponent)) {
            return null;
        }
        return (TabComponent)component;
    }

    public boolean tabWithTitleExists(String tabTitle) {
        try {
            for (int i15 = 0; i15 < this.getTabCount(); ++i15) {
                Component component = this.getTabComponentAt(i15);
                if (!(component instanceof TabComponent) || !((TabComponent)component).getTabTitle().equals(tabTitle)) continue;
                return true;
            }
        }
        catch (Exception e15) {
            LOG.warn("Failed to check tabs titles", e15);
        }
        return false;
    }

    public void refresh(JNode node) {
        ContentPanel panel = this.getTabByNode(node);
        if (panel != null) {
            this.setTabComponentAt(this.indexOfComponent(panel), this.makeTabComponent(panel));
            this.fireStateChanged();
        }
    }

    public void reloadInactiveTabs() {
        UiUtils.uiThreadGuard();
        int tabCount = this.getTabCount();
        if (tabCount == 1) {
            return;
        }
        int current = this.getSelectedIndex();
        for (int i15 = 0; i15 < tabCount; ++i15) {
            ContentPanel oldPanel;
            TabBlueprint tab;
            if (i15 == current || (tab = this.controller.getTabByNode((oldPanel = (ContentPanel)this.getComponentAt(i15)).getNode())) == null) continue;
            EditorViewState viewState = this.controller.getEditorViewState(tab);
            JNode node = oldPanel.getNode();
            ContentPanel panel = node.getContentPanel(this);
            FocusManager.listen(panel);
            this.tabsMap.put(node, panel);
            this.setComponentAt(i15, panel);
            this.setTabComponentAt(i15, this.makeTabComponent(panel));
            this.controller.restoreEditorViewState(viewState);
        }
        this.fireStateChanged();
    }

    @Nullable
    public ContentPanel getSelectedContentPanel() {
        return (ContentPanel)this.getSelectedComponent();
    }

    private Component makeTabComponent(ContentPanel contentPanel) {
        return new TabComponent(this, contentPanel);
    }

    public void closeAllTabs() {
        this.closeAllTabs(false);
    }

    public void closeAllTabs(boolean considerPins) {
        for (ContentPanel panel : this.getTabs()) {
            this.closeCodePanel(panel, considerPins);
        }
    }

    public void loadSettings() {
        for (int i15 = 0; i15 < this.getTabCount(); ++i15) {
            ((ContentPanel)this.getComponentAt(i15)).loadSettings();
            ((TabComponent)this.getTabComponentAt(i15)).loadSettings();
        }
    }

    public void reset() {
        this.closeAllTabs();
        this.tabsMap.clear();
        this.curTab = null;
        this.lastTab = null;
        FocusManager.reset();
    }

    @Nullable
    public Component getFocusedComp() {
        return FocusManager.getFocusedComp();
    }

    public TabDndController getDnd() {
        return this.dnd;
    }

    public void setDnd(TabDndController dnd) {
        this.dnd = dnd;
    }

    @Override
    public void onTabOpen(TabBlueprint blueprint) {
        if (blueprint.isHidden()) {
            return;
        }
        JNode node = blueprint.getNode();
        ContentPanel newPanel = node.getContentPanel(this);
        if (newPanel != null) {
            if (node != newPanel.getNode()) {
                throw new JadxRuntimeException("Incorrect node found in content panel");
            }
            FocusManager.listen(newPanel);
            this.addContentPanel(newPanel);
            blueprint.setCreated(true);
        }
    }

    @Override
    public void onTabSelect(TabBlueprint blueprint) {
        ContentPanel contentPanel = this.getTabByNode(blueprint.getNode());
        if (contentPanel != null) {
            this.setSelectedComponent(contentPanel);
        }
    }

    @Override
    public void onTabCodeJump(TabBlueprint blueprint, @Nullable JumpPosition prevPos, JumpPosition position) {
        this.mainWindow.getBackgroundExecutor().execute(new SilentTask(() -> this.showCode(position)));
    }

    @Override
    public void onTabSmaliJump(TabBlueprint blueprint, int pos, boolean debugMode) {
        JNode node = blueprint.getNode();
        if (node instanceof JClass) {
            this.smaliJump((JClass)node, pos, debugMode);
        }
    }

    @Override
    public void onTabClose(TabBlueprint blueprint) {
        ContentPanel contentPanelToClose = this.getTabByNode(blueprint.getNode());
        if (contentPanelToClose == null) {
            return;
        }
        ContentPanel currentContentPanel = this.getSelectedContentPanel();
        if (currentContentPanel == contentPanelToClose) {
            if (this.lastTab != null && this.lastTab.getNode() != null) {
                this.selectTab(this.lastTab);
            } else if (this.getTabCount() > 1) {
                int removalIdx = this.indexOfComponent(contentPanelToClose);
                if (removalIdx > 0) {
                    this.setSelectedIndex(removalIdx - 1);
                } else if (removalIdx == 0) {
                    this.setSelectedIndex(removalIdx + 1);
                }
            } else {
                this.controller.deselectTab();
            }
        }
        this.tabsMap.remove(contentPanelToClose.getNode());
        this.remove(contentPanelToClose);
        contentPanelToClose.dispose();
    }

    @Override
    public void onTabPositionFirst(TabBlueprint blueprint) {
        ContentPanel contentPanel = this.getTabByNode(blueprint.getNode());
        if (contentPanel == null) {
            return;
        }
        this.setTabPosition(contentPanel, 0);
    }

    private void setTabPosition(ContentPanel contentPanel, int position) {
        TabComponent tabComponent = this.getTabComponentByNode(contentPanel.getNode());
        if (tabComponent == null) {
            return;
        }
        boolean restoreSelection = contentPanel == this.getSelectedContentPanel();
        this.remove(contentPanel);
        this.add((Component)contentPanel, position);
        this.setTabComponentAt(position, tabComponent);
        if (restoreSelection) {
            this.setSelectedIndex(position);
        }
    }

    @Override
    public void onTabPinChange(TabBlueprint blueprint) {
        TabComponent tabComponent = this.getTabComponentByNode(blueprint.getNode());
        if (tabComponent == null) {
            return;
        }
        tabComponent.update();
    }

    @Override
    public void onTabBookmarkChange(TabBlueprint blueprint) {
        TabComponent tabComponent = this.getTabComponentByNode(blueprint.getNode());
        if (tabComponent == null) {
            return;
        }
        tabComponent.update();
    }

    @Override
    public void onTabVisibilityChange(TabBlueprint blueprint) {
        if (!blueprint.isHidden() && !this.tabsMap.containsKey(blueprint.getNode())) {
            this.onTabOpen(blueprint);
        }
        if (blueprint.isHidden() && this.tabsMap.containsKey(blueprint.getNode())) {
            this.onTabClose(blueprint);
        }
    }

    @Override
    public void onTabPreviewChange(TabBlueprint blueprint) {
        TabComponent tabComponent = this.getTabComponentByNode(blueprint.getNode());
        if (tabComponent == null) {
            return;
        }
        tabComponent.update();
    }

    @Override
    public void onTabRestore(TabBlueprint blueprint, EditorViewState viewState) {
        ContentPanel contentPanel = this.getTabByNode(blueprint.getNode());
        if (contentPanel instanceof IViewStateSupport) {
            ((IViewStateSupport)((Object)contentPanel)).restoreEditorViewState(viewState);
        }
    }

    @Override
    public void onTabsReorder(List<TabBlueprint> blueprints) {
        ArrayList<TabBlueprint> newBlueprints = new ArrayList<TabBlueprint>(blueprints.size());
        for (ContentPanel contentPanel : this.getTabs()) {
            TabBlueprint blueprint = this.controller.getTabByNode(contentPanel.getNode());
            if (blueprint == null) continue;
            newBlueprints.add(blueprint);
        }
        LinkedHashSet<TabBlueprint> set = new LinkedHashSet<TabBlueprint>(blueprints);
        newBlueprints.forEach(set::remove);
        newBlueprints.addAll(set);
        blueprints.clear();
        blueprints.addAll(newBlueprints);
    }

    @Override
    public void onTabSave(TabBlueprint blueprint, EditorViewState viewState) {
        ContentPanel contentPanel = this.getTabByNode(blueprint.getNode());
        if (contentPanel instanceof IViewStateSupport) {
            ((IViewStateSupport)((Object)contentPanel)).saveEditorViewState(viewState);
        }
    }

    private static class FocusManager
    implements FocusListener {
        private static final FocusManager INSTANCE = new FocusManager();
        @Nullable
        private static Component focusedComp;

        private FocusManager() {
        }

        static boolean isActive() {
            return focusedComp != null;
        }

        static void reset() {
            focusedComp = null;
        }

        static Component getFocusedComp() {
            return focusedComp;
        }

        @Override
        public void focusGained(FocusEvent e15) {
            focusedComp = (Component)e15.getSource();
        }

        @Override
        public void focusLost(FocusEvent e15) {
            focusedComp = null;
        }

        static void listen(ContentPanel pane) {
            if (pane instanceof ClassCodeContentPanel) {
                ((ClassCodeContentPanel)pane).getCodeArea().addFocusListener(INSTANCE);
                ((ClassCodeContentPanel)pane).getSmaliCodeArea().addFocusListener(INSTANCE);
                return;
            }
            if (pane instanceof AbstractCodeContentPanel) {
                ((AbstractCodeContentPanel)pane).getChildrenComponent().addFocusListener(INSTANCE);
                return;
            }
            if (pane instanceof HtmlPanel) {
                ((HtmlPanel)pane).getHtmlArea().addFocusListener(INSTANCE);
                return;
            }
            if (pane instanceof ImagePanel) {
                pane.addFocusListener(INSTANCE);
                return;
            }
            if (pane instanceof FontPanel) {
                pane.addFocusListener(INSTANCE);
                return;
            }
        }

        static void focusOnCodePanel(ContentPanel pane) {
            if (pane instanceof ClassCodeContentPanel) {
                SwingUtilities.invokeLater(() -> ((ClassCodeContentPanel)pane).getCurrentCodeArea().requestFocus());
                return;
            }
            if (pane instanceof AbstractCodeContentPanel) {
                SwingUtilities.invokeLater(() -> ((AbstractCodeContentPanel)pane).getChildrenComponent().requestFocus());
                return;
            }
            if (pane instanceof HtmlPanel) {
                SwingUtilities.invokeLater(() -> ((HtmlPanel)pane).getHtmlArea().requestFocusInWindow());
                return;
            }
            if (pane instanceof ImagePanel) {
                SwingUtilities.invokeLater(((ImagePanel)pane)::requestFocusInWindow);
                return;
            }
            if (pane instanceof FontPanel) {
                SwingUtilities.invokeLater(((FontPanel)pane)::requestFocusInWindow);
                return;
            }
        }
    }
}

