/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.conditions.IfRegion;
import jadx.core.dex.visitors.regions.AbstractRegionVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.IRegionIterativeVisitor;
import jadx.core.dex.visitors.shrink.CodeShrinkVisitor;
import jadx.core.utils.InsnList;
import jadx.core.utils.InsnRemover;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TernaryMod
extends AbstractRegionVisitor
implements IRegionIterativeVisitor {
    private static final TernaryMod INSTANCE = new TernaryMod();

    public static void process(MethodNode mth) {
        DepthRegionTraversal.traverse(mth, INSTANCE);
        if (mth.contains(AFlag.REQUEST_CODE_SHRINK)) {
            CodeShrinkVisitor.shrinkMethod(mth);
        }
        DepthRegionTraversal.traverseIterative(mth, INSTANCE);
    }

    @Override
    public boolean enterRegion(MethodNode mth, IRegion region) {
        if (TernaryMod.processRegion(mth, region)) {
            mth.add(AFlag.REQUEST_CODE_SHRINK);
        }
        return true;
    }

    @Override
    public boolean visitRegion(MethodNode mth, IRegion region) {
        if (TernaryMod.processRegion(mth, region)) {
            CodeShrinkVisitor.shrinkMethod(mth);
            return true;
        }
        return false;
    }

    private static boolean processRegion(MethodNode mth, IRegion region) {
        if (region instanceof IfRegion) {
            return TernaryMod.makeTernaryInsn(mth, (IfRegion)region);
        }
        return false;
    }

    private static boolean makeTernaryInsn(MethodNode mth, IfRegion ifRegion) {
        InsnNode elseInsn;
        if (ifRegion.contains(AFlag.ELSE_IF_CHAIN)) {
            return false;
        }
        IContainer thenRegion = ifRegion.getThenRegion();
        IContainer elseRegion = ifRegion.getElseRegion();
        if (thenRegion == null) {
            return false;
        }
        if (elseRegion == null) {
            return TernaryMod.processOneBranchTernary(mth, ifRegion);
        }
        BlockNode tb5 = TernaryMod.getTernaryInsnBlock(thenRegion);
        BlockNode eb5 = TernaryMod.getTernaryInsnBlock(elseRegion);
        if (tb5 == null || eb5 == null) {
            return false;
        }
        List<BlockNode> conditionBlocks = ifRegion.getConditionBlocks();
        if (conditionBlocks.isEmpty()) {
            return false;
        }
        BlockNode header = conditionBlocks.get(0);
        InsnNode thenInsn = tb5.getInstructions().get(0);
        if (!TernaryMod.verifyLineHints(mth, thenInsn, elseInsn = eb5.getInstructions().get(0))) {
            return false;
        }
        RegisterArg thenResArg = thenInsn.getResult();
        RegisterArg elseResArg = elseInsn.getResult();
        if (thenResArg != null && elseResArg != null) {
            RegisterArg resArg;
            PhiInsn thenPhi = thenResArg.getSVar().getOnlyOneUseInPhi();
            PhiInsn elsePhi = elseResArg.getSVar().getOnlyOneUseInPhi();
            if (thenPhi == null || thenPhi != elsePhi) {
                return false;
            }
            if (!ifRegion.getParent().replaceSubBlock(ifRegion, header)) {
                return false;
            }
            InsnList.remove(tb5, thenInsn);
            InsnList.remove(eb5, elseInsn);
            if (thenPhi.getArgsCount() == 2) {
                resArg = thenPhi.getResult();
                InsnRemover.unbindResult(mth, thenInsn);
            } else {
                resArg = thenResArg;
                thenPhi.removeArg(elseResArg);
            }
            InsnArg thenArg = InsnArg.wrapInsnIntoArg(thenInsn);
            InsnArg elseArg = InsnArg.wrapInsnIntoArg(elseInsn);
            TernaryInsn ternInsn = new TernaryInsn(ifRegion.getCondition(), resArg, thenArg, elseArg);
            int branchLine = Math.max(thenInsn.getSourceLine(), elseInsn.getSourceLine());
            ternInsn.setSourceLine(Math.max(ifRegion.getSourceLine(), branchLine));
            thenInsn.setResult(null);
            InsnRemover.unbindResult(mth, elseInsn);
            header.getInstructions().clear();
            ternInsn.rebindArgs();
            header.getInstructions().add(ternInsn);
            TernaryMod.clearConditionBlocks(conditionBlocks, header);
            return true;
        }
        if (!mth.isVoidReturn() && thenInsn.getType() == InsnType.RETURN && elseInsn.getType() == InsnType.RETURN) {
            InsnArg thenArg = thenInsn.getArg(0);
            InsnArg elseArg = elseInsn.getArg(0);
            if (thenArg.isLiteral() != elseArg.isLiteral()) {
                return false;
            }
            if (!ifRegion.getParent().replaceSubBlock(ifRegion, header)) {
                return false;
            }
            InsnList.remove(tb5, thenInsn);
            InsnList.remove(eb5, elseInsn);
            tb5.remove(AFlag.RETURN);
            eb5.remove(AFlag.RETURN);
            TernaryInsn ternInsn = new TernaryInsn(ifRegion.getCondition(), null, thenArg, elseArg);
            InsnNode retInsn = new InsnNode(InsnType.RETURN, 1);
            InsnArg arg = InsnArg.wrapInsnIntoArg(ternInsn);
            arg.setType(thenArg.getType());
            retInsn.addArg(arg);
            header.getInstructions().clear();
            retInsn.rebindArgs();
            header.getInstructions().add(retInsn);
            header.add(AFlag.RETURN);
            TernaryMod.clearConditionBlocks(conditionBlocks, header);
            return true;
        }
        return false;
    }

    private static boolean verifyLineHints(MethodNode mth, InsnNode thenInsn, InsnNode elseInsn) {
        if (mth.contains(AFlag.USE_LINES_HINTS) && thenInsn.getSourceLine() != elseInsn.getSourceLine()) {
            if (thenInsn.getSourceLine() != 0 && elseInsn.getSourceLine() != 0) {
                return TernaryMod.checkLineStats(thenInsn, elseInsn);
            }
            return !TernaryMod.containsTernary(thenInsn) && !TernaryMod.containsTernary(elseInsn);
        }
        return true;
    }

    private static void clearConditionBlocks(List<BlockNode> conditionBlocks, BlockNode header) {
        for (BlockNode block : conditionBlocks) {
            if (block == header) continue;
            block.getInstructions().clear();
            block.add(AFlag.REMOVE);
        }
    }

    private static BlockNode getTernaryInsnBlock(IContainer thenRegion) {
        BlockNode block;
        IContainer container;
        Region r15;
        if (thenRegion instanceof Region && (r15 = (Region)thenRegion).getSubBlocks().size() == 1 && (container = r15.getSubBlocks().get(0)) instanceof BlockNode && (block = (BlockNode)container).getInstructions().size() == 1) {
            return block;
        }
        return null;
    }

    private static boolean containsTernary(InsnNode insn) {
        if (insn.getType() == InsnType.TERNARY) {
            return true;
        }
        for (int i15 = 0; i15 < insn.getArgsCount(); ++i15) {
            InsnNode wrapInsn;
            InsnArg arg = insn.getArg(i15);
            if (!arg.isInsnWrap() || !TernaryMod.containsTernary(wrapInsn = ((InsnWrapArg)arg).getWrapInsn())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkLineStats(InsnNode t15, InsnNode e15) {
        if (t15.getResult() == null || e15.getResult() == null) {
            return false;
        }
        PhiInsn tPhi = t15.getResult().getSVar().getOnlyOneUseInPhi();
        PhiInsn ePhi = e15.getResult().getSVar().getOnlyOneUseInPhi();
        if (ePhi == null || tPhi != ePhi) {
            return false;
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(tPhi.getArgsCount());
        for (InsnArg insnArg : tPhi.getArguments()) {
            int sourceLine;
            InsnNode assignInsn;
            if (!insnArg.isRegister() || (assignInsn = ((RegisterArg)insnArg).getAssignInsn()) == null || (sourceLine = assignInsn.getSourceLine()) == 0) continue;
            map.merge(sourceLine, 1, Integer::sum);
        }
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() < 2) continue;
            return true;
        }
        return false;
    }

    private static boolean processOneBranchTernary(MethodNode mth, IfRegion ifRegion) {
        InsnNode insn;
        RegisterArg result;
        IContainer thenRegion = ifRegion.getThenRegion();
        BlockNode block = TernaryMod.getTernaryInsnBlock(thenRegion);
        if (block != null && (result = (insn = block.getInstructions().get(0)).getResult()) != null) {
            TernaryMod.replaceWithTernary(mth, ifRegion, block, insn);
        }
        return false;
    }

    private static void replaceWithTernary(MethodNode mth, IfRegion ifRegion, BlockNode block, InsnNode insn) {
        InsnArg elseArg;
        RegisterArg resArg = insn.getResult();
        if (resArg.getSVar().getUseList().size() != 1) {
            return;
        }
        PhiInsn phiInsn = resArg.getSVar().getOnlyOneUseInPhi();
        if (phiInsn == null || phiInsn.getArgsCount() != 2) {
            return;
        }
        RegisterArg otherArg = null;
        for (InsnArg arg : phiInsn.getArguments()) {
            if (resArg.sameRegAndSVar(arg)) continue;
            otherArg = (RegisterArg)arg;
            break;
        }
        if (otherArg == null) {
            return;
        }
        InsnNode elseAssign = otherArg.getAssignInsn();
        if (!(mth.isConstructor() || mth.getParentClass().isEnum() && mth.getMethodInfo().isClassInit() || !(elseAssign != null && elseAssign.isConstInsn() ? !TernaryMod.verifyLineHints(mth, insn, elseAssign) : insn.getResult().sameCodeVar(otherArg)))) {
            return;
        }
        BlockNode header = ifRegion.getConditionBlocks().get(0);
        if (!ifRegion.getParent().replaceSubBlock(ifRegion, header)) {
            return;
        }
        if (elseAssign != null && elseAssign.isConstInsn()) {
            SSAVar elseVar = elseAssign.getResult().getSVar();
            if (elseVar.getUseCount() == 1 && elseVar.getOnlyOneUseInPhi() == phiInsn) {
                InsnRemover.remove(mth, elseAssign);
            }
            elseArg = InsnArg.wrapInsnIntoArg(elseAssign);
        } else {
            elseArg = otherArg.duplicate();
        }
        InsnArg thenArg = InsnArg.wrapInsnIntoArg(insn);
        RegisterArg resultArg = phiInsn.getResult().duplicate();
        TernaryInsn ternInsn = new TernaryInsn(ifRegion.getCondition(), resultArg, thenArg, elseArg);
        ternInsn.simplifyCondition();
        InsnRemover.unbindAllArgs(mth, phiInsn);
        InsnRemover.unbindResult(mth, insn);
        InsnList.remove(block, insn);
        header.getInstructions().clear();
        ternInsn.rebindArgs();
        header.getInstructions().add(ternInsn);
        TernaryMod.clearConditionBlocks(ifRegion.getConditionBlocks(), header);
        CodeShrinkVisitor.shrinkMethod(mth);
    }

    private TernaryMod() {
    }
}

