/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions.conditions;

import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.ArithOp;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.IfOp;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.regions.conditions.Compare;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public final class IfCondition
extends AttrNode {
    private final Mode mode;
    private final List<IfCondition> args;
    private final Compare compare;

    private IfCondition(Compare compare) {
        this.mode = Mode.COMPARE;
        this.compare = compare;
        this.args = Collections.emptyList();
    }

    private IfCondition(Mode mode, List<IfCondition> args) {
        this.mode = mode;
        this.args = args;
        this.compare = null;
    }

    private IfCondition(IfCondition c15) {
        this.mode = c15.mode;
        this.compare = c15.compare;
        this.args = c15.mode == Mode.COMPARE ? Collections.emptyList() : new ArrayList<IfCondition>(c15.args);
    }

    public static IfCondition fromIfBlock(BlockNode header) {
        InsnNode lastInsn = BlockUtils.getLastInsn(header);
        if (lastInsn == null) {
            return null;
        }
        return IfCondition.fromIfNode((IfNode)lastInsn);
    }

    public static IfCondition fromIfNode(IfNode insn) {
        return new IfCondition(new Compare(insn));
    }

    public static IfCondition ternary(IfCondition a15, IfCondition b15, IfCondition c15) {
        return new IfCondition(Mode.TERNARY, Arrays.asList(a15, b15, c15));
    }

    public static IfCondition merge(Mode mode, IfCondition a15, IfCondition b15) {
        if (a15.getMode() == mode) {
            IfCondition n15 = new IfCondition(a15);
            n15.addArg(b15);
            return n15;
        }
        return new IfCondition(mode, Arrays.asList(a15, b15));
    }

    public Mode getMode() {
        return this.mode;
    }

    public List<IfCondition> getArgs() {
        return this.args;
    }

    public IfCondition first() {
        return this.args.get(0);
    }

    public IfCondition second() {
        return this.args.get(1);
    }

    public IfCondition third() {
        return this.args.get(2);
    }

    public void addArg(IfCondition c15) {
        this.args.add(c15);
    }

    public boolean isCompare() {
        return this.mode == Mode.COMPARE;
    }

    public Compare getCompare() {
        return this.compare;
    }

    public static IfCondition invert(IfCondition cond) {
        Mode mode = cond.getMode();
        switch (mode.ordinal()) {
            case 0: {
                return new IfCondition(cond.getCompare().invert());
            }
            case 1: {
                return IfCondition.ternary(cond.first(), IfCondition.not(cond.second()), IfCondition.not(cond.third()));
            }
            case 2: {
                return cond.first();
            }
            case 3: 
            case 4: {
                List<IfCondition> args = cond.getArgs();
                ArrayList<IfCondition> newArgs = new ArrayList<IfCondition>(args.size());
                for (IfCondition arg : args) {
                    newArgs.add(IfCondition.invert(arg));
                }
                return new IfCondition(mode == Mode.AND ? Mode.OR : Mode.AND, newArgs);
            }
        }
        throw new JadxRuntimeException("Unknown mode for invert: " + String.valueOf((Object)mode));
    }

    public static IfCondition not(IfCondition cond) {
        if (cond.getMode() == Mode.NOT) {
            return cond.first();
        }
        if (cond.getCompare() != null) {
            return new IfCondition(cond.compare.invert());
        }
        return new IfCondition(Mode.NOT, Collections.singletonList(cond));
    }

    public static IfCondition simplify(IfCondition cond) {
        int count;
        if (cond.isCompare()) {
            Compare c15 = cond.getCompare();
            IfCondition i15 = IfCondition.simplifyCmpOp(c15);
            if (i15 != null) {
                return i15;
            }
            if (c15.getOp() == IfOp.EQ && c15.getB().isFalse()) {
                cond = new IfCondition(Mode.NOT, Collections.singletonList(new IfCondition(c15.invert())));
            } else {
                c15.normalize();
            }
        }
        ArrayList<IfCondition> args = null;
        for (int i16 = 0; i16 < cond.getArgs().size(); ++i16) {
            IfCondition arg = cond.getArgs().get(i16);
            IfCondition simpl = IfCondition.simplify(arg);
            if (simpl == arg) continue;
            if (args == null) {
                args = new ArrayList<IfCondition>(cond.getArgs());
            }
            args.set(i16, simpl);
        }
        if (args != null) {
            cond = new IfCondition(cond.getMode(), args);
        }
        if (cond.getMode() == Mode.NOT && cond.first().getMode() == Mode.NOT) {
            cond = IfCondition.invert(cond.first());
        }
        if (cond.getMode() == Mode.TERNARY && cond.first().getMode() == Mode.NOT) {
            cond = IfCondition.invert(cond);
        }
        if ((cond.getMode() == Mode.OR || cond.getMode() == Mode.AND) && (count = cond.getArgs().size()) > 1) {
            int negCount = 0;
            for (IfCondition arg : cond.getArgs()) {
                if (arg.getMode() != Mode.NOT && (!arg.isCompare() || arg.getCompare().getOp() != IfOp.NE)) continue;
                ++negCount;
            }
            if (negCount > count / 2) {
                return IfCondition.not(IfCondition.invert(cond));
            }
        }
        return cond;
    }

    private static IfCondition simplifyCmpOp(Compare c15) {
        if (!c15.getA().isInsnWrap()) {
            return null;
        }
        if (!c15.getB().isLiteral()) {
            return null;
        }
        long lit = ((LiteralArg)c15.getB()).getLiteral();
        if (lit != 0L && lit != 1L) {
            return null;
        }
        InsnNode wrapInsn = ((InsnWrapArg)c15.getA()).getWrapInsn();
        switch (wrapInsn.getType()) {
            case CMP_L: 
            case CMP_G: {
                if (lit != 0L) break;
                IfNode insn = c15.getInsn();
                insn.changeCondition(insn.getOp(), wrapInsn.getArg(0), wrapInsn.getArg(1));
                break;
            }
            case ARITH: {
                ArithOp arithOp;
                if (c15.getB().getType() != ArgType.BOOLEAN || (arithOp = ((ArithNode)wrapInsn).getOp()) != ArithOp.OR && arithOp != ArithOp.AND) break;
                IfOp ifOp = c15.getInsn().getOp();
                boolean isTrue = ifOp == IfOp.NE && lit == 0L || ifOp == IfOp.EQ && lit == 1L;
                IfOp op4 = isTrue ? IfOp.NE : IfOp.EQ;
                Mode mode = isTrue && arithOp == ArithOp.OR || !isTrue && arithOp == ArithOp.AND ? Mode.OR : Mode.AND;
                IfNode if12 = new IfNode(op4, -1, wrapInsn.getArg(0), LiteralArg.litFalse());
                IfNode if22 = new IfNode(op4, -1, wrapInsn.getArg(1), LiteralArg.litFalse());
                return new IfCondition(mode, Arrays.asList(new IfCondition(new Compare(if12)), new IfCondition(new Compare(if22))));
            }
        }
        return null;
    }

    public List<RegisterArg> getRegisterArgs() {
        ArrayList<RegisterArg> list2 = new ArrayList<RegisterArg>();
        if (this.mode == Mode.COMPARE) {
            this.compare.getInsn().getRegisterArgs(list2);
        } else {
            for (IfCondition arg : this.args) {
                list2.addAll(arg.getRegisterArgs());
            }
        }
        return list2;
    }

    public boolean replaceArg(InsnArg from, InsnArg to4) {
        if (this.mode == Mode.COMPARE) {
            return this.compare.getInsn().replaceArg(from, to4);
        }
        for (IfCondition arg : this.args) {
            if (!arg.replaceArg(from, to4)) continue;
            return true;
        }
        return false;
    }

    public void visitInsns(Consumer<InsnNode> visitor2) {
        if (this.mode == Mode.COMPARE) {
            this.compare.getInsn().visitInsns(visitor2);
        } else {
            this.args.forEach(arg -> arg.visitInsns(visitor2));
        }
    }

    public List<InsnNode> collectInsns() {
        ArrayList<InsnNode> list2 = new ArrayList<InsnNode>();
        this.visitInsns(list2::add);
        return list2;
    }

    public int getSourceLine() {
        for (InsnNode insn : this.collectInsns()) {
            int line = insn.getSourceLine();
            if (line == 0) continue;
            return line;
        }
        return 0;
    }

    @Nullable
    public InsnNode getFirstInsn() {
        if (this.mode == Mode.COMPARE) {
            return this.compare.getInsn();
        }
        return this.args.get(0).getFirstInsn();
    }

    public String toString() {
        switch (this.mode.ordinal()) {
            case 0: {
                return this.compare.toString();
            }
            case 1: {
                return String.valueOf(this.first()) + " ? " + String.valueOf(this.second()) + " : " + String.valueOf(this.third());
            }
            case 2: {
                return "!(" + String.valueOf(this.first()) + ")";
            }
            case 3: 
            case 4: {
                String op4 = this.mode == Mode.OR ? " || " : " && ";
                StringBuilder sb5 = new StringBuilder();
                sb5.append('(');
                Iterator<IfCondition> it = this.args.iterator();
                while (it.hasNext()) {
                    IfCondition arg = it.next();
                    sb5.append(arg);
                    if (!it.hasNext()) continue;
                    sb5.append(op4);
                }
                sb5.append(')');
                return sb5.toString();
            }
        }
        return "??";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IfCondition)) {
            return false;
        }
        IfCondition other = (IfCondition)obj;
        if (this.mode != other.mode) {
            return false;
        }
        return Objects.equals(this.args, other.args) && Objects.equals(this.compare, other.compare);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mode.hashCode();
        result = 31 * result + this.args.hashCode();
        result = 31 * result + (this.compare != null ? this.compare.hashCode() : 0);
        return result;
    }

    public static enum Mode {
        COMPARE,
        TERNARY,
        NOT,
        AND,
        OR;

    }
}

