/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.invokedynamic;

import jadx.api.plugins.input.data.IMethodHandle;
import jadx.api.plugins.input.data.IMethodRef;
import jadx.api.plugins.input.data.MethodHandleType;
import jadx.api.plugins.input.data.annotations.EncodedType;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.insns.InsnData;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.JadxError;
import jadx.core.dex.instructions.ConstClassNode;
import jadx.core.dex.instructions.ConstStringNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.EncodedValueUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.List;
import java.util.Objects;

public class CustomStringConcat {
    public static boolean isStringConcat(List<EncodedValue> values2) {
        if (values2.size() < 4) {
            return false;
        }
        IMethodHandle methodHandle = (IMethodHandle)values2.get(0).getValue();
        if (methodHandle.getType() != MethodHandleType.INVOKE_STATIC) {
            return false;
        }
        IMethodRef methodRef = methodHandle.getMethodRef();
        if (!methodRef.getName().equals("makeConcatWithConstants")) {
            return false;
        }
        if (!methodRef.getParentClassType().equals("Ljava/lang/invoke/StringConcatFactory;")) {
            return false;
        }
        if (!Objects.equals(values2.get(1).getValue(), "makeConcatWithConstants")) {
            return false;
        }
        return values2.get(3).getType() == EncodedType.ENCODED_STRING;
    }

    public static InsnNode buildStringConcat(InsnData insn, boolean isRange, List<EncodedValue> values2) {
        try {
            int argsCount = values2.size() - 3 + insn.getRegsCount();
            InsnNode concat = new InsnNode(InsnType.STR_CONCAT, argsCount);
            String recipe = (String)values2.get(3).getValue();
            CustomStringConcat.processRecipe(recipe, concat, values2, insn);
            int resReg = insn.getResultReg();
            if (resReg != -1) {
                concat.setResult(InsnArg.reg(resReg, ArgType.STRING));
            }
            return concat;
        }
        catch (Exception e15) {
            InsnNode nop = new InsnNode(InsnType.NOP, 0);
            nop.add(AFlag.SYNTHETIC);
            nop.addAttr(AType.JADX_ERROR, new JadxError("Failed to process dynamic string concat: " + e15.getMessage(), e15));
            return nop;
        }
    }

    private static void processRecipe(String recipe, InsnNode concat, List<EncodedValue> values2, InsnData insn) {
        int len = recipe.length();
        int offset = 0;
        int argNum = 0;
        int constNum = 4;
        StringBuilder sb5 = new StringBuilder(len);
        while (offset < len) {
            boolean constTag;
            int cp4 = recipe.codePointAt(offset);
            offset += Character.charCount(cp4);
            boolean argTag = cp4 == 1;
            boolean bl4 = constTag = cp4 == 2;
            if (argTag || constTag) {
                if (sb5.length() != 0) {
                    concat.addArg(InsnArg.wrapArg(new ConstStringNode(sb5.toString())));
                    sb5.setLength(0);
                }
                if (argTag) {
                    concat.addArg(InsnArg.reg(insn, argNum++, ArgType.UNKNOWN));
                    continue;
                }
                InsnArg constArg = CustomStringConcat.buildInsnArgFromEncodedValue(values2.get(constNum++));
                concat.addArg(constArg);
                continue;
            }
            sb5.appendCodePoint(cp4);
        }
        if (sb5.length() != 0) {
            concat.addArg(InsnArg.wrapArg(new ConstStringNode(sb5.toString())));
        }
    }

    private static InsnArg buildInsnArgFromEncodedValue(EncodedValue encodedValue) {
        Object value = EncodedValueUtils.convertToConstValue(encodedValue);
        if (value == null) {
            return InsnArg.lit(0L, ArgType.UNKNOWN);
        }
        if (value instanceof LiteralArg) {
            return (LiteralArg)value;
        }
        if (value instanceof ArgType) {
            return InsnArg.wrapArg(new ConstClassNode((ArgType)value));
        }
        if (value instanceof String) {
            return InsnArg.wrapArg(new ConstStringNode((String)value));
        }
        throw new JadxRuntimeException("Can't build insn arg from encoded value: " + String.valueOf(encodedValue));
    }
}

