/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes.nodes;

import jadx.api.plugins.input.data.attributes.PinnedAttribute;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import java.util.List;
import java.util.Objects;

public class MethodInlineAttr
extends PinnedAttribute {
    private static final MethodInlineAttr INLINE_NOT_NEEDED = new MethodInlineAttr(null, null);
    private final InsnNode insn;
    private final int[] argsRegNums;

    public static MethodInlineAttr markForInline(MethodNode mth, InsnNode replaceInsn) {
        Objects.requireNonNull(replaceInsn);
        List<RegisterArg> allArgRegs = mth.getAllArgRegs();
        int argsCount = allArgRegs.size();
        int[] regNums = new int[argsCount];
        for (int i15 = 0; i15 < argsCount; ++i15) {
            RegisterArg reg = allArgRegs.get(i15);
            regNums[i15] = reg.getRegNum();
        }
        MethodInlineAttr mia = new MethodInlineAttr(replaceInsn, regNums);
        mth.addAttr(mia);
        mth.addDebugComment("Marked for inline");
        return mia;
    }

    public static MethodInlineAttr inlineNotNeeded(MethodNode mth) {
        mth.addAttr(INLINE_NOT_NEEDED);
        return INLINE_NOT_NEEDED;
    }

    private MethodInlineAttr(InsnNode insn, int[] argsRegNums) {
        this.insn = insn;
        this.argsRegNums = argsRegNums;
    }

    public boolean notNeeded() {
        return this.insn == null;
    }

    public InsnNode getInsn() {
        return this.insn;
    }

    public int[] getArgsRegNums() {
        return this.argsRegNums;
    }

    public AType<MethodInlineAttr> getAttrType() {
        return AType.METHOD_INLINE;
    }

    public String toString() {
        if (this.notNeeded()) {
            return "INLINE_NOT_NEEDED";
        }
        return "INLINE: " + String.valueOf(this.insn);
    }
}

