/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subscribers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SafeSubscriber<@NonNull T>
implements FlowableSubscriber<T>,
Subscription {
    final Subscriber<? super T> downstream;
    Subscription upstream;
    boolean done;

    public SafeSubscriber(@NonNull Subscriber<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(@NonNull Subscription s15) {
        if (SubscriptionHelper.validate(this.upstream, s15)) {
            this.upstream = s15;
            try {
                this.downstream.onSubscribe(this);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.done = true;
                try {
                    s15.cancel();
                }
                catch (Throwable e16) {
                    Exceptions.throwIfFatal(e16);
                    RxJavaPlugins.onError(new CompositeException(e15, e16));
                    return;
                }
                RxJavaPlugins.onError(e15);
            }
        }
    }

    @Override
    public void onNext(@NonNull T t15) {
        if (this.done) {
            return;
        }
        if (this.upstream == null) {
            this.onNextNoSubscription();
            return;
        }
        if (t15 == null) {
            NullPointerException ex4 = ExceptionHelper.createNullPointerException("onNext called with a null Throwable.");
            try {
                this.upstream.cancel();
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.onError(new CompositeException(ex4, e15));
                return;
            }
            this.onError(ex4);
            return;
        }
        try {
            this.downstream.onNext(t15);
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            try {
                this.upstream.cancel();
            }
            catch (Throwable e16) {
                Exceptions.throwIfFatal(e16);
                this.onError(new CompositeException(e15, e16));
                return;
            }
            this.onError(e15);
        }
    }

    void onNextNoSubscription() {
        this.done = true;
        NullPointerException ex4 = new NullPointerException("Subscription not set!");
        try {
            this.downstream.onSubscribe(EmptySubscription.INSTANCE);
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            RxJavaPlugins.onError(new CompositeException(ex4, e15));
            return;
        }
        try {
            this.downstream.onError(ex4);
        }
        catch (Throwable e16) {
            Exceptions.throwIfFatal(e16);
            RxJavaPlugins.onError(new CompositeException(ex4, e16));
        }
    }

    @Override
    public void onError(@NonNull Throwable t15) {
        if (this.done) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.done = true;
        if (this.upstream == null) {
            NullPointerException npe = new NullPointerException("Subscription not set!");
            try {
                this.downstream.onSubscribe(EmptySubscription.INSTANCE);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                RxJavaPlugins.onError(new CompositeException(t15, npe, e15));
                return;
            }
            try {
                this.downstream.onError(new CompositeException(t15, npe));
            }
            catch (Throwable e16) {
                Exceptions.throwIfFatal(e16);
                RxJavaPlugins.onError(new CompositeException(t15, npe, e16));
            }
            return;
        }
        if (t15 == null) {
            t15 = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
        }
        try {
            this.downstream.onError(t15);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            RxJavaPlugins.onError(new CompositeException(t15, ex4));
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.upstream == null) {
            this.onCompleteNoSubscription();
            return;
        }
        try {
            this.downstream.onComplete();
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            RxJavaPlugins.onError(e15);
        }
    }

    void onCompleteNoSubscription() {
        NullPointerException ex4 = new NullPointerException("Subscription not set!");
        try {
            this.downstream.onSubscribe(EmptySubscription.INSTANCE);
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            RxJavaPlugins.onError(new CompositeException(ex4, e15));
            return;
        }
        try {
            this.downstream.onError(ex4);
        }
        catch (Throwable e16) {
            Exceptions.throwIfFatal(e16);
            RxJavaPlugins.onError(new CompositeException(ex4, e16));
        }
    }

    @Override
    public void request(long n15) {
        try {
            this.upstream.request(n15);
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            try {
                this.upstream.cancel();
            }
            catch (Throwable e16) {
                Exceptions.throwIfFatal(e16);
                RxJavaPlugins.onError(new CompositeException(e15, e16));
                return;
            }
            RxJavaPlugins.onError(e15);
        }
    }

    @Override
    public void cancel() {
        try {
            this.upstream.cancel();
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            RxJavaPlugins.onError(e15);
        }
    }
}

