/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.util;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.BooleanSupplier;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ObservableQueueDrain;
import io.reactivex.rxjava3.internal.util.QueueDrain;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class QueueDrainHelper {
    static final long COMPLETED_MASK = Long.MIN_VALUE;
    static final long REQUESTED_MASK = Long.MAX_VALUE;

    private QueueDrainHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static <T, U> void drainMaxLoop(SimplePlainQueue<T> q15, Subscriber<? super U> a15, boolean delayError, Disposable dispose, QueueDrain<T, U> qd5) {
        int missed = 1;
        while (true) {
            boolean empty;
            boolean d15 = qd5.done();
            T v15 = q15.poll();
            boolean bl4 = empty = v15 == null;
            if (QueueDrainHelper.checkTerminated(d15, empty, a15, delayError, q15, qd5)) {
                if (dispose != null) {
                    dispose.dispose();
                }
                return;
            }
            if (!empty) {
                long r15 = qd5.requested();
                if (r15 != 0L) {
                    if (!qd5.accept(a15, v15) || r15 == Long.MAX_VALUE) continue;
                    qd5.produced(1L);
                    continue;
                }
                q15.clear();
                if (dispose != null) {
                    dispose.dispose();
                }
                a15.onError(MissingBackpressureException.createDefault());
                return;
            }
            if ((missed = qd5.leave(-missed)) == 0) break;
        }
    }

    public static <T, U> boolean checkTerminated(boolean d15, boolean empty, Subscriber<?> s15, boolean delayError, SimpleQueue<?> q15, QueueDrain<T, U> qd5) {
        if (qd5.cancelled()) {
            q15.clear();
            return true;
        }
        if (d15) {
            if (delayError) {
                if (empty) {
                    Throwable err = qd5.error();
                    if (err != null) {
                        s15.onError(err);
                    } else {
                        s15.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable err = qd5.error();
                if (err != null) {
                    q15.clear();
                    s15.onError(err);
                    return true;
                }
                if (empty) {
                    s15.onComplete();
                    return true;
                }
            }
        }
        return false;
    }

    public static <T, U> void drainLoop(SimplePlainQueue<T> q15, Observer<? super U> a15, boolean delayError, Disposable dispose, ObservableQueueDrain<T, U> qd5) {
        int missed = 1;
        block0: do {
            if (QueueDrainHelper.checkTerminated(qd5.done(), q15.isEmpty(), a15, delayError, q15, dispose, qd5)) {
                return;
            }
            while (true) {
                boolean empty;
                boolean d15 = qd5.done();
                T v15 = q15.poll();
                boolean bl4 = empty = v15 == null;
                if (QueueDrainHelper.checkTerminated(d15, empty, a15, delayError, q15, dispose, qd5)) {
                    return;
                }
                if (empty) continue block0;
                qd5.accept(a15, v15);
            }
        } while ((missed = qd5.leave(-missed)) != 0);
    }

    public static <T, U> boolean checkTerminated(boolean d15, boolean empty, Observer<?> observer, boolean delayError, SimpleQueue<?> q15, Disposable disposable, ObservableQueueDrain<T, U> qd5) {
        if (qd5.cancelled()) {
            q15.clear();
            disposable.dispose();
            return true;
        }
        if (d15) {
            if (delayError) {
                if (empty) {
                    Throwable err;
                    if (disposable != null) {
                        disposable.dispose();
                    }
                    if ((err = qd5.error()) != null) {
                        observer.onError(err);
                    } else {
                        observer.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable err = qd5.error();
                if (err != null) {
                    q15.clear();
                    if (disposable != null) {
                        disposable.dispose();
                    }
                    observer.onError(err);
                    return true;
                }
                if (empty) {
                    if (disposable != null) {
                        disposable.dispose();
                    }
                    observer.onComplete();
                    return true;
                }
            }
        }
        return false;
    }

    public static <T> SimpleQueue<T> createQueue(int capacityHint) {
        if (capacityHint < 0) {
            return new SpscLinkedArrayQueue(-capacityHint);
        }
        return new SpscArrayQueue(capacityHint);
    }

    public static void request(Subscription s15, int prefetch) {
        s15.request(prefetch < 0 ? Long.MAX_VALUE : (long)prefetch);
    }

    public static <T> boolean postCompleteRequest(long n15, Subscriber<? super T> actual, Queue<T> queue, AtomicLong state, BooleanSupplier isCancelled) {
        long r05;
        long u15;
        long r15;
        while (!state.compareAndSet(r15 = state.get(), u15 = r15 & Long.MIN_VALUE | BackpressureHelper.addCap(r05 = r15 & Long.MAX_VALUE, n15))) {
        }
        if (r15 == Long.MIN_VALUE) {
            QueueDrainHelper.postCompleteDrain(n15 | Long.MIN_VALUE, actual, queue, state, isCancelled);
            return true;
        }
        return false;
    }

    static boolean isCancelled(BooleanSupplier cancelled) {
        try {
            return cancelled.getAsBoolean();
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            return true;
        }
    }

    static <T> boolean postCompleteDrain(long n15, Subscriber<? super T> actual, Queue<T> queue, AtomicLong state, BooleanSupplier isCancelled) {
        long e15 = n15 & Long.MIN_VALUE;
        while (true) {
            if (e15 != n15) {
                if (QueueDrainHelper.isCancelled(isCancelled)) {
                    return true;
                }
                T t15 = queue.poll();
                if (t15 == null) {
                    actual.onComplete();
                    return true;
                }
                actual.onNext(t15);
                ++e15;
                continue;
            }
            if (QueueDrainHelper.isCancelled(isCancelled)) {
                return true;
            }
            if (queue.isEmpty()) {
                actual.onComplete();
                return true;
            }
            n15 = state.get();
            if (n15 != e15) continue;
            n15 = state.addAndGet(-(e15 & Long.MAX_VALUE));
            if ((n15 & Long.MAX_VALUE) == 0L) {
                return false;
            }
            e15 = n15 & Long.MIN_VALUE;
        }
    }

    public static <T> void postComplete(Subscriber<? super T> actual, Queue<T> queue, AtomicLong state, BooleanSupplier isCancelled) {
        long u15;
        long r15;
        if (queue.isEmpty()) {
            actual.onComplete();
            return;
        }
        if (QueueDrainHelper.postCompleteDrain(state.get(), actual, queue, state, isCancelled)) {
            return;
        }
        do {
            if (((r15 = state.get()) & Long.MIN_VALUE) == 0L) continue;
            return;
        } while (!state.compareAndSet(r15, u15 = r15 | Long.MIN_VALUE));
        if (r15 != 0L) {
            QueueDrainHelper.postCompleteDrain(u15, actual, queue, state, isCancelled);
        }
    }
}

