/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscribers;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class DeferredScalarSubscriber<T, R>
extends DeferredScalarSubscription<R>
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = 2984505488220891551L;
    protected Subscription upstream;
    protected boolean hasValue;

    public DeferredScalarSubscriber(Subscriber<? super R> downstream) {
        super(downstream);
    }

    @Override
    public void onSubscribe(Subscription s15) {
        if (SubscriptionHelper.validate(this.upstream, s15)) {
            this.upstream = s15;
            this.downstream.onSubscribe(this);
            s15.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onError(Throwable t15) {
        this.value = null;
        this.downstream.onError(t15);
    }

    @Override
    public void onComplete() {
        if (this.hasValue) {
            this.complete(this.value);
        } else {
            this.downstream.onComplete();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.upstream.cancel();
    }
}

