/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class CompletableFromSupplier
extends Completable {
    final Supplier<?> supplier;

    public CompletableFromSupplier(Supplier<?> supplier) {
        this.supplier = supplier;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        Disposable d15 = Disposable.empty();
        observer.onSubscribe(d15);
        try {
            this.supplier.get();
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            if (!d15.isDisposed()) {
                observer.onError(e15);
            } else {
                RxJavaPlugins.onError(e15);
            }
            return;
        }
        if (!d15.isDisposed()) {
            observer.onComplete();
        }
    }
}

