/*
 * Decompiled with CFR 0.152.
 */
package hu.kazocsaba.imageviewer;

import hu.kazocsaba.imageviewer.ImageViewer;
import hu.kazocsaba.imageviewer.PixelModel;
import hu.kazocsaba.imageviewer.StatusBar;
import java.awt.Color;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PixelInfoStatusBar
extends StatusBar {
    private final JPanel statusBar;
    protected final JLabel label;
    private final Insets statusBarInsets;
    private PixelModel model;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PixelInfoStatusBar.this.update();
        }
    };
    private final ChangeListener modelListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e15) {
            PixelInfoStatusBar.this.update();
        }
    };

    public PixelInfoStatusBar() {
        this.statusBar = new JPanel();
        this.statusBar.setBorder(BorderFactory.createEtchedBorder());
        this.label = new JLabel("n/a");
        this.statusBar.add(this.label);
        this.statusBarInsets = this.statusBar.getInsets();
        this.setModel(new PixelModel());
    }

    public final void setModel(PixelModel newModel) {
        if (newModel == null) {
            throw new NullPointerException();
        }
        if (this.model != newModel) {
            if (this.model != null) {
                this.model.removeChangeListener(this.modelListener);
            }
            this.model = newModel;
            this.model.addChangeListener(this.modelListener);
            this.update();
        }
    }

    public PixelModel getModel() {
        return this.model;
    }

    @Override
    public final JComponent getComponent() {
        return this.statusBar;
    }

    public void setPixel(int x15, int y15) {
        this.model.set(x15, y15);
    }

    protected final void update() {
        BufferedImage image;
        BufferedImage bufferedImage = image = this.getImageViewer() == null ? null : this.getImageViewer().getImage();
        if (image == null || this.model.isInvalid() || this.model.getX() >= image.getWidth() || this.model.getY() >= image.getHeight()) {
            this.updateLabelNoData();
        } else {
            this.updateLabel(image, this.model.getX(), this.model.getY(), this.statusBar.getWidth() - this.statusBarInsets.left - this.statusBarInsets.right);
        }
    }

    protected void updateLabelNoData() {
        this.label.setText("n/a");
    }

    protected void updateLabel(BufferedImage image, int x15, int y15, int availableWidth) {
        Color c15;
        int rgb;
        if (image.getRaster().getNumBands() == 1) {
            this.label.setText(String.format("%d, %d; intensity %d", x15, y15, image.getRaster().getSample(x15, y15, 0)));
        } else if (image.getRaster().getNumBands() == 4) {
            rgb = image.getRGB(x15, y15);
            c15 = new Color(rgb, true);
            this.label.setText(String.format("%d, %d; color %d,%d,%d, alpha %d", x15, y15, c15.getRed(), c15.getGreen(), c15.getBlue(), c15.getAlpha()));
        } else {
            rgb = image.getRGB(x15, y15);
            c15 = new Color(rgb);
            this.label.setText(String.format("%d, %d; color %d,%d,%d", x15, y15, c15.getRed(), c15.getGreen(), c15.getBlue()));
        }
        if (availableWidth < this.label.getPreferredSize().width) {
            if (image.getRaster().getNumBands() == 1) {
                this.label.setText(String.format("%d, %d; %d", x15, y15, image.getRaster().getSample(x15, y15, 0)));
            } else if (image.getRaster().getNumBands() == 4) {
                rgb = image.getRGB(x15, y15);
                c15 = new Color(rgb, true);
                this.label.setText(String.format("%d, %d; (%d,%d,%d,%d)", x15, y15, c15.getRed(), c15.getGreen(), c15.getBlue(), c15.getAlpha()));
            } else {
                rgb = image.getRGB(x15, y15);
                c15 = new Color(rgb);
                this.label.setText(String.format("%d, %d; (%d,%d,%d)", x15, y15, c15.getRed(), c15.getGreen(), c15.getBlue()));
            }
        }
    }

    @Override
    protected void register(ImageViewer viewer) {
        viewer.addPropertyChangeListener("image", this.propertyChangeListener);
        this.update();
    }

    @Override
    protected void unregister(ImageViewer viewer) {
        viewer.removePropertyChangeListener("image", this.propertyChangeListener);
    }
}

