/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.ICCProfileSanitizer;
import com.twelvemonkeys.lang.Validate;
import java.awt.color.ICC_Profile;

final class KCMSSanitizerStrategy
implements ICCProfileSanitizer {
    private static final int CORBIS_RGB_ALTERNATE_XYZ = 396690872;

    KCMSSanitizerStrategy() {
    }

    @Override
    public void fixProfile(ICC_Profile iCC_Profile) {
        Validate.notNull(iCC_Profile, "profile");
        byte[] byArray = iCC_Profile.getData(1751474532);
        if (KCMSSanitizerStrategy.intFromBigEndian(byArray, 64) != 0) {
            KCMSSanitizerStrategy.intToBigEndian(0, byArray, 64);
            iCC_Profile.setData(1751474532, byArray);
        }
        if (KCMSSanitizerStrategy.fixProfileXYZTag(iCC_Profile, 0x77747074)) {
            KCMSSanitizerStrategy.fixProfileXYZTag(iCC_Profile, 1918392666);
            KCMSSanitizerStrategy.fixProfileXYZTag(iCC_Profile, 1733843290);
            KCMSSanitizerStrategy.fixProfileXYZTag(iCC_Profile, 1649957210);
        }
    }

    @Override
    public boolean validationAltersProfileHeader() {
        return false;
    }

    private static boolean fixProfileXYZTag(ICC_Profile iCC_Profile, int n15) {
        byte[] byArray = iCC_Profile.getData(n15);
        if (byArray != null && KCMSSanitizerStrategy.intFromBigEndian(byArray, 0) == 396690872) {
            KCMSSanitizerStrategy.intToBigEndian(1482250784, byArray, 0);
            iCC_Profile.setData(n15, byArray);
            return true;
        }
        return false;
    }

    private static int intFromBigEndian(byte[] byArray, int n15) {
        return (byArray[n15] & 0xFF) << 24 | (byArray[n15 + 1] & 0xFF) << 16 | (byArray[n15 + 2] & 0xFF) << 8 | byArray[n15 + 3] & 0xFF;
    }

    private static void intToBigEndian(int n15, byte[] byArray, int n16) {
        byArray[n16] = (byte)(n15 >> 24);
        byArray[n16 + 1] = (byte)(n15 >> 16);
        byArray[n16 + 2] = (byte)(n15 >> 8);
        byArray[n16 + 3] = (byte)n15;
    }
}

