/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableLongArray;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

@GwtIncompatible
@J2ktIncompatible
public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient AtomicLongArray longs;

    public AtomicDoubleArray(int length) {
        this.longs = new AtomicLongArray(length);
    }

    public AtomicDoubleArray(double[] array) {
        int len = array.length;
        long[] longArray = new long[len];
        for (int i15 = 0; i15 < len; ++i15) {
            longArray[i15] = Double.doubleToRawLongBits(array[i15]);
        }
        this.longs = new AtomicLongArray(longArray);
    }

    public final int length() {
        return this.longs.length();
    }

    public final double get(int i15) {
        return Double.longBitsToDouble(this.longs.get(i15));
    }

    public final void set(int i15, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.set(i15, next);
    }

    public final void lazySet(int i15, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.lazySet(i15, next);
    }

    public final double getAndSet(int i15, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(this.longs.getAndSet(i15, next));
    }

    public final boolean compareAndSet(int i15, double expect, double update) {
        return this.longs.compareAndSet(i15, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public final boolean weakCompareAndSet(int i15, double expect, double update) {
        return this.longs.weakCompareAndSet(i15, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    @CanIgnoreReturnValue
    public final double getAndAdd(int i15, double delta) {
        return this.getAndAccumulate(i15, delta, Double::sum);
    }

    @CanIgnoreReturnValue
    public double addAndGet(int i15, double delta) {
        return this.accumulateAndGet(i15, delta, Double::sum);
    }

    @CanIgnoreReturnValue
    public final double getAndAccumulate(int i15, double x15, DoubleBinaryOperator accumulatorFunction) {
        Preconditions.checkNotNull(accumulatorFunction);
        return this.getAndUpdate(i15, oldValue -> accumulatorFunction.applyAsDouble(oldValue, x15));
    }

    @CanIgnoreReturnValue
    public final double accumulateAndGet(int i15, double x15, DoubleBinaryOperator accumulatorFunction) {
        Preconditions.checkNotNull(accumulatorFunction);
        return this.updateAndGet(i15, oldValue -> accumulatorFunction.applyAsDouble(oldValue, x15));
    }

    @CanIgnoreReturnValue
    public final double getAndUpdate(int i15, DoubleUnaryOperator updaterFunction) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!this.longs.compareAndSet(i15, current = this.longs.get(i15), next = Double.doubleToRawLongBits(nextVal = updaterFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current))))) {
        }
        return currentVal;
    }

    @CanIgnoreReturnValue
    public final double updateAndGet(int i15, DoubleUnaryOperator updaterFunction) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!this.longs.compareAndSet(i15, current = this.longs.get(i15), next = Double.doubleToRawLongBits(nextVal = updaterFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current))))) {
        }
        return nextVal;
    }

    public String toString() {
        int iMax = this.length() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b15 = new StringBuilder(19 * (iMax + 1));
        b15.append('[');
        int i15 = 0;
        while (true) {
            b15.append(Double.longBitsToDouble(this.longs.get(i15)));
            if (i15 == iMax) {
                return b15.append(']').toString();
            }
            b15.append(',').append(' ');
            ++i15;
        }
    }

    private void writeObject(ObjectOutputStream s15) throws IOException {
        s15.defaultWriteObject();
        int length = this.length();
        s15.writeInt(length);
        for (int i15 = 0; i15 < length; ++i15) {
            s15.writeDouble(this.get(i15));
        }
    }

    private void readObject(ObjectInputStream s15) throws IOException, ClassNotFoundException {
        s15.defaultReadObject();
        int length = s15.readInt();
        ImmutableLongArray.Builder builder = ImmutableLongArray.builder();
        for (int i15 = 0; i15 < length; ++i15) {
            builder.add(Double.doubleToRawLongBits(s15.readDouble()));
        }
        this.longs = new AtomicLongArray(builder.build().toArray());
    }
}

