/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.google.common.primitives.ParseRequest;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;

@GwtCompatible
public final class UnsignedLongs {
    public static final long MAX_VALUE = -1L;

    private UnsignedLongs() {
    }

    private static long flip(long a15) {
        return a15 ^ Long.MIN_VALUE;
    }

    public static int compare(long a15, long b15) {
        return Longs.compare(UnsignedLongs.flip(a15), UnsignedLongs.flip(b15));
    }

    public static long min(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long min = UnsignedLongs.flip(array[0]);
        for (int i15 = 1; i15 < array.length; ++i15) {
            long next = UnsignedLongs.flip(array[i15]);
            if (next >= min) continue;
            min = next;
        }
        return UnsignedLongs.flip(min);
    }

    public static long max(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long max = UnsignedLongs.flip(array[0]);
        for (int i15 = 1; i15 < array.length; ++i15) {
            long next = UnsignedLongs.flip(array[i15]);
            if (next <= max) continue;
            max = next;
        }
        return UnsignedLongs.flip(max);
    }

    public static String join(String separator, long ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(UnsignedLongs.toString(array[0]));
        for (int i15 = 1; i15 < array.length; ++i15) {
            builder.append(separator).append(UnsignedLongs.toString(array[i15]));
        }
        return builder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(long[] array) {
        Preconditions.checkNotNull(array);
        UnsignedLongs.sort(array, 0, array.length);
    }

    public static void sort(long[] array, int fromIndex, int toIndex) {
        int i15;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (i15 = fromIndex; i15 < toIndex; ++i15) {
            array[i15] = UnsignedLongs.flip(array[i15]);
        }
        Arrays.sort(array, fromIndex, toIndex);
        for (i15 = fromIndex; i15 < toIndex; ++i15) {
            array[i15] = UnsignedLongs.flip(array[i15]);
        }
    }

    public static void sortDescending(long[] array) {
        Preconditions.checkNotNull(array);
        UnsignedLongs.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(long[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i15 = fromIndex;
        while (i15 < toIndex) {
            int n15 = i15++;
            array[n15] = array[n15] ^ Long.MAX_VALUE;
        }
        Arrays.sort(array, fromIndex, toIndex);
        i15 = fromIndex;
        while (i15 < toIndex) {
            int n16 = i15++;
            array[n16] = array[n16] ^ Long.MAX_VALUE;
        }
    }

    public static long divide(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(UnsignedLongs.compare(rem, divisor) >= 0 ? 1 : 0);
    }

    public static long remainder(long dividend, long divisor) {
        long rem;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return dividend;
            }
            return dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem - (UnsignedLongs.compare(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
    }

    @CanIgnoreReturnValue
    public static long parseUnsignedLong(String string) {
        return UnsignedLongs.parseUnsignedLong(string, 10);
    }

    @CanIgnoreReturnValue
    public static long parseUnsignedLong(String string, int radix) {
        Preconditions.checkNotNull(string);
        if (string.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("illegal radix: " + radix);
        }
        int maxSafePos = ParseOverflowDetection.maxSafeDigits[radix] - 1;
        long value = 0L;
        for (int pos = 0; pos < string.length(); ++pos) {
            int digit = Character.digit(string.charAt(pos), radix);
            if (digit == -1) {
                throw new NumberFormatException(string);
            }
            if (pos > maxSafePos && ParseOverflowDetection.overflowInParse(value, digit, radix)) {
                throw new NumberFormatException("Too large for unsigned long: " + string);
            }
            value = value * (long)radix + (long)digit;
        }
        return value;
    }

    @CanIgnoreReturnValue
    public static long decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedLongs.parseUnsignedLong(request.rawValue, request.radix);
        }
        catch (NumberFormatException e15) {
            NumberFormatException decodeException = new NumberFormatException("Error parsing value: " + stringValue);
            decodeException.initCause(e15);
            throw decodeException;
        }
    }

    public static String toString(long x15) {
        return UnsignedLongs.toString(x15, 10);
    }

    public static String toString(long x15, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        if (x15 == 0L) {
            return "0";
        }
        if (x15 > 0L) {
            return Long.toString(x15, radix);
        }
        char[] buf = new char[64];
        int i15 = buf.length;
        if ((radix & radix - 1) == 0) {
            int shift = Integer.numberOfTrailingZeros(radix);
            int mask = radix - 1;
            do {
                buf[--i15] = Character.forDigit((int)x15 & mask, radix);
            } while ((x15 >>>= shift) != 0L);
        } else {
            long quotient = (radix & 1) == 0 ? (x15 >>> 1) / (long)(radix >>> 1) : UnsignedLongs.divide(x15, radix);
            long rem = x15 - quotient * (long)radix;
            buf[--i15] = Character.forDigit((int)rem, radix);
            for (x15 = quotient; x15 > 0L; x15 /= (long)radix) {
                buf[--i15] = Character.forDigit((int)(x15 % (long)radix), radix);
            }
        }
        return new String(buf, i15, buf.length - i15);
    }

    static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left, long[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i15 = 0; i15 < minLength; ++i15) {
                if (left[i15] == right[i15]) continue;
                return UnsignedLongs.compare(left[i15], right[i15]);
            }
            return left.length - right.length;
        }

        public String toString() {
            return "UnsignedLongs.lexicographicalComparator()";
        }
    }

    private static final class ParseOverflowDetection {
        static final long[] maxValueDivs = new long[37];
        static final int[] maxValueMods = new int[37];
        static final int[] maxSafeDigits = new int[37];

        private ParseOverflowDetection() {
        }

        static boolean overflowInParse(long current, int digit, int radix) {
            if (current >= 0L) {
                if (current < maxValueDivs[radix]) {
                    return false;
                }
                if (current > maxValueDivs[radix]) {
                    return true;
                }
                return digit > maxValueMods[radix];
            }
            return true;
        }

        static {
            BigInteger overflow = BigInteger.ONE.shiftLeft(64);
            for (int i15 = 2; i15 <= 36; ++i15) {
                ParseOverflowDetection.maxValueDivs[i15] = UnsignedLongs.divide(-1L, i15);
                ParseOverflowDetection.maxValueMods[i15] = (int)UnsignedLongs.remainder(-1L, i15);
                ParseOverflowDetection.maxSafeDigits[i15] = overflow.toString(i15).length() - 1;
            }
        }
    }
}

