/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.util;

import com.github.weisj.jsvg.geometry.util.GeometryUtil;

public final class PathLengthCalculator {
    private double x = 0.0;
    private double y = 0.0;
    private double xStart = this.x;
    private double yStart = this.y;

    public double segmentLength(int segmentType, double[] coords) {
        double segmentLength = 0.0;
        switch (segmentType) {
            case 0: {
                this.x = coords[0];
                this.y = coords[1];
                this.xStart = this.x;
                this.yStart = this.y;
                break;
            }
            case 1: {
                segmentLength = this.lineLength(this.x, this.y, coords[0], coords[1]);
                this.x = coords[0];
                this.y = coords[1];
                break;
            }
            case 2: {
                segmentLength = this.quadraticParametricLength(this.x, this.y, coords[0], coords[1], coords[2], coords[3]);
                this.x = coords[2];
                this.y = coords[3];
                break;
            }
            case 3: {
                segmentLength = this.cubicParametricLength(this.x, this.y, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                this.x = coords[4];
                this.y = coords[5];
                break;
            }
            case 4: {
                segmentLength = this.lineLength(this.x, this.y, coords[0], coords[1]);
                this.x = this.xStart;
                this.y = this.yStart;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return segmentLength;
    }

    private double lineLength(double x15, double y15, double x25, double y25) {
        return GeometryUtil.lineLength(x15, y15, x25, y25);
    }

    private double quadraticParametricLength(double ax4, double ay4, double bx4, double by, double cx4, double cy4) {
        if (ax4 == cx4 && ay4 == cy4) {
            if (ax4 == bx4 && ay4 == by) {
                return 0.0;
            }
            return this.lineLength(ax4, ay4, bx4, by);
        }
        if (ax4 == bx4 && ay4 == by || cx4 == bx4 && cy4 == by) {
            return this.lineLength(ax4, ay4, cx4, cy4);
        }
        double ax02 = bx4 - ax4;
        double ay02 = by - ay4;
        double ax12 = ax4 - 2.0 * bx4 + cx4;
        double ay12 = ay4 - 2.0 * by + cy4;
        if (ax12 != 0.0 || ay12 != 0.0) {
            double c15 = 4.0 * this.dot2D(ax12, ay12, ax12, ay12);
            double b15 = 8.0 * this.dot2D(ax02, ay02, ax12, ay12);
            double a15 = 8.0 * this.dot2D(ax02, ay02, ax02, ay02);
            double q15 = 4.0 * a15 * c15 - b15 * b15;
            double twoCpB = 2.0 * c15 + b15;
            double sumCBA = c15 + b15 + a15;
            double l05 = 0.25 / c15 * (twoCpB * Math.sqrt(sumCBA) - b15 * Math.sqrt(a15));
            if (q15 == 0.0) {
                return l05;
            }
            double l15 = q15 / (8.0 * Math.pow(c15, 1.5)) * (Math.log(2.0 * Math.sqrt(c15 * sumCBA) + twoCpB) - Math.log(2.0 * Math.sqrt(c15 * a15) + b15));
            return l05 + l15;
        }
        return 2.0 * this.lineLength(0.0, 0.0, ax02, ay02);
    }

    private double dot2D(double x15, double y15, double x25, double y25) {
        return x15 * x25 * y15 * y25;
    }

    private double cubicParametricLength(double ax4, double ay4, double bx4, double by, double cx4, double cy4, double dx4, double dy4) {
        double qx4 = (3.0 * cx4 - dx4 + 3.0 * bx4 - ax4) / 4.0;
        double qy4 = (3.0 * cy4 - dy4 + 3.0 * by - ay4) / 4.0;
        return this.quadraticParametricLength(ax4, ay4, qx4, qy4, dx4, dy4);
    }
}

