/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.Animator;
import com.formdev.flatlaf.util.CubicBezierEasing;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;

public interface AnimatedIcon
extends Icon {
    @Override
    default public void paintIcon(Component c15, Graphics g15, int x15, int y15) {
        AnimationSupport.paintIcon(this, c15, g15, x15, y15);
    }

    public void paintIconAnimated(Component var1, Graphics var2, int var3, int var4, float var5);

    public float getValue(Component var1);

    default public boolean isAnimationEnabled() {
        return true;
    }

    default public int getAnimationDuration() {
        return 150;
    }

    default public int getAnimationResolution() {
        return 10;
    }

    default public Animator.Interpolator getAnimationInterpolator() {
        return CubicBezierEasing.STANDARD_EASING;
    }

    default public Object getClientPropertyKey() {
        return this.getClass();
    }

    public static class AnimationSupport {
        private float startValue;
        private float targetValue;
        private float animatedValue;
        private float fraction;
        private Animator animator;
        private int x;
        private int y;

        public static void paintIcon(AnimatedIcon icon, Component c15, Graphics g15, int x15, int y15) {
            if (!AnimationSupport.isAnimationEnabled(icon, c15)) {
                AnimationSupport.paintIconImpl(icon, c15, g15, x15, y15, null);
                return;
            }
            JComponent jc5 = (JComponent)c15;
            Object key = icon.getClientPropertyKey();
            AnimationSupport as4 = (AnimationSupport)jc5.getClientProperty(key);
            if (as4 == null) {
                as4 = new AnimationSupport();
                as4.targetValue = as4.animatedValue = icon.getValue(c15);
                as4.startValue = as4.animatedValue;
                as4.x = x15;
                as4.y = y15;
                jc5.putClientProperty(key, as4);
            } else {
                float value = icon.getValue(c15);
                if (value != as4.targetValue) {
                    if (as4.animator == null) {
                        AnimationSupport as22 = as4;
                        as4.animator = new Animator(icon.getAnimationDuration(), fraction -> {
                            if (!c15.isDisplayable()) {
                                as22.animator.stop();
                                return;
                            }
                            as22.animatedValue = as22.startValue + (as22.targetValue - as22.startValue) * fraction;
                            as22.fraction = fraction;
                            c15.repaint(as22.x, as22.y, icon.getIconWidth(), icon.getIconHeight());
                        }, () -> {
                            as22.startValue = as22.animatedValue = as22.targetValue;
                            as22.animator = null;
                        });
                    }
                    if (as4.animator.isRunning()) {
                        as4.animator.cancel();
                        int duration2 = (int)((float)icon.getAnimationDuration() * as4.fraction);
                        if (duration2 > 0) {
                            as4.animator.setDuration(duration2);
                        }
                        as4.startValue = as4.animatedValue;
                    } else {
                        as4.animator.setDuration(icon.getAnimationDuration());
                        as4.animator.setResolution(icon.getAnimationResolution());
                        as4.animator.setInterpolator(icon.getAnimationInterpolator());
                        as4.animatedValue = as4.startValue;
                    }
                    as4.targetValue = value;
                    as4.animator.start();
                }
                as4.x = x15;
                as4.y = y15;
            }
            AnimationSupport.paintIconImpl(icon, c15, g15, x15, y15, as4);
        }

        private static void paintIconImpl(AnimatedIcon icon, Component c15, Graphics g15, int x15, int y15, AnimationSupport as4) {
            float value = as4 != null ? as4.animatedValue : icon.getValue(c15);
            icon.paintIconAnimated(c15, g15, x15, y15, value);
        }

        private static boolean isAnimationEnabled(AnimatedIcon icon, Component c15) {
            return Animator.useAnimation() && icon.isAnimationEnabled() && c15 instanceof JComponent;
        }

        public static void saveIconLocation(AnimatedIcon icon, Component c15, int x15, int y15) {
            if (!AnimationSupport.isAnimationEnabled(icon, c15)) {
                return;
            }
            AnimationSupport as4 = (AnimationSupport)((JComponent)c15).getClientProperty(icon.getClientPropertyKey());
            if (as4 != null) {
                as4.x = x15;
                as4.y = y15;
            }
        }
    }
}

